/* 
 * Copyright 2007 Tatooine Project <http://tatooine.sourceforge.jp/> 
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *     http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.tatooine.gtx.node;


import jp.sf.tatooine.gtx.GtxContext;
import jp.sf.tatooine.gtx.GtxSyntaxException;

/**
 * CommentNode.
 *
 * @author  Tooru Noda
 * @version 1.0 2007/09/10
 * @since   JDK5.0 Tiger
 */
public class CommentNode extends Node {

	public static final String COMMENT_PREFIX = "<!--"; 

	public static final String COMMENT_POSTFIX = "-->";
	
	private boolean _ignoreComment = false;

	/** コメント値 */
	private String _value;
	
	/**
	 * コメント値を設定する.
	 * 
	 * @param value		コメント値
	 */
	public void setValue(String value) {
		_value = value;
	}

	public void setIgnoreComment(boolean ignoreComment) {
		_ignoreComment = ignoreComment;
	}
	
	/**
	 * @see jp.sf.tatooine.gtx.node.GtxEvaluateable
	 * 		#evaluate(StringBuilder, jp.sf.tatooine.gtx.GtxContext)
	 */
	public void evaluate(StringBuilder builder, GtxContext context) throws GtxSyntaxException {
		if (_ignoreComment) {
			return;
		}
		builder.append(toString());
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append(COMMENT_PREFIX);
		builder.append(_value);
		builder.append(COMMENT_POSTFIX);
		return builder.toString();
	}

}
