/* 
 * Copyright 2007 Tatooine Project <http://tatooine.sourceforge.jp/> 
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *     http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.tatooine.gtx.node;

import jp.sf.tatooine.gtx.GtxConsts;

/**
 * GtxIgnore.
 *
 * @author  Tooru Noda
 * @version 1.0 2007/09/11
 * @since   JDK5.0 Tiger
 */
public class GtxIgnore extends GtxAttribute {
	
	/**
	 * コンストラクタ.
	 * 
	 * @param prefix	名前空間プレフィックス
	 * @param value		属性値
	 */
	public GtxIgnore(String prefix, String value) {
		super(GtxAttributeType.IGNORE, prefix, GtxConsts.IGNORE, value);
	}
	
}
