/* 
 * Copyright 2007 Tatooine Project <http://tatooine.sourceforge.jp/> 
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *     http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.tatooine.gtx.filter;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.commons.lang.ArrayUtils;

import jp.sf.tatooine.gtx.Filter;

/**
 * DateFormat.
 *
 * @author  Tooru Noda
 * @version 1.0 2007/08/10
 * @since   JDK5.0 Tiger
 */
public class DateFormat implements Filter {

	/**
	 * @see jp.sf.tatooine.gtx.Filter#invoke(java.lang.String, java.lang.String[])
	 */
	public String invoke(String value, String[] args) {
		
		if (args.length != 1) {
			throw new IllegalArgumentException("引数が合致しません。date_format(pattern):" + ArrayUtils.toString(args));
		}
		Date date = null;
		System.out.println(value);
		SimpleDateFormat format = new SimpleDateFormat(args[0]);
		SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd hh:mm:ss z yyyy");
		date = sdf.parse(value, new java.text.ParsePosition(0));
		System.out.println(value);
		System.out.println(date);
//		try {
//			date = java.text.DateFormat.getDateInstance().parse(value);
//		}
//		catch (ParseException e) {
//			throw new RuntimeException(e);
//		}
		return format.format(date);
	}

}
