var FormUtils = {
	activate: function() {
		for (var i = 0; i < arguments.length; i++) {
			var arg = arguments[i];
			this.setDisabled(arg, false);
		}
	},
	inactivate: function() {
		for (var i = 0; i < arguments.length; i++) {
			var arg = arguments[i];
			this.setDisabled(arg, true);
		}
	},
	setDisabled: function(arg, disabled) {
		if (arg instanceof Array) {
			for (var i = 0; i < arg.length; i++) {
				this.setDisabled(arg[i], disabled);
			}
		}
		else {
			var list = [];
			var form = null;
			if (typeof arg == 'string') {
				form = document.getElementById(arg);
			}
			else {
				form = arg;
			}
			if (form != null) {
				var divs = form.getElementsByTagName("div");
				for (var i = 0; i < divs.length; i++) {
					list.push(divs[i]);
				}
				var inputs = form.getElementsByTagName("input");
				for (var i = 0; i < inputs.length; i++) {
					list.push(inputs[i]);
				}
				var textareas = form.getElementsByTagName("textarea");
				for (var i = 0; i < textareas.length; i++) {
					list.push(textareas[i]);
				}
				var selects = form.getElementsByTagName("select");
				for (var i = 0; i < selects.length; i++) {
					list.push(selects[i]);
				}
				var labels = form.getElementsByTagName("label");
				for (var i = 0; i < labels.length; i++) {
					list.push(labels[i]);
				}
				list.push(form);
			}
			for (var i = 0; i < list.length; i++) {
				var item = list[i];
				if (disabled) {
					this.doInactivate(item);
				}
				else {
					this.doActivate(item);
				}
			}
		}
	},
	doActivate: function(elm) {
		elm.disabled = false;
	},
	doInactivate: function(elm) {
		elm.disabled = true;
	}
}
