/*
 * Decompiled with CFR 0.152.
 */
package goooooooooosuke.tddsupport.plugin.action;

import goooooooooosuke.tddsupport.plugin.Activator;
import goooooooooosuke.tddsupport.plugin.NamingRules;
import goooooooooosuke.tddsupport.plugin.PairClassFinder;
import goooooooooosuke.tddsupport.plugin.PairMethodFinder;
import goooooooooosuke.tddsupport.plugin.action.OpenPairAction;
import goooooooooosuke.tddsupport.plugin.nls.Messages;
import goooooooooosuke.tddsupport.plugin.widgets.ItemSelectionDialog;
import goooooooooosuke.tddsupport.plugin.widgets.PairMethodLabelProvider;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenPairMethodAction
extends OpenPairAction<IMethod> {
    @Override
    protected IMethod getTargetFromEditor() throws JavaModelException {
        IMethod target = null;
        IWorkbenchPage activePage = Activator.getDefault().getActivePage();
        if (activePage.getActivePart() instanceof ITextEditor) {
            int offset;
            IJavaElement elem;
            ICompilationUnit compilationUnit = (ICompilationUnit)JavaUI.getEditorInputJavaElement((IEditorInput)activePage.getActiveEditor().getEditorInput());
            ISelection selection = ((ITextEditor)activePage.getActiveEditor()).getSelectionProvider().getSelection();
            if (selection instanceof ITextSelection && (elem = compilationUnit.getElementAt(offset = ((ITextSelection)selection).getOffset())) != null && elem.getElementType() == 9) {
                target = (IMethod)elem;
            }
        }
        return target;
    }

    @Override
    protected IMethod getTargetFromView() {
        return this.javaElement != null && this.javaElement.getElementType() == 9 ? (IMethod)this.javaElement : null;
    }

    public void run(IAction action) {
        try {
            List<IMethod> pairMethodList;
            IMethod target = (IMethod)this.getTarget();
            if (target == null) {
                IWorkbenchPart part = Activator.getDefault().getActivePage().getActivePart();
                if (part instanceof IEditorPart) {
                    ((IEditorPart)part).getEditorSite().getActionBars().getStatusLineManager().setMessage(Activator.imageDescriptorFromPlugin((String)Activator.getDefault().getPluginId(), (String)"/icons/warn.gif").createImage(), Messages.OpenPairMethodAction_NotFound);
                }
                return;
            }
            IType targetClass = (IType)target.getAncestor(7);
            IPreferenceStore preferenceStore = this.getPreferenceStore(target.getJavaProject().getProject());
            PairClassFinder pairClassFinder = new PairClassFinder(preferenceStore.getString("javaSrcFolder"), preferenceStore.getString("testSrcFolder"), new NamingRules(preferenceStore.getString("testClassNamingRules")));
            PairMethodFinder pairMethodFinder = new PairMethodFinder(new NamingRules(preferenceStore.getString("testMethodNamingRules")));
            boolean isTestClass = pairClassFinder.isTestClass(targetClass);
            int flags = target.getFlags();
            if (isTestClass) {
                if (!(pairMethodFinder.isTestMethod(target) && Flags.isPublic((int)flags) && target.getReturnType().equals("V") && target.getNumberOfParameters() == 0)) {
                    MessageDialog.openError((Shell)Activator.getDefault().getShell(), (String)action.getText(), (String)Messages.OpenPairMethodAction_Error_NotTestMethod);
                    return;
                }
            } else if (Flags.isPrivate((int)flags) || Flags.isAbstract((int)flags)) {
                MessageDialog.openError((Shell)Activator.getDefault().getShell(), (String)action.getText(), (String)Messages.OpenPairMethodAction_Error_NotTestableMethod);
                return;
            }
            List<IType> pairClassList = isTestClass ? pairClassFinder.findPairClass(targetClass) : pairClassFinder.findPairTestClass(targetClass);
            IType selectionClass = null;
            if (pairClassList.isEmpty()) {
                if (MessageDialog.openQuestion((Shell)Activator.getDefault().getShell(), (String)action.getText(), (String)(isTestClass ? Messages.OpenPairClassAction_Question_Create_Java : Messages.OpenPairClassAction_Question_Create_Test))) {
                    IType creationClass = pairClassFinder.getCreationClass(targetClass);
                    if (isTestClass) {
                        this.openNewClassCreationWizard(creationClass);
                    } else {
                        this.openNewTestClassCreationWizard(creationClass, targetClass);
                    }
                }
            } else {
                selectionClass = this.selectPairClass(action, pairClassList);
            }
            if (selectionClass == null) {
                return;
            }
            List<IMethod> list = pairMethodList = isTestClass ? pairMethodFinder.findPairMethod(target, selectionClass) : pairMethodFinder.findPairTestMethod(target, selectionClass);
            if (pairMethodList.isEmpty()) {
                if (isTestClass) {
                    MessageDialog.openError((Shell)Activator.getDefault().getShell(), (String)action.getText(), (String)Messages.OpenPairMethodAction_Error_NotExist);
                    return;
                }
                if (MessageDialog.openQuestion((Shell)Activator.getDefault().getShell(), (String)action.getText(), (String)Messages.OpenPairMethodAction_Question_Create_Test)) {
                    this.createTestMethod(pairMethodFinder.getCreationTestMethod(target, selectionClass), selectionClass);
                }
            } else {
                IMethod selectionMethod = this.selectPairMethod(action, pairMethodList);
                if (selectionMethod == null) {
                    return;
                }
                JavaUI.openInEditor((IJavaElement)selectionMethod);
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e);
        }
    }

    private IMethod selectPairMethod(IAction action, List<IMethod> pairMethodList) {
        IMethod selection = null;
        if (pairMethodList.size() > 1) {
            ItemSelectionDialog dialog = new ItemSelectionDialog(Activator.getDefault().getShell(), action.getText(), action.getActionDefinitionId(), pairMethodList, new PairMethodLabelProvider());
            selection = (IMethod)dialog.open();
        } else {
            selection = pairMethodList.get(0);
        }
        return selection;
    }

    private void createTestMethod(IMethod creationMethod, IType type) throws JavaModelException, PartInitException {
        StringBuilder sb = new StringBuilder();
        if (this.isJUnit4(type)) {
            if (!type.getCompilationUnit().getImport("junit.framework.Assert.fail").exists()) {
                type.getCompilationUnit().createImport("junit.framework.Assert.fail", null, 8, null);
            }
            if (!type.getCompilationUnit().getImport("org.junit.Test").exists()) {
                type.getCompilationUnit().createImport("org.junit.Test", null, 0, null);
            }
            sb.append("@Test").append(type.getCompilationUnit().findRecommendedLineSeparator());
        }
        sb.append("public ");
        sb.append("void ");
        sb.append(creationMethod.getElementName());
        sb.append("()");
        this.appendTestMethodBody(sb, type.getCompilationUnit());
        String formattedContent = CodeFormatterUtil.format((int)4, (String)sb.toString(), (int)0, (String)type.getCompilationUnit().findRecommendedLineSeparator(), (IJavaProject)type.getJavaProject());
        formattedContent = Strings.trimLeadingTabsAndSpaces((String)formattedContent);
        IMethod createdMethod = type.createMethod(formattedContent, null, true, null);
        JavaUI.openInEditor((IJavaElement)createdMethod);
    }

    private boolean isJUnit4(IType type) throws JavaModelException {
        return type.getJavaProject().findType("org.junit.Test") != null;
    }

    private void appendTestMethodBody(StringBuilder sb, ICompilationUnit targetCu) throws JavaModelException {
        String delimiter = targetCu.findRecommendedLineSeparator();
        sb.append('{').append(delimiter);
        String todoTask = "";
        String todoTaskTag = OpenPairMethodAction.getTodoTaskTag(targetCu.getJavaProject());
        if (todoTaskTag != null) {
            todoTask = " // " + todoTaskTag;
            todoTask = MessageFormat.format(" // " + todoTaskTag + " {0}", Messages.OpenPairMethodAction_Auto_generated_method_stub);
        }
        sb.append(todoTask).append(delimiter);
        sb.append(MessageFormat.format("fail(\"{0}\");", Messages.OpenPairMethodAction_Not_yet_implemented)).append(delimiter);
        sb.append('}').append(delimiter);
    }

    private static String getTodoTaskTag(IJavaProject project) {
        String markers = null;
        markers = project == null ? JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.taskTags") : project.getOption("org.eclipse.jdt.core.compiler.taskTags", true);
        if (markers != null && markers.length() > 0) {
            int idx = markers.indexOf(44);
            if (idx == -1) {
                return markers;
            }
            return markers.substring(0, idx);
        }
        return null;
    }
}

