/*
 * Decompiled with CFR 0.152.
 */
package goooooooooosuke.tddsupport.plugin.widgets;

import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.keys.IBindingService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemSelectionDialog {
    private static final int MAX_ITEMS = 22;
    private Shell dialog;
    private TableViewer viewer;
    private IJavaElement selection;
    private TriggerSequence[] triggerSequences;

    public ItemSelectionDialog(Shell parentShell, String title, String actionId, List<?> itemList, LabelProvider labelProvider) {
        this.dialog = new Shell(parentShell, 0);
        this.dialog.setLayout((Layout)new FillLayout());
        this.viewer = new TableViewer((Composite)this.dialog, 65540);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        TableColumn column = new TableColumn(this.viewer.getTable(), 0);
        column.setResizable(false);
        column.setText(title);
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setContentProvider((IContentProvider)new ItemSelectionTableContentProvider());
        this.viewer.setInput(itemList);
        this.viewer.getTable().setSelection(0);
        column.pack();
        this.viewer.getTable().pack();
        this.dialog.pack();
        Rectangle tableBounds = this.viewer.getTable().getBounds();
        tableBounds.height = Math.min(tableBounds.height, this.viewer.getTable().getItemHeight() * 22);
        this.viewer.getTable().setBounds(tableBounds);
        this.dialog.setBounds(this.dialog.computeTrim(tableBounds.x, tableBounds.y, tableBounds.width, tableBounds.height));
        column.setWidth(this.viewer.getTable().getClientArea().width);
        this.viewer.getTable().setFocus();
        Rectangle dialogBounds = this.dialog.getBounds();
        Rectangle parentBounds = this.dialog.getParent().getBounds();
        Rectangle monitorBounds = this.dialog.getDisplay().getPrimaryMonitor().getBounds();
        dialogBounds.x = parentBounds.x + (parentBounds.width - dialogBounds.width) / 2;
        dialogBounds.y = parentBounds.y + (parentBounds.height - dialogBounds.height) / 2;
        if (!monitorBounds.contains(dialogBounds.x, dialogBounds.y) || !monitorBounds.contains(dialogBounds.x + dialogBounds.width, dialogBounds.y + dialogBounds.height)) {
            dialogBounds.x = monitorBounds.x + (monitorBounds.width - dialogBounds.width) / 2;
            dialogBounds.y = monitorBounds.y + (monitorBounds.height - dialogBounds.height) / 2;
        }
        this.dialog.setLocation(dialogBounds.x, dialogBounds.y);
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        this.triggerSequences = bindingService.getActiveBindingsFor(actionId);
        this.viewer.getTable().addMouseListener((MouseListener)new ItemSelectionTableMouseListener());
        this.viewer.getTable().addFocusListener((FocusListener)new ItemSelectionTableFocusListener());
        this.viewer.getTable().addTraverseListener((TraverseListener)new ItemSelectionTableTraverseListener());
        this.viewer.getTable().addKeyListener((KeyListener)new ItemSelectionTableKeyListener());
    }

    public IJavaElement open() {
        try {
            this.dialog.open();
            while (!this.dialog.isDisposed()) {
                if (this.dialog.getDisplay().readAndDispatch()) continue;
                this.dialog.getDisplay().sleep();
            }
        }
        finally {
            if (!this.dialog.isDisposed()) {
                this.cancel();
            }
        }
        return this.selection;
    }

    protected void cancel() {
        this.selection = null;
        this.dialog.close();
    }

    protected void ok() {
        this.selection = (IJavaElement)((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        this.dialog.dispose();
    }

    private class ItemSelectionTableContentProvider
    implements IStructuredContentProvider {
        private ItemSelectionTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ItemSelectionTableFocusListener
    implements FocusListener {
        private ItemSelectionTableFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            ItemSelectionDialog.this.cancel();
        }
    }

    private class ItemSelectionTableKeyListener
    implements KeyListener {
        private boolean firstKey = true;
        private boolean quickReleaseMode = false;

        private ItemSelectionTableKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            int keyCode = e.keyCode;
            char character = e.character;
            KeyStroke keyStroke = SWTKeySupport.convertAcceleratorToKeyStroke((int)SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e));
            boolean acceleratorForward = false;
            if (ItemSelectionDialog.this.triggerSequences != null) {
                int sequencesCount = ItemSelectionDialog.this.triggerSequences.length;
                int i = 0;
                while (i < sequencesCount) {
                    TriggerSequence triggerSequence = ItemSelectionDialog.this.triggerSequences[i];
                    Trigger[] triggers = triggerSequence.getTriggers();
                    int triggersLength = triggers.length;
                    if (triggersLength > 0 && triggers[triggersLength - 1].equals((Object)keyStroke)) {
                        acceleratorForward = true;
                        break;
                    }
                    ++i;
                }
            }
            if (character == '\r' || character == '\n') {
                ItemSelectionDialog.this.ok();
            } else if (acceleratorForward) {
                if (this.firstKey && e.stateMask != 0) {
                    this.quickReleaseMode = true;
                }
                int index = ItemSelectionDialog.this.viewer.getTable().getSelectionIndex();
                ItemSelectionDialog.this.viewer.getTable().setSelection((index + 1) % ItemSelectionDialog.this.viewer.getTable().getItemCount());
            } else if (keyCode == 65536 || keyCode == 0x400000 || keyCode == 262144 || keyCode == 131072 || keyCode == 0x1000002 || keyCode == 0x1000001 || keyCode != 0x1000003) {
                // empty if block
            }
            this.firstKey = false;
        }

        public void keyReleased(KeyEvent e) {
            int keyCode = e.keyCode;
            int stateMask = e.stateMask;
            IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
            boolean stickyCycle = store.getBoolean("STICKY_CYCLE");
            if (!stickyCycle && (this.firstKey || this.quickReleaseMode) && keyCode == stateMask) {
                ItemSelectionDialog.this.ok();
            }
        }
    }

    private class ItemSelectionTableMouseListener
    implements MouseListener {
        private ItemSelectionTableMouseListener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            ItemSelectionDialog.this.ok();
        }

        public void mouseDown(MouseEvent e) {
            ItemSelectionDialog.this.ok();
        }

        public void mouseUp(MouseEvent e) {
            ItemSelectionDialog.this.ok();
        }
    }

    private class ItemSelectionTableTraverseListener
    implements TraverseListener {
        private ItemSelectionTableTraverseListener() {
        }

        public void keyTraversed(TraverseEvent event) {
            event.doit = false;
        }
    }
}

