/*
 * Decompiled with CFR 0.152.
 */
package goooooooooosuke.tddsupport.plugin.extensions.s2junit4;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XlsFinder {
    private String testResourceFolder;
    private List<String> xlsFileNameList;

    public XlsFinder(String testResourceFolder, List<String> xlsFileNameList) {
        this.testResourceFolder = testResourceFolder;
        this.xlsFileNameList = xlsFileNameList;
    }

    public IFile findExpectedDataXls(IMethod method) {
        IFile expectedDataXls = null;
        List<String> expectedDataXlsNameList = this.getExpectedDataXlsNameList(method);
        IProject project = method.getJavaProject().getProject();
        for (String expectedDataXlsName : expectedDataXlsNameList) {
            IFile file = project.getFile(expectedDataXlsName);
            if (!file.exists()) continue;
            expectedDataXls = file;
        }
        return expectedDataXls;
    }

    public IFile findTestDataXls(IType type, IMethod method) {
        IFile testDataXls = null;
        List<String> testDataXlsNameList = this.getTestDataXlsNameList(type, method);
        IProject project = type.getJavaProject().getProject();
        for (String testDataXlsName : testDataXlsNameList) {
            IFile file = project.getFile(testDataXlsName);
            if (!file.exists()) continue;
            testDataXls = file;
        }
        return testDataXls;
    }

    private List<String> getExpectedDataXlsNameList(IMethod method) {
        ArrayList<String> expectedDataXlsNameList = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        sb.append(this.testResourceFolder);
        sb.append("/");
        sb.append(method.getCompilationUnit().findPrimaryType().getPackageFragment().getElementName().replace('.', '/'));
        sb.append("/");
        String path = sb.toString();
        for (String xlsFileName : this.xlsFileNameList) {
            xlsFileName = xlsFileName.replaceAll("context\\.testClassShortName", this.escapeForRegExp(method.getCompilationUnit().findPrimaryType().getElementName()));
            xlsFileName = xlsFileName.replaceAll("context\\.testMethodName", this.escapeForRegExp(method.getElementName()));
            xlsFileName = xlsFileName.replaceAll("[ *\\+ *| *\" *]", "");
            expectedDataXlsNameList.add(String.valueOf(path) + xlsFileName);
        }
        return expectedDataXlsNameList;
    }

    private List<String> getTestDataXlsNameList(IType type, IMethod method) {
        ArrayList<String> testDataXlsNameList = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        sb.append(this.testResourceFolder);
        sb.append("/");
        sb.append(type.getPackageFragment().getElementName().replace('.', '/'));
        sb.append("/");
        String path = sb.toString();
        for (String xlsFileName : this.xlsFileNameList) {
            xlsFileName = xlsFileName.replaceAll("context\\.testClassShortName", this.escapeForRegExp(type.getElementName()));
            if (method == null && xlsFileName.contains("context.testMethodName")) continue;
            if (xlsFileName.contains("context.testMethodName")) {
                xlsFileName = xlsFileName.replaceAll("context\\.testMethodName", this.escapeForRegExp(method.getElementName()));
            }
            xlsFileName = xlsFileName.replaceAll("[ *\\+ *| *\" *]", "");
            testDataXlsNameList.add(String.valueOf(path) + xlsFileName);
        }
        return testDataXlsNameList;
    }

    public IFile getCreationExpectedDataXls(IMethod method) {
        IProject project = method.getJavaProject().getProject();
        return project.getFile(this.getExpectedDataXlsNameList(method).get(0));
    }

    public IFile getCreationTestDataXls(IType type, IMethod method) {
        IProject project = type.getJavaProject().getProject();
        return project.getFile(this.getTestDataXlsNameList(type, method).get(0));
    }

    private String escapeForRegExp(String value) {
        return value.replaceAll("\\$", "\\\\\\$").replaceAll("\\.", "\\\\\\.");
    }
}

