/*
 * Decompiled with CFR 0.152.
 */
package goooooooooosuke.tddsupport.plugin.extensions.s2junit4.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S2JUnit4DiconParser {
    private static final String XPATH_EXPRESSION_TEST_DATA_XLS_PATH = "/components[@namespace='s2junit4']/component[@class='org.seasar.framework.unit.impl.TestDataPreparerImpl']/initMethod[@name='addTestDataXlsPath']/arg";
    private static final String XPATH_EXPRESSION_EXPECTED_DATA_XLS_PATH = "/components[@namespace='s2junit4']/component[@class='org.seasar.framework.unit.impl.ExpectedDataReaderImpl']/initMethod[@name='addExpectedDataXlsPath']/arg";

    public static List<String> getTestDataXlsFileNameList(IFile diconFile) throws IOException, CoreException, ParserConfigurationException, SAXException, XPathException {
        Document doc = S2JUnit4DiconParser.parseS2JUnit4Dicon(diconFile);
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodeList = (NodeList)xPath.evaluate(XPATH_EXPRESSION_TEST_DATA_XLS_PATH, doc, XPathConstants.NODESET);
        ArrayList<String> testDataXlsPathList = new ArrayList<String>();
        int i = 0;
        while (i < nodeList.getLength()) {
            testDataXlsPathList.add(nodeList.item(i).getTextContent());
            ++i;
        }
        return testDataXlsPathList;
    }

    public static List<String> getExpectedDataXlsFileNameList(IFile diconFile) throws IOException, CoreException, ParserConfigurationException, SAXException, XPathException {
        Document doc = S2JUnit4DiconParser.parseS2JUnit4Dicon(diconFile);
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodeList = (NodeList)xPath.evaluate(XPATH_EXPRESSION_EXPECTED_DATA_XLS_PATH, doc, XPathConstants.NODESET);
        ArrayList<String> expectedDataXlsPathList = new ArrayList<String>();
        int i = 0;
        while (i < nodeList.getLength()) {
            expectedDataXlsPathList.add(nodeList.item(i).getTextContent());
            ++i;
        }
        return expectedDataXlsPathList;
    }

    private static Document parseS2JUnit4Dicon(IFile diconFile) throws IOException, CoreException, ParserConfigurationException, SAXException, SAXException {
        if (!diconFile.exists()) {
            throw new FileNotFoundException(diconFile.getProjectRelativePath().toOSString());
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(S2JUnit4DiconParser.class.getResourceAsStream("/resources/blank.xml"));
            }
        });
        return builder.parse(diconFile.getContents());
    }
}

