#ifndef _TMSSE_TRANSFORM_HPP
#define _TMSSE_TRANSFORM_HPP

#include <cstdlib>
#include "sse_vector.hpp"
#include "sse_matrix.hpp"

namespace tempest{
	

//vout = v*m
//            [a,b,c,d]
//[x,y,z,w] * [e,f,g,h]
//            [i,j,k,l]
//            [n,o,p,q]
inline sse_vector operator* (const sse_vector & lhs,const sse_matrix &rhs){
	sse_matrix temp(rhs);
	temp.transpose();
	
	return CVT424(
		SUM_128(_mm_mul_ps(temp.m[0],lhs.m) ),
		SUM_128(_mm_mul_ps(temp.m[1],lhs.m) ),
		SUM_128(_mm_mul_ps(temp.m[2],lhs.m) ),
		SUM_128(_mm_mul_ps(temp.m[3],lhs.m) )	
	);
}
	
//vout = m*v
//[a,b,c,d]   [x]
//[e,f,g,h] * [y] 
//[i,j,k,l]   [z]
//[n,o,p,q]   [w]
inline sse_vector operator* (const sse_matrix &lhs,const sse_vector & rhs){
	return CVT424(
		SUM_128(_mm_mul_ps(lhs.m[0],rhs.m) ),
		SUM_128(_mm_mul_ps(lhs.m[1],rhs.m) ),
		SUM_128(_mm_mul_ps(lhs.m[2],rhs.m) ),
		SUM_128(_mm_mul_ps(lhs.m[3],rhs.m) )
	);
}
	
inline void transform(sse_vector *out,const sse_matrix &lhs,const sse_vector & rhs){
	*out = lhs*rhs;
	return;
}
	

}

#endif

