//#include <iostream>

#include "../vector/matrix3.hpp"
#include "../vector/vector3.hpp"
#include "../vector/transform.hpp"
#include "../meta/operation_result.hpp"

namespace tempest{

template<std::size_t Rows, std::size_t Cols>
class gemv
{
  gemv(const gemv&);
  gemv& operator=(const gemv&);

private:
  enum {
    count 	= Cols,
    N 		= (count+7)/8
  };

public:
  gemv() { }

public:
	template<class E1, class E2>
	static inline 
	typename operation_result<typename E1::value_type,typename E2::value_type>::type
	prod(const E1& lhs, const E2& rhs, std::size_t i) {
	typedef typename operation_result<typename E1::value_type,typename E2::value_type>::type type;
	type 						sum(0);
	std::size_t					j(0);
	std::size_t					n(N);

	// Duff's device
	switch(count % 8) {
	case 0: do { sum += (lhs[i][j] * rhs[j]); ++j;
	case 7:      sum += (lhs[i][j] * rhs[j]); ++j;
	case 6:      sum += (lhs[i][j] * rhs[j]); ++j;
	case 5:      sum += (lhs[i][j] * rhs[j]); ++j;
	case 4:      sum += (lhs[i][j] * rhs[j]); ++j;
	case 3:      sum += (lhs[i][j] * rhs[j]); ++j;
	case 2:      sum += (lhs[i][j] * rhs[j]); ++j;
	case 1:      sum += (lhs[i][j] * rhs[j]); ++j;
            } while(--n != 0);
    }

    return sum;
  }
};
}
/*
int main(){
	typedef tempest::vector<double,3> VEC;
	typedef tempest::matrix<double,3,3> MAT;
	
	float f[9];
	std::size_t i = 0;
	for(int i = 0;i<9;i++)f[i]=i;
	MAT m(f);
	VEC v(f);
	VEC sum(0,0,0);
	std::cout << (sum += m*v) <<std::endl;
	std::cout << tempest::gemv<3,3>::prod(m,v,1) <<std::endl;
	
	
}
*/
typedef tempest::vector<double,3> VEC;
typedef tempest::matrix<double,3,3> MAT;
double function(const MAT &m,const VEC & v){
	return tempest::gemv<3,3>::prod(m,v,1);	
}

