#ifndef _TMANOTHER_VECTOR_FUNCTIONS_HPP
#define _TMANOTHER_VECTOR_FUNCTIONS_HPP

/** 
 *  @file another_vector_functions.hpp
 *  @brief Defines operators for anoter type vector.
 *  @author ototoi / Toru Matsuoka
 *  @date 2004/12/25 
 */


#include "../meta/operation_result.hpp"

namespace tempest{
	
	
#define DECLARE_OP( OP )																									\
	template<class T,class X, std::size_t Sz>																				\
	inline vector<typename operation_result<T,X>::type,Sz> operator OP (const vector<T,Sz> &lhs,const vector<X,Sz> & rhs){	\
		typedef vector<typename operation_result<T,X>::type,Sz> vector_type;												\
		return vector_type(lhs) OP ## = rhs;																				\
	}
	
	DECLARE_OP(+)
	DECLARE_OP(-)
	DECLARE_OP(*)
	DECLARE_OP(/)
	
#undef DECLARE_OP
	
	template<class T,class X, std::size_t Sz>
	inline vector<typename operation_result<T,X>::type,Sz> operator* (const vector<T,Sz> &lhs, X rhs){
		typedef typename operation_result<T,X>::type r_type;
		typedef vector<r_type,Sz> vector_type;
		return vector_type(lhs) *= r_type(rhs);
	}
	
	template<class T,class X, std::size_t Sz>
	inline vector<typename operation_result<T,X>::type,Sz> operator* (T lhs,const vector<X,Sz> &rhs){
		typedef typename operation_result<T,X>::type r_type;
		typedef vector<r_type,Sz> vector_type;
		return vector_type(rhs) *= r_type(lhs);
	}
	
	template<class T,class X, std::size_t Sz>
	inline vector<typename operation_result<T,X>::type,Sz> operator/ (const vector<T,Sz> &lhs, X rhs){
		typedef typename operation_result<T,X>::type r_type;
		typedef vector<r_type,Sz> vector_type;
		return vector_type(lhs) / r_type(rhs);
	}
	
}

#endif

