#ifndef _TMMATRIX_FUNCTIONS
#define _TMMATRIX_FUNCTIONS
/**
 *	@file matrix_functions.hpp
 *	@brief Defines matrix functions.
 *	@author ototoi / Toru Matsuoka
 *	@date 2004/05/12 
 */

//#include<iosfwd>
//#include<ostream>
#include<sstream>

#include <algorithm>//fill_n


namespace tempest{
	
//-----------------------------------------------
//Not a member!
//-----------------------------------------------
	
//-----------------------------------------------
//operators
	
template<class T,std::size_t RowSz, std::size_t ColumnSz>
inline const matrix<T,RowSz,ColumnSz> operator+ (const matrix<T,RowSz,ColumnSz> & rhs){
	return rhs;
}
	
template<class T,std::size_t RowSz, std::size_t ColumnSz>
inline matrix<T,RowSz,ColumnSz> operator- (const matrix<T,RowSz,ColumnSz> & rhs){
	return matrix<T,RowSz,ColumnSz>(rhs).negate();
}
	
template<class T,std::size_t RowSz, std::size_t ColumnSz> 
inline matrix<T,RowSz,ColumnSz> operator+ (const matrix<T,RowSz,ColumnSz> &lhs, const matrix<T,RowSz,ColumnSz> &rhs){
	return matrix<T,RowSz,ColumnSz>(lhs) += rhs;
}

template<class T,std::size_t RowSz, std::size_t ColumnSz> 
inline matrix<T,RowSz,ColumnSz> operator- (const matrix<T,RowSz,ColumnSz> &lhs, const matrix<T,RowSz,ColumnSz> &rhs){
	return matrix<T,RowSz,ColumnSz>(lhs) -= rhs;
}

template<class T,std::size_t ASz, std::size_t BSz,std::size_t CSz> //This functon is NOT recommended.
matrix<T,ASz,CSz> operator* (const matrix<T,ASz,BSz> &lhs, const matrix<T,BSz,CSz> &rhs){
	matrix<T,ASz,CSz> temp;
	
	std::fill_n(temp.begin(),ASz*CSz,T());
	
	for(std::size_t i =0;i<ASz;++i){
		for(std::size_t k=0;k<BSz;k++){
			for(std::size_t j =0;j<CSz;++j){			
				temp[i][j] += lhs[i][k]*rhs[k][j];	
			}
		}
	}
	return temp;
}

template<class T,std::size_t ASz, std::size_t BSz,std::size_t CSz>
void multiply(matrix<T,ASz,CSz> *out,const matrix<T,ASz,BSz> &lhs, const matrix<T,BSz,CSz> &rhs){
	
	std::fill_n<T>((*out).begin(),ASz*CSz,T());
	
	for(std::size_t i =0;i<ASz;++i){
		for(std::size_t k=0;k<BSz;k++){
			for(std::size_t j =0;j<CSz;++j){
				(*out)[i][j] += lhs[i][k]*rhs[k][j];	
			}
		}
	}
	
	return;
}


//-----------------------------------------------
//specific scalar
	
template<class T, std::size_t RowSz, std::size_t ColumnSz> 
inline matrix<T,RowSz,ColumnSz> operator* (T lhs, const matrix<T,RowSz,ColumnSz> & rhs){ 
	return matrix<T,RowSz,ColumnSz>(rhs) *= lhs ; 
}
template<class T, std::size_t RowSz, std::size_t ColumnSz>
inline matrix<T,RowSz,ColumnSz> operator* (const matrix<T,RowSz,ColumnSz> &lhs, T rhs){ 
	return matrix<T,RowSz,ColumnSz>(lhs) *= rhs ;
}
template<class T, std::size_t RowSz, std::size_t ColumnSz> 
inline matrix<T,RowSz,ColumnSz> operator/ (T lhs, const matrix<T,RowSz,ColumnSz> & rhs){ 
	return matrix<T,RowSz,ColumnSz>(rhs) /= lhs ; 
}
template<class T, std::size_t RowSz, std::size_t ColumnSz>
inline matrix<T,RowSz,ColumnSz> operator/ (const matrix<T,RowSz,ColumnSz> &lhs, T rhs){ 
	return matrix<T,RowSz,ColumnSz>(lhs) /= rhs ;
}
	
	
//-----------------------------------------------	
// utilities
template<class T, std::size_t RowSz, std::size_t ColumnSz>
matrix<T,ColumnSz,RowSz>	 transpose(const matrix<T,RowSz,ColumnSz>& rhs){ 
	
	matrix<T,ColumnSz,RowSz> temp;
	for(std::size_t i = 0;i<ColumnSz;i++){
		for(std::size_t j = 0;j<RowSz;j++){
			temp[i][j] = rhs[j][i];
		}
	}
	return temp;
}

	
//--------------------------------------------------
//compare

template<class T, std::size_t RowSz, std::size_t ColumnSz>
bool operator==(const matrix<T,RowSz,ColumnSz> &lhs,const matrix<T,RowSz,ColumnSz> &rhs){
	typename matrix<T,RowSz,ColumnSz>::const_iterator l_i = lhs.begin();
	typename matrix<T,RowSz,ColumnSz>::const_iterator r_i = rhs.begin();
	
	typename matrix<T,RowSz,ColumnSz>::const_iterator end = lhs.end();
	while(l_i != end){
		if(*l_i != *r_i)return false;
		++l_i;
		++r_i;
	}
	return true;
}

template<class T, std::size_t RowSz, std::size_t ColumnSz>
inline bool operator!=(const matrix<T,RowSz,ColumnSz> &lhs,const matrix<T,RowSz,ColumnSz> &rhs){
	return !(lhs == rhs);
}

/*
template<class T,std::size_t Sz>
inline bool operator< (const matrix<T,Sz> &lhs,const matrix<T,Sz> &rhs){
	return lhs.sqr_length() < rhs.sqr_length();
}

template<class T,std::size_t Sz>
inline bool operator> (const matrix<T,Sz> &lhs,const matrix<T,Sz> &rhs){
	return rhs < lhs;
}

template<class T,std::size_t Sz>
inline bool operator>= (const matrix<T,Sz> &lhs,const matrix<T,Sz> &rhs){
	return !(lhs < rhs);
}

template<class T,std::size_t Sz>
inline bool operator<= (const matrix<T,Sz> &lhs,const matrix<T,Sz> &rhs){
	return !(rhs < lhs);
}
*/

template<class T, std::size_t Sz>
bool lu_separate(matrix<T,Sz,Sz> * out, std::size_t * index){ /* LU */
	std::size_t i, j, k, ii, ik;
	T t, u, det;
	
	if(out == 0)return 0;
	matrix<T,Sz,Sz> & a = static_cast< matrix<T,Sz,Sz>& >(*out);
	
	T buffer[Sz];//line
	
	det = 0;                   //det
	for (k = 0; k < Sz; k++) {  //row
		index[k] = k;             //
		u = 0;                 //max
		for (j = 0; j < Sz; j++) {
			t = fabs(a[k][j]);  if (t > u) u = t;
		}
		if (u == 0) return false; 
		buffer[k] = 1 / u;     //
	}
	
	det = T(1);                  //
	
	for (k = 0; k < Sz; k++) {  //
		u = -1;
		for (i = k; i < Sz; i++) {  //less under 
			ii = index[i];            //
			t = fabs(a[ii][k]) * buffer[ii];
			if (t > u) {  u = t;  j = i;  }
		}
		
		ik = index[j];
		
		if (j != k) {
			index[j] = index[k];  index[k] = ik;  	//swap
			det = -det;  							//chage sign
		}
		
		u = a[ik][k];  det *= u;  
		
		if (u == 0)return false;    
		for (i = k + 1; i < Sz; i++) {  
			ii = index[i];
			t = (a[ii][k] /= u);
			for (j = k + 1; j < Sz; j++)
				a[ii][j] -= t * a[ik][j];
		}
	}

	return (det != 0);           
}
	
template<class T, std::size_t Sz> //lu
bool invert_lu (matrix<T,Sz,Sz> *out, const matrix<T,Sz,Sz> &rhs){
	int i, j, k, ii;
	T t, det;
	
	std::size_t index[Sz];
	
	if(out == 0){
		return false;
	}
	
	matrix<T,Sz,Sz> a(rhs);
	matrix<T,Sz,Sz> & a_inv = static_cast<matrix<T,Sz,Sz>&>(*out);
	
	if( !lu_separate(&a, index) )return false;
	
	for (k = 0; k < Sz; k++) {
		for (i = 0; i < Sz; i++) {
			ii = index[i];  t = (ii == k);
			for (j = 0; j < i; j++)
				t -= a[ii][j] * a_inv[j][k];
			a_inv[i][k] = t;
		}
		for (i = Sz - 1; i >= 0; i--) {
			t = a_inv[i][k];  ii = index[i];
			for (j = i + 1; j < Sz; j++)
				t -= a[ii][j] * a_inv[j][k];
			a_inv[i][k] = t / a[ii][i];
		}
	}
	
	return true;
}
	
	
template<class T, std::size_t Sz> //gauss joldan
bool invert_gj (matrix<T,Sz,Sz> *out, const matrix<T,Sz,Sz> &rhs){
	std::size_t i, j, k;
	T t, u, det;
	
	if(out == 0){
		return false;
	}
	
	matrix<T,Sz,Sz> & a = static_cast<matrix<T,Sz,Sz>&>(*out);
	
	a = rhs;	

	det = T(1);
	for (k = 0; k < Sz; k++) {
		t = a[k][k];  det *= t;
		for (i = 0; i < Sz; i++) a[k][i] /= t;
		a[k][k] = T(1) / t;
		for (j = 0; j < Sz; j++){
			if (j != k) {
				u = a[j][k];
				for (i = 0; i < Sz; i++)
					if (i != k) a[j][i] -= a[k][i] * u;
					else        a[j][i] = -u / t;
			}
		}
		
	}
	
	if(det != T(0))return true;
	else return false;
	//return det;
}
	
//if true definition matrix invert function using by LU separate method.
	
#define __TM_INVERT_USE_ LU__ 0

template<class T, std::size_t Sz> //gauss joldan
inline bool invert(matrix<T,Sz,Sz> *out, const matrix<T,Sz,Sz> &rhs){
#if __TM_INVERT_USE_ LU__
	return invert_lu(out,rhs);	
#else
	return invert_gj(out,rhs);
#endif
}
	
template<class T, std::size_t Sz> //gauss joldan
inline matrix<T,Sz,Sz> inverse(const matrix<T,Sz,Sz> &rhs){
	matrix<T,Sz,Sz> tmp;
	
#if __TM_INVERT_USE_ LU__
	invert_lu(tmp,rhs);
#else
	invert_gj(tmp,rhs);
#endif
	
	return tmp;
}


	//

//-----------------------------------------------
//output

/** 
 * ostream << 
 */
template<typename T, std::size_t RowSz, std::size_t ColumnSz, typename _CharT, class _Traits>
std::basic_ostream<_CharT, _Traits>& operator<<(std::basic_ostream<_CharT, _Traits>& os,  const matrix<T,RowSz,ColumnSz>& rhs){
	
	std::basic_ostringstream<_CharT, _Traits> s;
	s.flags(os.flags());
	s.imbue(os.getloc());
	s.precision(os.precision());
	s << "(";
	for(std::size_t i=0;i<RowSz;i++){
		s <<"(";
		for(std::size_t j = 0;j < ColumnSz;++j){
			s << rhs[i][j];
			if(j != ColumnSz-1){s << ",";}
		}
		s <<")";
		if(i != RowSz-1){s << ",";}
	}		
	s << ")";
	return os << s.str();
}

}//end of namespace 

#endif

