/* ********************************************************************* *
 *      interpixel.c
 * ********************************************************************* */
#include <stdio.h>
#include <teo.h>

float U_TeoGetLinerPixel (TEOIMAGE *img, int p, float row, float col)
{
  int	rmin, rmax, cmin, cmax;
  float	rp, cp;

  rmin = (int) row;
  rmax = rmin + 1;
  cmin = (int) col;
  cmax = cmin + 1;

  if (rmin == teo_yend (img)) rmax--;
  if (cmin == teo_xend (img)) cmax--;
  rp = row - rmin;
  cp = col - cmin;

  return (   cp    * (   rp    * TeoGetPixel (img,cmax,rmax,p,TEO_UINT8) +
                      (1.0-rp) * TeoGetPixel (img,cmin,rmax,p,TEO_UINT8))+
          (1.0-cp) * (   rp    * TeoGetPixel (img,cmax,rmin,p,TEO_UINT8) +
                      (1.0-rp) * TeoGetPixel (img,cmin,rmin,p,TEO_UINT8)));
}

float S_TeoGetLinerPixel (TEOIMAGE *img, int p, float row, float col)
{
  int	rmin, rmax, cmin, cmax;
  float	rp, cp;

  rmin = (int) row;
  rmax = rmin + 1;
  cmin = (int) col;
  cmax = cmin + 1;

  if (rmin == teo_yend (img)) rmax--;
  if (cmin == teo_xend (img)) cmax--;
  rp = row - rmin;
  cp = col - cmin;

  return (   cp    * (   rp    * TeoGetPixel (img,cmax,rmax,p,TEO_SINT16) +
                      (1.0-rp) * TeoGetPixel (img,cmin,rmax,p,TEO_SINT16))+
          (1.0-cp) * (   rp    * TeoGetPixel (img,cmax,rmin,p,TEO_SINT16) +
                      (1.0-rp) * TeoGetPixel (img,cmin,rmin,p,TEO_SINT16)));
}

float F_TeoGetLinerPixel (TEOIMAGE *img, int p, float row, float col)
{
  int	rmin, rmax, cmin, cmax;
  float	rp, cp;

  rmin = (int) row;
  rmax = rmin + 1;
  cmin = (int) col;
  cmax = cmin + 1;

  if (rmin == teo_yend (img)) rmax--;
  if (cmin == teo_xend (img)) cmax--;
  rp = row - rmin;
  cp = col - cmin;

  return (   cp    * (   rp    * TeoGetPixel (img,cmax,rmax,p,TEO_FLOAT32) +
                      (1.0-rp) * TeoGetPixel (img,cmin,rmax,p,TEO_FLOAT32))+
          (1.0-cp) * (   rp    * TeoGetPixel (img,cmax,rmin,p,TEO_FLOAT32) +
                      (1.0-rp) * TeoGetPixel (img,cmin,rmin,p,TEO_FLOAT32)));
}

void 
  U_TeoGetLinerPixelRGB (TEOIMAGE *img, float row, float col, float value[3])
{
  int		n, rmin, rmax, cmin, cmax;
  float 	d1[3], d2[3], d3[3], d4[3];
  float 	rp, cp;

  rmin = (int) row;
  rmax = rmin + 1;
  cmin = (int) col;
  cmax = cmin + 1;

  if (rmin == teo_yend (img)) rmax--;
  if (cmin == teo_xend (img)) cmax--;
  rp = row - rmin;
  cp = col - cmin;

  for (n = 0; n < 3; n++) {
    d1[n] = (float) TeoGetPixel (img, cmin, rmin, n, TEO_UINT8);
    d2[n] = (float) TeoGetPixel (img, cmax, rmin, n, TEO_UINT8);
    d3[n] = (float) TeoGetPixel (img, cmin, rmax, n, TEO_UINT8);
    d4[n] = (float) TeoGetPixel (img, cmax, rmax, n, TEO_UINT8);
  }

  value[0] = (   rp    * ((   cp    * d4[0]) + ((1.0-cp) * d3[0])) +
              (1.0-rp) * ((   cp    * d2[0]) + ((1.0-cp) * d1[0])));
  value[1] = (   rp    * ((   cp    * d4[1]) + ((1.0-cp) * d3[1])) +
              (1.0-rp) * ((   cp    * d2[1]) + ((1.0-cp) * d1[1])));
  value[2] = (   rp    * ((   cp    * d4[2]) + ((1.0-cp) * d3[2])) +
              (1.0-rp) * ((   cp    * d2[2]) + ((1.0-cp) * d1[2])));
  return;
}

void 
  S_TeoGetLinerPixelRGB (TEOIMAGE *img, float row, float col, float value[3])
{
  int		n, rmin, rmax, cmin, cmax;
  float 	d1[3], d2[3], d3[3], d4[3];
  float 	rp, cp;

  rmin = (int) row;
  rmax = rmin + 1;
  cmin = (int) col;
  cmax = cmin + 1;

  if (rmin == teo_yend (img)) rmax--;
  if (cmin == teo_xend (img)) cmax--;
  rp = row - rmin;
  cp = col - cmin;

  for (n = 0; n < 3; n++) {
    d1[n] = (float) TeoGetPixel (img, cmin, rmin, n, TEO_SINT16);
    d2[n] = (float) TeoGetPixel (img, cmax, rmin, n, TEO_SINT16);
    d3[n] = (float) TeoGetPixel (img, cmin, rmax, n, TEO_SINT16);
    d4[n] = (float) TeoGetPixel (img, cmax, rmax, n, TEO_SINT16);
  }

  value[0] = (   rp    * ((   cp    * d4[0]) + ((1.0-cp) * d3[0])) +
              (1.0-rp) * ((   cp    * d2[0]) + ((1.0-cp) * d1[0])));
  value[1] = (   rp    * ((   cp    * d4[1]) + ((1.0-cp) * d3[1])) +
              (1.0-rp) * ((   cp    * d2[1]) + ((1.0-cp) * d1[1])));
  value[2] = (   rp    * ((   cp    * d4[2]) + ((1.0-cp) * d3[2])) +
              (1.0-rp) * ((   cp    * d2[2]) + ((1.0-cp) * d1[2])));
  return;
}

void 
  F_TeoGetLinerPixelRGB (TEOIMAGE *img, float row, float col, float value[3])
{
  int		n, rmin, rmax, cmin, cmax;
  float 	d1[3], d2[3], d3[3], d4[3];
  float 	rp, cp;

  rmin = (int) row;
  rmax = rmin + 1;
  cmin = (int) col;
  cmax = cmin + 1;

  if (rmin == teo_yend (img)) rmax--;
  if (cmin == teo_xend (img)) cmax--;
  rp = row - rmin;
  cp = col - cmin;

  for (n = 0; n < 3; n++) {
    d1[n] = (float) TeoGetPixel (img, cmin, rmin, n, TEO_FLOAT32);
    d2[n] = (float) TeoGetPixel (img, cmax, rmin, n, TEO_FLOAT32);
    d3[n] = (float) TeoGetPixel (img, cmin, rmax, n, TEO_FLOAT32);
    d4[n] = (float) TeoGetPixel (img, cmax, rmax, n, TEO_FLOAT32);
  }

  value[0] = (   rp    * ((   cp    * d4[0]) + ((1.0-cp) * d3[0])) +
              (1.0-rp) * ((   cp    * d2[0]) + ((1.0-cp) * d1[0])));
  value[1] = (   rp    * ((   cp    * d4[1]) + ((1.0-cp) * d3[1])) +
              (1.0-rp) * ((   cp    * d2[1]) + ((1.0-cp) * d1[1])));
  value[2] = (   rp    * ((   cp    * d4[2]) + ((1.0-cp) * d3[2])) +
              (1.0-rp) * ((   cp    * d2[2]) + ((1.0-cp) * d1[2])));
  return;
}
