/* ************************************************************************* *
 *	magnify.c
 * ************************************************************************* */
#include <stdio.h>
#include <teo.h>

float U_TeoGetLinerPixel (TEOIMAGE *img, int p, float row, float col);

TEOIMAGE *U_TeoCreateMagnifyImage (TEOFILE *in, int frame,
				   float block_size_x, float block_size_y)
{
  TEOIMAGE	*in_img, *out_img;
  int 		row, col, mrow, mcol, p;
  int		rs, re, cs, ce, xoff, yoff;
  

  in_img  = TeoAllocSimilarImage (in);
  out_img = TeoAllocImage ((int) (teo_width (in) / block_size_x),
			   (int) (teo_height (in) / block_size_y),
			   teo_xoffset (in), teo_yoffset (in),
			   teo_type (in), teo_bit (in),
			   teo_plane (in));
  rs = teo_ystart (out_img);
  re = teo_yend (out_img);
  cs = teo_xstart (out_img);
  ce = teo_xend (out_img);
  xoff = teo_xoffset (out_img);
  yoff = teo_yoffset (out_img);

  TeoSetAbsFrame (in, frame);
  TeoReadFrame (in, in_img);
  for (row = rs; row <= re; row++) {
    for (col = cs; col <= ce; col++) {
      mrow = row - yoff;
      mcol = col - xoff;
      for (p = 0; p < teo_plane (out_img); p++) {
	TeoPutPixel (out_img, col, row, p, TEO_UINT8, 
		     (TEO_UINT8) U_TeoGetLinerPixel (in_img, p,
						     mrow * block_size_y +
						     yoff,
						     mcol * block_size_x +
						     xoff));
      }
    }
  }
  TeoFreeImage (in_img);
  return (out_img);
}
