/* *********************************************************************** *
 *      teoeps.c
 * *********************************************************************** */
#include <stdio.h>
#include <teo.h>

static void writeGrayPS (FILE *fp, TEOIMAGE *img, int p);
static void write8RGBPS (FILE *fp, TEOIMAGE *img, int p);

void teoeps (FILE *fp, TEOIMAGE *teo, char *name, 
	     int plane, int color,
	     int xsize, int ysize, int xcord, int ycord, char *creator)
{
  int		cols, rows;
  int		slen, colorps;

  cols = teo_width (teo);
  rows = teo_height (teo);
  if (color) {
    slen = cols*3;
    colorps = 1;
  } else {
    slen = cols;
    colorps = 0;
  }

  fprintf(fp, "%%!PS-Adobe-2.0 EPSF-2.0\n");
  fprintf(fp, "%%%%Title: %s\n", name);
  if (creator)
  fprintf(fp, "%%%%Creator: %s\n", creator);
  fprintf(fp, "%%%%BoundingBox: %d %d %d %d\n", xcord, ycord,
	  xsize+xcord, ysize+ycord);
  fprintf(fp, "%%%%Pages: 1\n");
  fprintf(fp, "%%%%DocumentFonts:\n");
  fprintf(fp, "%%%%EndComments\n");
  fprintf(fp, "%%%%EndProlog\n\n");
  fprintf(fp, "%%%%Page: 1 1\n\n");

  fprintf(fp, "%% remember original state\n");
  fprintf(fp, "/origstate save def\n\n");

  fprintf(fp, "%% build a temporary dictionary\n");
  fprintf(fp, "20 dict begin\n\n");

  fprintf(fp, "%% define string to hold a scanline's worth of data\n");
  fprintf(fp, "/pix %d string def\n\n", slen);
  
  fprintf(fp, "%% lower left corner\n");
  fprintf(fp, "%d %d translate\n\n", xcord, ycord);
  
  fprintf(fp, "%% size of image (on paper, in 1/72inch coords)\n");
  fprintf(fp, "%d %d scale\n\n", xsize, ysize);

  fprintf(fp, "%d %d %d\t\t\t%% dimensions of data\n", cols, rows, 8);
  fprintf(fp, "[%d 0 0 %d 0 %d]\t\t%% mapping matrix\n", cols, -rows, rows);
  fprintf(fp, "{currentfile pix readhexstring pop}\n" );
  if (colorps) {
    fprintf(fp,"false 3 colorimage\n\n");
    write8RGBPS (fp, teo, plane);
  } else {
    fprintf(fp,"image\n\n");
    writeGrayPS (fp, teo, plane);
  }
  fprintf(fp, "\nshowpage\n\n");
  
  fprintf(fp, "%% stop using temporary dictionary\n");
  fprintf(fp, "end\n\n");

  fprintf(fp, "%% restore original state\n");
  fprintf(fp, "origstate restore\n\n");
  fprintf(fp, "%%%%Trailer\n");

  return;
}

static void writeGrayPS (FILE *fp, TEOIMAGE *img, int p)
{
  int	row, col;

  for (row = teo_ystart (img); row <= teo_yend (img); row++) {
    for (col = teo_xstart (img); col <= teo_xend (img); col++) {
      fprintf(fp, "%02x", TeoGetPixel (img, col, row, p, TEO_UINT8));
    }
    fprintf(fp, "\n");
  }
  return;
}

static void write8RGBPS (FILE *fp, TEOIMAGE *img, int p)
{
  int		row, col, clr;
  unsigned char	cval[3];
  
 for (row = teo_ystart (img); row <= teo_yend (img); row++) {
    for (col = teo_xstart (img); col <= teo_xend (img); col++) {
      for (clr = p; clr < p+3; clr++) {
	cval[clr-p] = TeoGetPixel (img, col, row, clr, TEO_UINT8);
      }
      fprintf(fp, "%02x%02x%02x", cval[0], cval[1], cval[2]);
    }
    fprintf(fp, "\n");
  }
  return;
}
