#include <stdio.h>
#include <stdlib.h>
#include <teopp.h>

void usage(char *pname){
  fprintf(stderr,"usage: %s srcmin srcmax destmin destmax [teofile]\n",pname);
  exit(-1);
}

TeoImage<TeoFloat64> linear(const TeoImage<TeoFloat64> &img,
			    TeoFloat64 smin, TeoFloat64 smax,
			    TeoFloat64 dmin, TeoFloat64 dmax){
  TeoImage<TeoFloat64> ret(img.Width(),img.Height(),
			   img.Xoffset(),img.Yoffset(),
			   img.Plane());
  TeoFloat64 max,min;
  if(smax==smin) return ret;

  if(dmax>=dmin){
    max = dmax;
    min = dmin;
  } else {
    max = dmin;
    min = dmax;
  }

  TeoFloat64 h = (dmax-dmin)/(smax-smin);
  TeoFloat64 tmp;
  for(int y=img.Ystart();y<=img.Yend();y++)
    for(int x=img.Xstart();x<=img.Xend();x++)
      for(int p=0;p<img.Plane();p++){
	tmp = (img(x,y,p)-smin)*h + dmin;
	if(tmp>max) tmp = max;
	else if(tmp<min) tmp = min;
	ret(x,y,p) = tmp;
      }
  return ret;
}

typedef enum{FLAG_DEFAULT,FLAG_MAX,FLAG_MIN} MAX_FLAG;
int main(int argc,char **argv){
  TeoFloat64 smin=0,smax=0,dmin,dmax;
  MAX_FLAG minf,maxf;
  minf = maxf = FLAG_DEFAULT;

  if(argc<5) usage(argv[0]);

  if(strcmp(argv[1],"min")==0) minf = FLAG_MIN;
  else if(strcmp(argv[1],"max")==0) minf = FLAG_MAX;
  else smin = atof(argv[1]);

  if(strcmp(argv[2],"min")==0) maxf = FLAG_MIN;
  else if(strcmp(argv[2],"max")==0) maxf = FLAG_MAX;
  else smax = atof(argv[2]);

  dmin = atof(argv[3]);
  dmax = atof(argv[4]);

  TeoFile file;

  if(argc<6) file = TeoFile("-");
  else file = TeoFile(argv[5]);

  TeoFile outfile("-",file.Width(),file.Height(),
		  file.Xoffset(),file.Yoffset(),
		  TEO_FLOAT,64,file.Plane(),file.Frame());

  TeoImage<TeoFloat64> inimg;
  TeoImage<TeoFloat64> outimg(outfile.Width(),outfile.Height(),
			      outfile.Xoffset(),outfile.Yoffset(),
			      outfile.Plane());

  TeoFloat64 max,min,tmp;
  for(int f=0;f<file.Frame();f++){
    inimg = file.GetImage();
    if(maxf != FLAG_DEFAULT || minf != FLAG_DEFAULT){
      max=min=inimg(inimg.Xstart(),inimg.Ystart(),0);
      for(int y=inimg.Ystart();y<=inimg.Yend();y++)
	for(int x=inimg.Xstart();x<=inimg.Xend();x++)
	  for(int p=0;p<inimg.Plane();p++){
	    tmp = inimg(x,y,p);
	    if(tmp>max) max = tmp;
	    else if(tmp<min) min = tmp;
	  }
      if(maxf == FLAG_MAX) smax = max;
      if(maxf == FLAG_MIN) smax = min;
      if(minf == FLAG_MAX) smin = max;
      if(minf == FLAG_MIN) smin = min;
    }

    outimg = linear(inimg,smin,smax,dmin,dmax);
    outfile.PutImage(outimg);
  }
  return 0;
}
