/* ********************************************** gdk-pixbuf-extension.c *** *
 * gdk-pixbufγĥؿ (for libteoeyesloader)
 *
 * Copyright (C) 2001-2004 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp
 * Okayama University
 *                                  Time-stamp: <04/12/21 16:36:13 sugaya>
 *
 * eel-gdk-pixbuf-extensions.c: Routines to augment what's in gdk-pixbuf.
 *
 * Copyright (C) 2000 Eazel, Inc.
 *
 * The Gnome Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * The Gnome Library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with the Gnome Library; see the file COPYING.LIB.  If
 * not, write to the Free Software Foundation, Inc., 59 Temple Place -
 * Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors: Darin Adler <darin@eazel.com>
 * Ramiro Estrugo <ramiro@eazel.com>
 * ************************************************************************* */
#include <gtk/gtk.h>

/* ************************************************************************* *
 * GdkPixbufβͤФ
 *
 * gdk_pixbuf_get_pixel : ꤷɸβͤޥ
 * gdk_pixbuf_put_pixel : ꤷɸ˻ꤷͤ񤭹ޥ
 * ************************************************************************* */
#define gdk_pixbuf_get_pixel(pixbuf,x,y,p) \
(*(gdk_pixbuf_get_pixels((pixbuf)) + \
 gdk_pixbuf_get_rowstride((pixbuf)) * (y) + \
 gdk_pixbuf_get_n_channels((pixbuf)) * (x) + (p)))

#define gdk_pixbuf_put_pixel(pixbuf,x,y,p,val) \
(*(gdk_pixbuf_get_pixels((pixbuf)) + \
 gdk_pixbuf_get_rowstride((pixbuf)) * (y) + \
 gdk_pixbuf_get_n_channels((pixbuf)) * (x) + (p)) = (val))

/* ************************************************************************* */
static void
free_buffer (guchar	*pixels,
	     gpointer	data) {
  g_free (pixels);
}

/* ץ졼ĥǡǡǡ ********** */
GdkPixbuf*
gdk_pixbuf_remove_alpha (const GdkPixbuf	*src) {
  GdkPixbuf	*dst;
  int		row, col;

  dst     = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, 
			    gdk_pixbuf_get_width  (src),
			    gdk_pixbuf_get_height (src));
			
  for (row = 0; row < gdk_pixbuf_get_height (src); row++) {
    for (col = 0; col < gdk_pixbuf_get_height (src); col++) {
      gdk_pixbuf_put_pixel (dst, col, row, 0, 
			    gdk_pixbuf_get_pixel (src, col, row, 0));
      gdk_pixbuf_put_pixel (dst, col, row, 1, 
			    gdk_pixbuf_get_pixel (src, col, row, 1));
      gdk_pixbuf_put_pixel (dst, col, row, 2, 
			    gdk_pixbuf_get_pixel (src, col, row, 2));
    }
  }
  return dst;
}

/* ************************************************************************* */
GdkPixbuf*
gdk_pixbuf_align_rowstride (GdkPixbuf	*src) {
  guchar	*src_data, *dst_data;
  int		row, col, w, h, p, plane;
  int		src_rowstride, dst_rowstride;

  w     = gdk_pixbuf_get_width (src);
  h     = gdk_pixbuf_get_height(src);
  plane = 3 + gdk_pixbuf_get_has_alpha (src);
  src_rowstride = gdk_pixbuf_get_rowstride (src);
  dst_rowstride = w * plane;

  src_data = gdk_pixbuf_get_pixels (src);
  dst_data = g_new (guchar, w * h * plane);

  for (row = 0; row < h; row++) {
    for (col = 0; col < w; col++) {
      for (p = 0; p < plane; p++) {
	dst_data[dst_rowstride * row + plane * col + p]
	  = src_data[src_rowstride * row + plane * col + p];
      }
    }
  }
  if (plane == 3) {
    return gdk_pixbuf_new_from_data (dst_data, GDK_COLORSPACE_RGB, FALSE, 8,
				     w, h, dst_rowstride, free_buffer, NULL);
  } else {
    return gdk_pixbuf_new_from_data (dst_data, GDK_COLORSPACE_RGB, TRUE, 8,
				     w, h, dst_rowstride, free_buffer, NULL);
  }
}

/* *************************************** End of gdk-pixbuf-extension.c *** */
