/* ************************************************** libteoeyesplugin.h *** *
 * ƥץ饰饤֥ إåե
 *
 * Copyright (C) 2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <05/05/17 22:30:35 sugaya>
 * ************************************************************************* */
#ifndef __LIB_TEOEYES_PLUGIN_H__
#define __LIB_TEOEYES_PLUGIN_H__

#include <gtk/gtk.h>
#include <gnome.h>

/* ͤؤΥ ****************************************************** */
#define gdk_pixbuf_get_pixel(pixbuf,x,y,p) \
(*(gdk_pixbuf_get_pixels((pixbuf)) + \
 gdk_pixbuf_get_rowstride((pixbuf)) * \
 (y) + gdk_pixbuf_get_n_channels((pixbuf)) * (x) + (p)))

#define gdk_pixbuf_put_pixel(pixbuf,x,y,p,val) \
(*(gdk_pixbuf_get_pixels((pixbuf)) + \
 gdk_pixbuf_get_rowstride((pixbuf)) * \
 (y) + gdk_pixbuf_get_n_channels((pixbuf)) * (x) + (p)) = (val))

typedef struct _TeoeyesPluginInfo TeoeyesPluginInfo;
struct _TeoeyesPluginInfo {
  GnomeUIInfo	menuitem;
  gchar		*name;
  gchar		*author;
  gchar		*version;
  gchar	 	*comment;
  void		(*plugin_func) (GdkPixbuf	*src,
				GdkPixbuf	*dst,
				gpointer	data);
};


typedef struct _TeoeyesPluginDialog TeoeyesPluginDialog;
struct _TeoeyesPluginDialog {
  GtkWidget	*dialog;
  GtkWidget	*canvas;
  GtkWidget	*spinbutton;
  GtkWidget	*progressbar;
  GtkWidget	*box;
  GtkAdjustment	*adj;
  GdkPixbuf	*src;
  GdkPixbuf	*dest;
  GdkPixbuf	*work;
  gboolean	use_preview;
};

void	teoeyes_plugin_progressbar_update(double	       val);
void	teoeyes_plugin_dialog_new	(gchar		       *title,
					 void (*func) 
					 (GdkPixbuf	       *src,
					  GdkPixbuf	       *dest,
					  double	       param1,
					  double	       param2,
					  double	       param3),
					 GdkPixbuf	       *src,
					 GdkPixbuf	       *dest,
					 gchar		       *label,
					 double		       min, 
					 double		       max,
					 double		       step,
					 double		       page,
					 gboolean	       use_preview,
					 gboolean	       use_progressbar);

void	(*plugin_preview_image)		(GdkPixbuf	       *src,
					 GdkPixbuf	       *dest,
					 double		       param1,
					 double		       param2,
					 double		       param3);
TeoeyesPluginDialog	*pdialog;

#endif /* __LIB_TEOEYES_PLUGIN_H__ */

/* ********************************************* End of teoeyes_plugin.h *** */
