/* ************************************************************ io-gif.c *** *
 * GIF⥸塼
 *
 * Copyright (C) 2003-2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/06/28 01:27:17 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include "teoeyes_loader.h"
#include "format_gif.icon"

/* ************************************************************************* */
static gchar *mime_types[] = {
  "image/gif",
  NULL
};

/* ************************************************************************* */
static gchar *extensions[] = {
  "gif",
  NULL
};

/* ************************************************************************* */
gboolean
check_gif (GnomeVFSHandle	*handle) {
  GnomeVFSResult	result;
  guchar		buf[4];
  GnomeVFSFileSize	bytes_read;

  result = gnome_vfs_read(handle, buf, 4, &bytes_read);
  result = gnome_vfs_seek(handle, GNOME_VFS_SEEK_START, 0);

  if (!(buf[0] == 'G' && buf[1] == 'I' && buf[2] == 'F' && buf[3] == '8')) {
    return FALSE;
  }
  return TRUE;
}

/* ************************************************************************* */
GdkPixbuf*
load_gif (const gchar	*filename,
	   gpointer	data) {
  GdkPixbuf	*pixbuf;
  gchar		*localname;
  
  if (strrchr(filename, ':')) {
    localname = gnome_vfs_get_local_path_from_uri(filename);
  } else {
    localname = g_strdup (filename);
  }
  pixbuf = gdk_pixbuf_new_from_file (localname, NULL);
  g_free(localname);

  return pixbuf;
}

/* ************************************************************************* */
gboolean
save_gif (const gchar	*filename,
	   gpointer	data) {
  return TRUE;
}

/* ************************************************************************* */
void
load_info (TeoeyesImageModule	*module) {
  module->info = g_new (ImageFormat, 1);
  module->info->name		= "GIF";
  module->info->description	= _("The GIF image format");
  module->info->mime_types	= mime_types;
  module->info->extensions	= extensions;
  module->info->flags		= 0;
  module->icon = gdk_pixbuf_new_from_inline (-1, format_gif, FALSE, NULL);
};

/* ************************************************************************* */
TeoeyesImageModule module = {
  N_("GIF Image Loader"),
  "1.1",
  N_("Yasuyuki Sugaya"),
  NULL,
  NULL,
  check_gif,
  load_gif,
  save_gif,
  load_info
};

/* ***************************************************** End of io-gif.c *** */
