/* ************************************************************ io-pnm.c *** *
 * PNM⥸塼
 *
 * Copyright (C) 2003-2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/06/28 01:28:20 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "teoeyes_loader.h"
#include "format_pnm.icon"

/* ************************************************************************* */
static gchar *mime_types[] = {
  "image/x-portable-anymap",
  "image/x-portable-bitmap",
  "image/x-portable-graymap",
  "image/x-portable-pixmap",
  NULL
};

/* ************************************************************************* */
static gchar *extensions[] = {
  "pnm",
  "pbm",
  "pgm",
  "ppm",
  NULL
};

/* ************************************************************************* */
gboolean
check_pnm (GnomeVFSHandle	*handle) {
  GnomeVFSResult	result;
  guchar		buf[2];
  GnomeVFSFileSize	bytes_read;

  result = gnome_vfs_read(handle, buf, 8, &bytes_read);
  result = gnome_vfs_seek(handle, GNOME_VFS_SEEK_START, 0);

  if (buf[0] == 'P' &&
      (buf[1] == '1' || buf[1] == '2' || buf[1] == '3' ||
       buf[1] == '4' || buf[1] == '5' || buf[1] == '6')) {
    return TRUE;
  }
  return FALSE;
}

/* ************************************************************************* */
GdkPixbuf*
load_pnm (const gchar	*filename,
	  gpointer	data) {
  GdkPixbuf	*pixbuf;
  gchar		*localname;
  
  if (strrchr(filename, ':')) {
    localname = gnome_vfs_get_local_path_from_uri(filename);
  } else {
    localname = g_strdup (filename);
  }
  pixbuf = gdk_pixbuf_new_from_file (localname, NULL);
  g_free(localname);

  return pixbuf;
}

/* ************************************************************************* */
static gboolean
_save_pbm (const gchar	*filename,
	   guchar	*data,
	   gint		width,
	   gint		height) {
  FILE		*fp;
  guchar	*ptr;
  guchar	Y, r, g, b, val; 
  int		n, m, bitshift;

  fp = fopen (filename, "w");
  if (!fp) return FALSE;

  fprintf (fp, "P4\n");
  fprintf (fp, "# Created by teoeyes PNM loader Version 1.0\n");
  fprintf (fp, "\n%d %d\n", width, height);

  ptr = data;
  for (n = 0; n < height; n++) {
    bitshift = 7;
    val	     = 0;
    for (m = 0; m < width; m++) {
      r = *ptr++;
      g = *ptr++;
      b = *ptr++;
      Y = (guchar) (0.299 * r + 0.587 * g + 0.114 * b);
      if (Y > 128) val += 1 << bitshift;
      bitshift--;
      if (bitshift == -1) {
	putc (val, fp);
	bitshift = 7;
	val	 = 0;     
      }
    }
    if (bitshift != 7) putc (val, fp); 
  }
  fclose (fp);

  return TRUE;
}

/* ************************************************************************* */
static gboolean
_save_pgm (const gchar	*filename,
	   guchar	*data,
	   gint		width,
	   gint		height) {
  FILE		*fp;
  guchar	*ptr;
  guchar	Y[1], r, g, b; 
  int		n;

  fp = fopen (filename, "w");
  if (!fp) return FALSE;

  fprintf (fp, "P5\n");
  fprintf (fp, "# Created by teoeyes PNM loader Version 1.0\n");
  fprintf (fp, "%d %d\n255\n", width, height);
  for (ptr = data, n = width * height; n > 0; n--) {
    r = *ptr++;
    g = *ptr++;
    b = *ptr++;
    Y[0] = (guchar) (0.299 * r + 0.587 * g + 0.114 * b); 
    fwrite (Y, sizeof (char), 1, fp);
  }
  fclose (fp);

  return TRUE;
}

/* ************************************************************************* */
static gboolean
_save_ppm (const gchar	*filename,
	   guchar	*data,
	   gint		width,
	   gint		height) {
  FILE	*fp;

  fp = fopen (filename, "w");
  if (!fp) return FALSE;

  fprintf (fp, "P6\n");
  fprintf (fp, "# Created by teoeyes PNM loader Version 1.0\n");
  fprintf (fp, "%d %d\n255\n", width, height);
  fwrite (data, sizeof (char), width * height * 3, fp);

  fclose (fp);

  return TRUE;
}

/* ************************************************************************* */
gboolean
save_pnm (const gchar	*filename,
	  gpointer	data) {
  GdkPixbuf	*src = (GdkPixbuf *) data;
  GdkPixbuf	*dst = NULL;
  gchar		*ext, *pixels, *localname;
  gboolean	result;

  if (strrchr(filename, ':')) {
    localname = gnome_vfs_get_local_path_from_uri(filename);
  } else {
    localname = g_strdup (filename);
  }
  /* ץ졼 */
  if (gdk_pixbuf_get_has_alpha (src)) {
    dst = gdk_pixbuf_remove_alpha (src);
    pixels = gdk_pixbuf_get_pixels (dst);
  } else {
    pixels = gdk_pixbuf_get_pixels (src);
  }
  ext = strrchr (localname, '.');
  if (!ext) {
    result = _save_ppm (localname, pixels, 
			gdk_pixbuf_get_width(src), gdk_pixbuf_get_height(src));
  } else {
    if (strcmp (ext, ".pbm") == 0) {
      result 
	= _save_pbm (localname, pixels,
		     gdk_pixbuf_get_width(src), gdk_pixbuf_get_height(src));
    } else if (strcmp (ext, ".pgm") == 0) {
      result 
	= _save_pgm (localname, pixels,
		     gdk_pixbuf_get_width(src), gdk_pixbuf_get_height(src));
    } else {
      result 
	= _save_ppm (localname, pixels,
		     gdk_pixbuf_get_width(src), gdk_pixbuf_get_height(src));
    } 
  }
  if (dst) gdk_pixbuf_unref (dst);
  g_free(localname);
  
  return result;
}

/* ************************************************************************* */
void
load_info (TeoeyesImageModule	*module) {
  module->info = g_new (ImageFormat, 1);
  module->info->name		= "PNM";
  module->info->description	= _("The PNM/PBM/PGM/PPM image format family");
  module->info->mime_types	= mime_types;
  module->info->extensions	= extensions;
  module->info->flags		= IMAGE_FORMAT_WRITABLE;
  module->icon = gdk_pixbuf_new_from_inline (-1, format_pnm, FALSE, NULL);
};

/* ************************************************************************* */
TeoeyesImageModule module = {
  N_("PNM Image Loader"),
  "1.1",
  N_("Yasuyuki Sugaya"),
  NULL,
  NULL,
  check_pnm,
  load_pnm,
  save_pnm,
  load_info
};

/* **************************************************** End of io-pnm.c *** */
