/* ************************************************************ io-xbm.c *** *
 * XBM⥸塼
 *
 * Copyright (C) 2003-2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/06/28 01:29:08 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include "teoeyes_loader.h"
#include "format_xbm.icon"

/* ************************************************************************* */
static gchar *mime_types[] = {
  "image/x-xbitmap",
  NULL
};

/* ************************************************************************* */
static gchar *extensions[] = {
  "xbm",
  NULL
};

/* ************************************************************************* */
gboolean
check_xbm (GnomeVFSHandle	*handle) {
  GnomeVFSResult	result;
  guchar		buf[7];
  GnomeVFSFileSize	bytes_read;

  result = gnome_vfs_read(handle, buf, 7, &bytes_read);
  result = gnome_vfs_seek(handle, GNOME_VFS_SEEK_START, 0);

  if (buf[0] == '#' && buf[1] == 'd' && buf[2] == 'e' && buf[3] == 'f' &&
      buf[4] == 'i' && buf[5] == 'n' && buf[6] == 'e') {
    return TRUE;
  } else {
    return FALSE;
  }
}

/* ************************************************************************* */
GdkPixbuf*
load_xbm (const gchar	*filename,
	   gpointer	data) {
  GdkPixbuf	*pixbuf;
  gchar		*localname;
  
  if (strrchr(filename, ':')) {
    localname = gnome_vfs_get_local_path_from_uri(filename);
  } else {
    localname = g_strdup (filename);
  }
  pixbuf = gdk_pixbuf_new_from_file (localname, NULL);
  g_free(localname);

  return pixbuf;
}

/* ************************************************************************* */
gboolean
save_xbm (const gchar	*filename,
	   gpointer	data) {
  return TRUE;
}

/* ************************************************************************* */
void
load_info (TeoeyesImageModule	*module) {
  module->info = g_new (ImageFormat, 1);
  module->info->name		= "XBM";
  module->info->description	= _("The XBM image format");
  module->info->mime_types	= mime_types;
  module->info->extensions	= extensions;
  module->info->flags		= 0;
  module->icon = gdk_pixbuf_new_from_inline (-1, format_xbm, FALSE, NULL);
};

/* ************************************************************************* */
TeoeyesImageModule module = {
  N_("XBM Image Loader"),
  "1.1",
  N_("Yasuyuki Sugaya"),
  NULL,
  NULL,
  check_xbm,
  load_xbm,
  save_xbm,
  load_info
};

/* ***************************************************** End of io-xbm.c *** */
