/* ****************************************************** pseudo_color.c *** *
 * Teoeyes Plugin Collection ($B5?;w%+%i!<(B)
 *
 * Copyright (C) 2001-2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <05/05/17 23:03:26 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "teoeyes_plugin.h"

#define	MIN_VAL			0
#define	MAX_VAL			255
#define	STEP_SIZE		1
#define	PAGE_SIZE		5
/* $B%W%m%0%l%9%P!<$r;HMQ$9$k>l9g$O(B1$B$KJQ99$7$F$$2<$5$$(B */
#define	USE_PROGRESS_BAR	0

/* ************************************************************************* */
static guint8
gray_to_pseudo_color (guchar	src,
		      int	plane) {
  switch (plane) {
  case 0:
    if (src < 128) {
      return 0;
    } else if (src > 192) {
      return 255;
    } else {
      return (guchar) ((src - 128) * 255 / 64);
    }
    break;
  case 1:
    if (src <= 64) {
      return (guchar) src * 255 / 64;
    } else if (src >= 192) {
      return (guchar) (255 - (guchar) (src - 192) * 255 / 63);
    } else {
      return (guchar) 255;
    }
    break;
  case 2:
    if (src < 64) {
      return (guchar) 255;
    } else if (src > 128) {
      return 0;
    } else {
      return (guchar) (255 - (guchar) (src - 64) * 255 / 64);
    }
    break;
  default:
    return (guchar) 0;
  }
}

/* ************************************************************************* *
   $B%W%i%0%$%s<B9TMQ4X?t(B
 * ************************************************************************* */
void
plugin_pseudo (GdkPixbuf	*src,
	       GdkPixbuf	*dst,
	       gpointer		data) {
  guchar	y, r, g, b;
  int		row, col;
  
  for (row = 0; row < gdk_pixbuf_get_height (src); row++) {
    for (col = 0; col < gdk_pixbuf_get_width (src); col++) {
      r = gdk_pixbuf_get_pixel (src, col, row, 0);
      g = gdk_pixbuf_get_pixel (src, col, row, 1);
      b = gdk_pixbuf_get_pixel (src, col, row, 2);
      y = (guchar) (0.299 * r + 0.587 * g + 0.114 * b);
      gdk_pixbuf_put_pixel (dst, col, row, 0, gray_to_pseudo_color (y, 0));
      gdk_pixbuf_put_pixel (dst, col, row, 1, gray_to_pseudo_color (y, 1));
      gdk_pixbuf_put_pixel (dst, col, row, 2, gray_to_pseudo_color (y, 2));
      if (gdk_pixbuf_get_has_alpha (src) && gdk_pixbuf_get_has_alpha (dst)) {
	gdk_pixbuf_put_pixel (dst, col, row, 4,
			      gdk_pixbuf_get_pixel (src, col, row, 4));
      }
    }
  }
}

/* ************************************************************************* *
   $B%W%i%0%$%s>pJs(B
 * ************************************************************************* */
TeoeyesPluginInfo plugin_info = {
  {
    GNOME_APP_UI_ITEM, N_("Psudo Color"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  N_("Pseudo Color Plugin"),
  N_("Yasuyuki Sugaya"),
  "2.1",
  N_("This plugin converts the gray-scale image\n to the pseudo-color image."),
  plugin_pseudo
};

/* *********************************************** End of pseudo_color.c *** */
