/* ********************************************** gdk-pixbuf-extension.c *** *
 * gdk-pixbufγĥؿ
 *
 * Copyright (C) 2001-2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp
 * Okayama University
 *                                  Time-stamp: <05/03/03 21:35:03 sugaya>
 *
 * eel-gdk-pixbuf-extensions.c: Routines to augment what's in gdk-pixbuf.
 *
 * Copyright (C) 2000 Eazel, Inc.
 *
 * The Gnome Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * The Gnome Library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with the Gnome Library; see the file COPYING.LIB.  If
 * not, write to the Free Software Foundation, Inc., 59 Temple Place -
 * Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors: Darin Adler <darin@eazel.com>
 * Ramiro Estrugo <ramiro@eazel.com>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <gtk/gtk.h>
#include "gdk-pixbuf-extension.h"

/* ************************************************************************* */
void
gdk_pixbuf_free_buffer (guchar	*pixels,
	     gpointer	data) {
  g_free (pixels);
}

/* ץ졼ĥǡǡǡ ********** */
GdkPixbuf*
gdk_pixbuf_remove_alpha (const GdkPixbuf	*src) {
  GdkPixbuf	*dst;
  int		row, col;

  dst = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, 
			gdk_pixbuf_get_width  (src),
			gdk_pixbuf_get_height (src));
  if (!dst) return NULL;

  for (row = 0; row < gdk_pixbuf_get_height (src); row++) {
    for (col = 0; col < gdk_pixbuf_get_height (src); col++) {
      gdk_pixbuf_put_pixel (dst, col, row, 0, 
			    gdk_pixbuf_get_pixel (src, col, row, 0));
      gdk_pixbuf_put_pixel (dst, col, row, 1, 
			    gdk_pixbuf_get_pixel (src, col, row, 1));
      gdk_pixbuf_put_pixel (dst, col, row, 2, 
			    gdk_pixbuf_get_pixel (src, col, row, 2));
    }
  }
  return dst;
}

/* ************************************************************************* */
void
gdk_pixbuf_calc_map_tables (GdkPixbufModifier		*mod) {
  int			i;
  gdouble		g, b, c, ii, v;

  g_return_if_fail (mod  != NULL);

  /* If we are using the defaults, there is no need to get a map */
  if ((mod->mod.gamma == 256)  && (mod->mod.brightness == 256)  &&
      (mod->mod.contrast == 256)  &&
      (mod->rmod.gamma == 256) && (mod->rmod.brightness == 256) &&
      (mod->rmod.contrast == 256) &&
      (mod->gmod.gamma == 256) && (mod->gmod.brightness == 256) &&
      (mod->gmod.contrast == 256) &&
      (mod->bmod.gamma == 256) && (mod->bmod.brightness == 256) &&
      (mod->bmod.contrast == 256)) {
    if (mod->map) {
      g_free (mod->map);
      mod->map = NULL;
    }
    return;
  }
  if (!mod->map) {
   mod->map = g_new (GdkPixbufModifierMap, 1);
    if (!mod->map) return;
  }
  g = ((gdouble) mod->mod.gamma)      / 256;
  b = ((gdouble) mod->mod.brightness) / 256;
  c = ((gdouble) mod->mod.contrast)   / 256;

  if (g < 0.01) g = 0.01;

  for (i = 0; i < 256; i++) {
    ii = ((gdouble) i) / 256;
    v = ((ii - 0.5) * c) + 0.5 + (b - 1);
    if (v > 0) {
      v = pow (((ii - 0.5) * c) + 0.5 + (b - 1), 1 / g) * 256;
    } else {
      v = 0;
    }
    if (v > 255) {
      v = 255;
    } else if (v < 0) {
      v = 0;
    }
    mod->map->rmap[i] = (guchar) v;
    mod->map->gmap[i] = (guchar) v;
    mod->map->bmap[i] = (guchar) v;
  }
  g = ((gdouble) mod->rmod.gamma) 	/ 256;
  b = ((gdouble) mod->rmod.brightness)	/ 256;
  c = ((gdouble) mod->rmod.contrast)	/ 256;

  if (g < 0.01) g = 0.01;

  for (i = 0; i < 256; i++) {
    ii = ((gdouble) mod->map->rmap[i]) / 256;
    v = ((ii - 0.5) * c) + 0.5 + (b - 1);
    if (v > 0) {
      v = pow (((ii - 0.5) * c) + 0.5 + (b - 1), 1 / g) * 256;
    } else {
      v = 0;
    }
    if (v > 255) {
      v = 255;
    } else if (v < 0) {
      v = 0;
    }
    mod->map->rmap[i] = (guchar) v;
  }
  g = ((gdouble) mod->gmod.gamma)	/ 256;
  b = ((gdouble) mod->gmod.brightness)	/ 256;
  c = ((gdouble) mod->gmod.contrast)	/ 256;

  if (g < 0.01) g = 0.01;

  for (i = 0; i < 256; i++) {
    ii = ((gdouble) mod->map->gmap[i]) / 256;
    v = ((ii - 0.5) * c) + 0.5 + (b - 1);
    if (v > 0) {
      v = pow (((ii - 0.5) * c) + 0.5 + (b - 1), 1 / g) * 256;
    } else {
      v = 0;
    }
    if (v > 255) {
      v = 255;
    } else if (v < 0) {
      v = 0;
    }
    mod->map->gmap[i] = (unsigned char) v;
  }
  g = ((gdouble) mod->bmod.gamma)	/ 256;
  b = ((gdouble) mod->bmod.brightness)	/ 256;
  c = ((gdouble) mod->bmod.contrast)	/ 256;

  if (g < 0.01) g = 0.01;
  for (i = 0; i < 256; i++) {
    ii = ((gdouble) mod->map->bmap[i]) / 256;
    v = ((ii - 0.5) * c) + 0.5 + (b - 1);
    if (v > 0) {
      v = pow (((ii - 0.5) * c) + 0.5 + (b - 1), 1 / g) * 256;
    } else {
      v = 0;
    }
    if (v > 255) {
      v = 255;
    } else if (v < 0) {
      v = 0;
    }
    mod->map->bmap[i] = (unsigned char) v;
  }
}

/* ************************************************************************* */
void
gdk_pixbuf_set_image_modifier (GdkPixbufColorModifier	*cmod,
			       GdkPixbufModifier	*mod) {
  g_return_if_fail (cmod != NULL);
  g_return_if_fail (mod  != NULL);

  mod->mod.gamma	= cmod->gamma;
  mod->mod.brightness	= cmod->brightness;
  mod->mod.contrast	= cmod->contrast;

  gdk_pixbuf_calc_map_tables (mod);
}

/* ************************************************************************* */
void
gdk_pixbuf_set_image_red_modifier (GdkPixbufColorModifier	*cmod,
				   GdkPixbufModifier		*mod) {
  g_return_if_fail (cmod != NULL);
  g_return_if_fail (mod  != NULL);

  mod->rmod.gamma	= cmod->gamma;
  mod->rmod.brightness	= cmod->brightness;
  mod->rmod.contrast	= cmod->contrast;

  gdk_pixbuf_calc_map_tables (mod);
}

/* ************************************************************************* */
void
gdk_pixbuf_set_image_green_modifier (GdkPixbufColorModifier	*cmod,
				     GdkPixbufModifier		*mod) {
  g_return_if_fail (cmod != NULL);
  g_return_if_fail (mod  != NULL);

  mod->gmod.gamma	= cmod->gamma;
  mod->gmod.brightness	= cmod->brightness;
  mod->gmod.contrast	= cmod->contrast;

  gdk_pixbuf_calc_map_tables (mod);
}

/* ************************************************************************* */
void
gdk_pixbuf_set_image_blue_modifier (GdkPixbufColorModifier	*cmod,
				    GdkPixbufModifier		*mod) {
  g_return_if_fail (cmod != NULL);
  g_return_if_fail (mod  != NULL);

  mod->bmod.gamma	= cmod->gamma;
  mod->bmod.brightness	= cmod->brightness;
  mod->bmod.contrast	= cmod->contrast;

  gdk_pixbuf_calc_map_tables (mod);
}

/* ************************************************************************* */
void
gdk_pixbuf_get_image_modifier (GdkPixbufColorModifier	*src_mod,
			       GdkPixbufColorModifier	*dst_mod) {
  g_return_if_fail (src_mod != NULL);
  g_return_if_fail (dst_mod != NULL);

  dst_mod->gamma	= src_mod->gamma;
  dst_mod->brightness	= src_mod->brightness;
  dst_mod->contrast	= src_mod->contrast;
}

/* ************************************************************************* */
void
gdk_pixbuf_get_image_red_curve (GdkPixbufModifierMap	*src_map,
				unsigned char 		*mod) {
  int			i;

  g_return_if_fail (mod != NULL);

  if (src_map) {
    for (i = 0; i < 256; i++) mod[i] = src_map->rmap[i];
  } else {
    for (i = 0; i < 256; i++) mod[i] = i;
  }
}

/* ************************************************************************* */
void
gdk_pixbuf_get_image_green_curve (GdkPixbufModifierMap	*src_map,
				  unsigned char		*mod) {
  int			i;

  g_return_if_fail (mod != NULL);

  if (src_map) {
    for (i = 0; i < 256; i++) mod[i] = src_map->gmap[i];
  } else {
    for (i = 0; i < 256; i++) mod[i] = i;
  }
}

/* ************************************************************************* */
void
gdk_pixbuf_get_image_blue_curve (GdkPixbufModifierMap	*src_map,
				 unsigned char 		*mod) {
  int			i;

  g_return_if_fail (mod != NULL);

  if (src_map) {
    for (i = 0; i < 256; i++) mod[i] = src_map->bmap[i];
  } else {
    for (i = 0; i < 256; i++) mod[i] = i;
  }
}

/* ************************************************************************* */
void
gdk_pixbuf_apply_modifiers_to_rgb (GdkPixbuf			*pbuf,
				   GdkPixbufModifier		*mod,
				   gboolean			clear_flg) {
  int		x, y, has_alpha;
  guchar	val;
  
  g_return_if_fail (pbuf != NULL);
  g_return_if_fail (mod  != NULL);
  
  has_alpha = gdk_pixbuf_get_has_alpha (pbuf);
  
  if (mod->map) {
    for (y = 0; y < gdk_pixbuf_get_height (pbuf); y++) {
      for (x = 0; x < gdk_pixbuf_get_width (pbuf); x++) {
	val = mod->map->rmap[gdk_pixbuf_get_pixel (pbuf, x, y, 0)];
	gdk_pixbuf_put_pixel (pbuf, x, y, 0, val);
	val = mod->map->gmap[gdk_pixbuf_get_pixel (pbuf, x, y, 1)];
	gdk_pixbuf_put_pixel (pbuf, x, y, 1, val);
	val = mod->map->bmap[gdk_pixbuf_get_pixel (pbuf, x, y, 2)];
	gdk_pixbuf_put_pixel (pbuf, x, y, 2, val);
	if (has_alpha) {
	  gdk_pixbuf_put_pixel (pbuf, x, y, 3,
				gdk_pixbuf_get_pixel (pbuf, x, y, 3));
	}
      }
    }
  }
  if (clear_flg) {
    mod->mod.gamma	= 256;
    mod->mod.brightness	= 256;
    mod->mod.contrast	= 256;
    mod->rmod.gamma	= 256;
    mod->rmod.brightness= 256;
    mod->rmod.contrast	= 256;
    mod->gmod.gamma	= 256;
    mod->gmod.brightness= 256;
    mod->gmod.contrast	= 256;
    mod->bmod.gamma	= 256;
    mod->bmod.brightness= 256;
    mod->bmod.contrast	= 256;

    gdk_pixbuf_calc_map_tables (mod);
  }
}
#if 0
/* ************************************************************************* */
GdkPixbuf*
gdk_pixbuf_align_rowstride (GdkPixbuf	*src) {
  guchar	*src_data, *dst_data;
  int		row, col, w, h, p, plane;
  int		src_rowstride, dst_rowstride;

  w     	= gdk_pixbuf_get_width  (src);
  h     	= gdk_pixbuf_get_height (src);
  plane 	= 3 + gdk_pixbuf_get_has_alpha (src);
  src_rowstride = gdk_pixbuf_get_rowstride (src);
  dst_rowstride = w * plane;

  src_data = gdk_pixbuf_get_pixels (src);
  dst_data = g_new (guchar, w * h * plane);

  if (!dst_data) return NULL;

  for (row = 0; row < h; row++) {
    for (col = 0; col < w; col++) {
      for (p = 0; p < plane; p++) {
	dst_data[dst_rowstride * row + plane * col + p]
	  = src_data[src_rowstride * row + plane * col + p];
      }
    }
  }
  if (plane == 3) {
    return gdk_pixbuf_new_from_data (dst_data, GDK_COLORSPACE_RGB, FALSE, 8,
				     w, h, dst_rowstride,
				     gdk_pixbuf_free_buffer, NULL);
  } else {
    return gdk_pixbuf_new_from_data (dst_data, GDK_COLORSPACE_RGB, TRUE, 8,
				     w, h, dst_rowstride, 
				     gdk_pixbuf_free_buffer, NULL);
  }
}
#endif
/* ************************************************************************* */
GdkPixbuf*
gdk_pixbuf_copy_rotate_90 (GdkPixbuf	*src, 
			   gboolean	counter_clockwise) {
  GdkPixbuf	*dest;
  int		has_alpha;
  int		sw, sh, srs;
  int		dw, dh, drs;
  guchar	*s_pix;
  guchar	*d_pix;
  guchar	*sp;
  guchar	*dp;
  int		i, j, a;

  if (!src) return NULL;

  sw = gdk_pixbuf_get_width  (src);
  sh = gdk_pixbuf_get_height (src);
  has_alpha = gdk_pixbuf_get_has_alpha (src);
  srs   = gdk_pixbuf_get_rowstride (src);
  s_pix = gdk_pixbuf_get_pixels (src);

  dw = sh;
  dh = sw;
  dest  = gdk_pixbuf_new (GDK_COLORSPACE_RGB, has_alpha, 8, dw, dh);
  drs   = gdk_pixbuf_get_rowstride (dest);
  d_pix = gdk_pixbuf_get_pixels (dest);

  a = (has_alpha ? 4 : 3);

  for (i = 0; i < sh; i++) {
    sp = s_pix + (i * srs);
    for (j = 0; j < sw; j++) {
      if (counter_clockwise) {
	dp = d_pix + ((dh - j - 1) * drs) + (i * a);
      } else {
	dp = d_pix + (j * drs) + ((dw - i - 1) * a);
      }
      *(dp++) = *(sp++);		/* r */
      *(dp++) = *(sp++);		/* g */
      *(dp++) = *(sp++);		/* b */
      if (has_alpha) *(dp) = *(sp++);	/* a */
    }
  }
  return dest;
}

/* ************************************************************************* */
GdkPixbuf*
gdk_pixbuf_copy_mirror (GdkPixbuf	*src, 
			gboolean	mirror, 
			gboolean	flip) {
  GdkPixbuf	*dest;
  int		has_alpha;
  int		w, h, srs;
  int		drs;
  guchar	*s_pix;
  guchar	*d_pix;
  guchar	*sp;
  guchar	*dp;
  int		i, j, a;

  if (!src) return NULL;

  w = gdk_pixbuf_get_width  (src);
  h = gdk_pixbuf_get_height (src);
  has_alpha = gdk_pixbuf_get_has_alpha (src);
  srs   = gdk_pixbuf_get_rowstride (src);
  s_pix = gdk_pixbuf_get_pixels (src);

  dest  = gdk_pixbuf_new (GDK_COLORSPACE_RGB, has_alpha, 8, w, h);
  drs   = gdk_pixbuf_get_rowstride (dest);
  d_pix = gdk_pixbuf_get_pixels (dest);

  a = has_alpha ? 4 : 3;

  for (i = 0; i < h; i++)	{
    sp = s_pix + (i * srs);
    if (flip) {
      dp = d_pix + ((h - i - 1) * drs);
    } else {
      dp = d_pix + (i * drs);
    }
    if (mirror) {
      dp += (w - 1) * a;
      for (j = 0; j < w; j++) {
	*(dp++) = *(sp++);		/* r */
	*(dp++) = *(sp++);		/* g */
	*(dp++) = *(sp++);		/* b */
	if (has_alpha) *(dp) = *(sp++);	/* a */
	dp -= (a + 3);
      }
    } else {
      for (j = 0; j < w; j++) {
	*(dp++) = *(sp++);		/* r */
	*(dp++) = *(sp++);		/* g */
	*(dp++) = *(sp++);		/* b */
	if (has_alpha) *(dp++) = *(sp++);	/* a */
      }
    }
  }
  return dest;
}

/* *************************************** End of gdk-pixbuf-extension.c *** */
