/* ********************************************** gnome-custom-filesel.h *** *
 * ե إåե
 *
 * Copyright (C) 2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/03/30 16:34:29 sugaya>
 * ************************************************************************* */
#ifndef	__GNOME_CUSTOM_FILESEL_H__
#define	__GNOME_CUSTOM_FILESEL_H__

#include <gtk/gtk.h>
#include <libgnome/libgnome.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GNOME_TYPE_CUSTOM_FILESEL (gnome_custom_file_selection_get_type())
#define GNOME_CUSTOM_FILESEL(obj) (GTK_CHECK_CAST((obj), GNOME_TYPE_CUSTOM_FILESEL, GnomeCustomFileSel))
#define GNOME_CUSTOM_FILESEL_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass), GNOME_TYPE_CUSTOM_FILESEL, GnomeCustomFileSelClass))
#define GNOME_IS_CUSTOM_FILESEL(obj) (GTK_CHECK_TYPE((obj), GNOME_TYPE_CUSTOM_FILESEL))
#define GNOME_IS_CUSTOM_FILESEL_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_TYPE_CUSTOM_FILESEL))
#define GNOME_CUSTOM_FILESEL_GET_CLASS(obj) (GTK_CHECK_GET_CLASS((obj), GNOME_TYPE_CUSTOM_FILESEL, GnomeCustomFileSelClass))
  
typedef struct _GnomeCustomFileSel	GnomeCustomFileSel;
typedef struct _GnomeCustomFileSelClass	GnomeCustomFileSelClass;
  
struct _GnomeCustomFileSel {
  GtkWindow	window;
  gchar		*selected_file;
  GtkWidget	*tree_window;
  GtkWidget	*list_window;
  GtkWidget	*folder_tree;
  GtkWidget	*file_list;
  GtkWidget	*file_entry;
  GtkWidget	*filter_combo;
  GtkWidget	*filter_entry;
  GtkWidget	*folder_combo;
  GtkWidget	*folder_entry;
  GtkWidget	*folder_button_new;
  GtkWidget	*folder_button_up;
  GtkWidget	*folder_button_home;
  GtkWidget	*ok_button;
  GtkWidget	*cancel_button;
  GtkWidget	*custom_box;
  gboolean	show_folder_tree;
  GList		*folder_combo_list;
};

struct _GnomeCustomFileSelClass {
  GtkWindowClass	parent_class;
};

GtkType    gnome_custom_file_selection_get_type	(void);
GtkWidget* gnome_custom_file_selection_new	(const gchar	*title,
						 const gchar	*icon_folder);	

void	   gnome_custom_file_selection_set_folder(GnomeCustomFileSel *filesel,
						  const gchar        *folder);
gchar*	  gnome_custom_file_selection_get_filename(GnomeCustomFileSel *filesel);

#endif	/* __GNOME_CUSTOM_FILESELECTION_H__ */

/* **************************************** End of gnome-custom-filesel.h *** */
