/* ********************************************** gnome-vfs-extensions.c *** *
 * VFSեؿ
 *
 * Copyright (C) 2004-2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <05/04/02 02:36:18 sugaya>
 * ************************************************************************* */
#include <string.h>
#include <time.h>
#include <libgnome/libgnome.h>
#include <libgnomevfs/gnome-vfs.h>
#include "gnome-vfs-extension.h"

/* ؿ ************************************************************ */
static gint	compare_by_type_and_spell	(gconstpointer	data1,
						 gconstpointer	data2);


/* եURIɤĴ٤ؿ ********************************* */
gboolean
gnome_vfs_ext_is_local_uri (const char	*filename) {
  char	*local_uri_prefix = "file://";
  
  if (strncmp(filename, local_uri_prefix, strlen(local_uri_prefix)) == 0) {
    return TRUE;
  } else {
    return FALSE;
  }
}	

/* ͥåȥΥեURIɤĴ٤ ***************************** */
gboolean
gnome_vfs_ext_is_network_uri (const char	*filename) {
  char	*www_uri_prefix = "http://";
  char	*ftp_uri_prefix = "ftp://";

  if (strncmp(filename, www_uri_prefix, strlen(www_uri_prefix)) == 0 ||
      strncmp(filename, ftp_uri_prefix, strlen(ftp_uri_prefix)) == 0) {
    return TRUE;
  } else {
    return FALSE;
  }
}

/* եΥѥɤĴ٤ ************************************ */
gboolean
gnome_vfs_ext_is_local_filename (const char	*filename) {
  if (gnome_vfs_ext_is_local_uri(filename) ||
      gnome_vfs_ext_is_network_uri(filename)) {
    return FALSE;
  } else {
    return TRUE;
  }
}

/* ************************************************************************* */
GnomeVFSFileLocation
gnome_vfs_ext_get_location (const char	*filename) {
  return (gnome_vfs_ext_is_network_uri(filename)) ?
    GNOME_VFS_FILE_NETWORK : GNOME_VFS_FILE_LOCAL;
}

/* ѥURIޤ᤿ѥURIؿ ********************** */
#if 1
gchar*
gnome_vfs_ext_get_uri (const char	*filename) {
  char	*tilde_prefix	  = "~/";
  char	*current_dir, *path, *uri;
  
  if (gnome_vfs_ext_is_network_uri (filename)) {
    return g_strdup (filename);
  } else if (gnome_vfs_ext_is_local_uri (filename)) {
    return g_strdup (filename);
  } else {
    if (g_path_is_absolute (filename)) {
      if (strncmp (filename, tilde_prefix, strlen (tilde_prefix)) == 0) {
	return gnome_vfs_expand_initial_tilde (filename);
      } else {
	return gnome_vfs_get_uri_from_local_path (filename);
      }
    } else {
      current_dir = g_get_current_dir ();
      path = g_build_filename (current_dir, filename, NULL);
      uri = gnome_vfs_get_uri_from_local_path (path);
      g_free (current_dir);
      g_free (path);
      
      return uri;
    }
  }
}
#else
gchar*
gnome_vfs_ext_get_uri (const char	*filename) {
  return g_strdup (filename);
}
#endif

/* եΥȴؿ **************************************************** */
static gint
compare_by_type_and_spell (gconstpointer	data1,
			   gconstpointer	data2) {
  const gchar	*str1  = ((GnomeVFSFileInfo *) data1)->name;
  const gchar	*str2  = ((GnomeVFSFileInfo *) data2)->name;
  gint		ftype1 = ((GnomeVFSFileInfo *) data1)->type;
  gint		ftype2 = ((GnomeVFSFileInfo *) data2)->type;
  
  if (ftype1 == ftype2) {
    return strcmp(str1, str2);
  } else {
    return ftype2 - ftype1;
  }
}

/* ꤵ줿URI(ǥ쥯ȥ)ΥեꥹȤؿ ************* */
GList*
gnome_vfs_ext_ls_dir (const char	*path) {
  GList			*files = NULL;
  
  g_return_val_if_fail(path && *path, NULL);

  gnome_vfs_directory_list_load(&files, path, GNOME_VFS_FILE_INFO_DEFAULT);
  files = g_list_sort(files, compare_by_type_and_spell);

  return files;
}

/* *************************************** End of gnome-vfs-extensions.c *** */
