/* ***************************************************** gtkiconbutton.h *** *
 * GtkIconButton
 *
 * Copyright (C) 2002-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <03/01/06 23:26:49 sugaya>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 * ************************************************************************* */
#ifndef	__GTK_ICON_BUTTON_H__
#define	__GTK_ICON_BUTTON_H__

#include <gtk/gtk.h>

#ifdef __cplusplus
extern "C" {
#endif

#define GTK_TYPE_ICON_BUTTON		(gtk_icon_button_get_type ())
#define GTK_ICON_BUTTON(obj)		(GTK_CHECK_CAST (obj, GTK_TYPE_ICON_BUTTON, GtkIconButton))
#define GTK_IOCN_BUTTON_CLASS(class)	(GTK_CHECK_CLASS_CAST (class, GTK_TYPE_ICON_BUTTON, GtkIconButtonClass))
#define GTK_IS_ICON_BUTTON_CLASS(class)	(GTK_CHECK_CLASS_TYPE ((class), GTK_TYPE_ICON_BUTTON))
#define GTK_ICON_BUTTON_GET_CLASS(obj)	(GTK_CHECK_GET_CLASS ((obj), GTK_TYPE_ICON_BUTTON, GtkIconButtonClass))

  typedef struct	_GtkIconButton		GtkIconButton;
  typedef struct	_GtkIconButtonClass	GtkIconButtonClass;  

  struct _GtkIconButton {
    GtkButton	button;

    GtkWidget	*box;
    GtkWidget	*icon;
    GtkWidget	*label;
  };

  struct _GtkIconButtonClass {
    GtkButtonClass	parent_class;

    void (* pressed)  (GtkButton *button);
    void (* released) (GtkButton *button);
    void (* clicked)  (GtkButton *button);
    void (* enter)    (GtkButton *button);
    void (* leave)    (GtkButton *button);
  };

  enum {
    GTK_ICON_BUTTON_TEXT_TOP,
    GTK_ICON_BUTTON_TEXT_BOTTOM,
    GTK_ICON_BUTTON_TEXT_LEFT,
    GTK_ICON_BUTTON_TEXT_RIGHT
  };
  
  GtkType	gtk_icon_button_get_type	(void);
  GtkWidget*	gtk_icon_button_new		(const gchar	*filename);
  GtkWidget*	gtk_icon_button_new_from_inline (const guint8	*data);  
  GtkWidget*	gtk_icon_button_new_with_label	(const gchar	*filename,
						 const gchar	*label,
						 gint		text_position,
						 gint		border);
  GtkWidget*
  gtk_icon_button_new_from_inline_with_label	(const guint8	*data,
						 const gchar	*label,
						 gint		text_position,
						 gint		border);

#ifdef __cplusplus
}
#endif

#endif	/* __GTK_ICON_BUTTON_H__ */

/* ********************************************** End of gtkiconbutton.h *** */
