/* ************************************************************* image.h *** *
 * TEImage˴ؤؿ إåե
 *
 * Copyright (C) 2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/04/26 10:48:28 sugaya>
 * ************************************************************************* */
#ifndef __IMAGE_H__
#define __IMAGE_H__

/* ************************************************************************* */
#define	ti_get_image(list)	((TEImage *) (list)->data)
#define	ti_get_uri(list)	(((TEImage *) (list)->data)->uri)
#define	ti_get_xoffset(list)	(((TEImage *) (list)->data)->xoffset)
#define	ti_get_yoffset(list)	(((TEImage *) (list)->data)->yoffset)
#define	ti_get_width(list)	(((TEImage *) (list)->data)->width)
#define	ti_get_height(list)	(((TEImage *) (list)->data)->height)
#define	ti_get_nframes(list)	(((TEImage *) (list)->data)->nframes)
#define	ti_get_nchannels(list)	(((TEImage *) (list)->data)->nchannels)
#define	ti_get_type(list)	(((TEImage *) (list)->data)->type)
#define	ti_get_bit(list)	(((TEImage *) (list)->data)->bit)
#define	ti_get_location(list)	(((TEImage *) (list)->data)->location)
#define	ti_get_has_alpha(list)	(((TEImage *) (list)->data)->has_alpha)
#define	ti_get_pixbuf(list)	(((TEImage *) (list)->data)->pixbuf)
#define	ti_get_mod(list)	(((TEImage *) (list)->data)->mod)
#define	ti_get_pixbuf_list(list) (((TEImage *) (list)->data)->pixbuf_list)
#define ti_get_pixmap(list)	(((TEImage *) (list)->data)->pixmap)
#define	ti_get_pixmap_list(list) (((TEImage *) (list)->data)->pixmap_list)
#define	ti_get_frame(list)	(((TEImage *) (list)->data)->frame)
#define	ti_get_channel(list)	(((TEImage *) (list)->data)->channel)
#define	ti_get_min(list)	(((TEImage *) (list)->data)->min)
#define	ti_get_max(list)	(((TEImage *) (list)->data)->max)
#define	ti_get_fp(list)		(((TEImage *) (list)->data)->fp)
#define	ti_get_original_list(list) (((TEImage *) (list)->data)->original_list)
#define	ti_get_loader(list)	(((TEImage *) (list)->data)->loader)
#define	ti_get_backup(list)	(((TEImage *) (list)->data)->backup)

#define ti_set_min(list,val)	 (((TEImage *) (list)->data)->min = (val))
#define ti_set_max(list,val)	 (((TEImage *) (list)->data)->max = (val))
#define	ti_set_frame(list,val)   (((TEImage *) (list)->data)->frame = (val))
#define	ti_set_channel(list,val) (((TEImage *) (list)->data)->channel = (val))
#define	ti_set_pixbuf(list,val)  (((TEImage *) (list)->data)->pixbuf = (val))
#define	ti_set_pixmap(list,val)  (((TEImage *) (list)->data)->pixmap = (val))

/* ************************************************************************* *
 * ꤷɸβͤɤ߹ߡ񤭹
 * ************************************************************************* */
#define ti_get_pixel(list,x,y,p) \
(*(gdk_pixbuf_get_pixels((GdkPixbuf *)((TEImage *)(list)->data)->pixbuf) + \
 gdk_pixbuf_get_rowstride((GdkPixbuf *)((TEImage *)(list)->data)->pixbuf) * \
 (y) + \
 gdk_pixbuf_get_n_channels((GdkPixbuf *)((TEImage *)(list)->data)->pixbuf) * \
 (x) + (p)))

#define ti_put_pixel(list,x,y,p,val) \
(*(gdk_pixbuf_get_pixels((GdkPixbuf *)((TEImage *)(list)->data)->pixbuf) + \
 gdk_pixbuf_get_rowstride((GdkPixbuf *)((TEImage *)(list)->data)->pixbuf) * \
 (y) + \
 gdk_pixbuf_get_n_channels((GdkPixbuf *)((TEImage *)(list)->data)->pixbuf) * \
 (x) + (p)) = (val))

/* ************************************************************************* */
const gchar* ti_get_filename		(GList		*list);
GList*	     ti_get_list_from_uri 	(GList		*list,
					 const gchar	*uri);
GdkPixbuf*   ti_get_nth_plane 		(GList		*list,
					 gint		plane);
void         ti_get_pixel_range 	(GList		*list,
					 gdouble	*min,
					 gdouble	*max);
double       ti_get_pixel_from_original	(GList		*list,
					 gint		x,
					 gint		y,
					 gint		p);
TEImage*     teoeyes_image_new 		(const gchar	*uri_text,
					 GnomeVFSFileLocation	location);
void         teoeyes_image_free		(TEImage	*image);
void         teoeyes_image_set		(GList		*list,
					 gint		frame);
void         modify_pixbuf		(GList		*list,
					 GdkPixbuf	*pixbuf);
void         modify_pixmap		(GList		*list);

#endif /* __IMAGE_H__ */

/* ****************************************************** End of image.h *** */
