/* ****************************************************** image_loader.c *** *
 * ˴ؤؿ
 *
 * Copyright (C) 2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/06/27 17:27:58 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dlfcn.h>
#include <teo.h>
#include "teoeyes.h"

/* ν ****************************************************** */
GList*
image_loader_init (GSList	*name_list) {
  GList			*loader_list = NULL;
  GSList		*list;
  gchar			*loader_name;
  void			*handle;
  TeoeyesImageModule	*module;
  
  for (list = name_list; list; list = g_slist_next(list)) {
    loader_name = (gchar *) list->data;
    handle = dlopen(loader_name, RTLD_LAZY);
    module = dlsym(handle, "module");
    if (module) {
      module->load_info(module);
      loader_list = g_list_append(loader_list, handle);
    }
  }
  return loader_list;
}

/* ⥸塼β ******************************************************** */
void
image_loader_close (GList	*loader) {
  TeoeyesImageModule	*module;
  GList			*list;

  for (list = loader; list; list = g_list_next(list)) {
    module = dlsym(list->data, "module");
    g_free(module->info);
    dlclose(list->data);
  }
}

/* ԥåޥåץǡκ ********************************************** */
GdkPixmap*
create_pixmap_data (GdkPixbuf	*pixbuf) {
  GdkPixbuf	*background;
  GdkPixmap	*pixmap;
  gint		width, height;

  if (!pixbuf) return NULL;
  
  /*  */
  width  = gdk_pixbuf_get_width (pixbuf);
  height = gdk_pixbuf_get_height(pixbuf);

  /* Хå */
  background = gdk_pixbuf_new(GDK_COLORSPACE_RGB, FALSE, 8, width, height);

  /*  */
  gdk_pixbuf_composite_color(pixbuf,
			     background,
			     0, 0, width, height, 0, 0, 1.0, 1.0,
			     GDK_INTERP_TILES,
			     255,
			     0, 0,
			     16, 0xaaaaaa, 0x555555);
  
  /* ԥåޥåפ */
  gdk_pixbuf_render_pixmap_and_mask(background, &pixmap, NULL, 255);

  gdk_pixbuf_unref(background);
  
  return pixmap;
}

/* ************************************************************************* */
GdkPixbuf*
teoeyes_image_load_pixbuf_simple (GList		*loader_list,
				  const gchar	*uri) {
  TeoeyesImageModule	*module;
  GdkPixbuf		*pixbuf = NULL;

  switch (tc->loader_selection) {
  case LOADER_SELECT_FROM_FILE:
    module = teoeyesloader_select_from_file(loader_list, uri);
    break;
  case LOADER_SELECT_FROM_MIME:
    module = teoeyesloader_select_from_mime(loader_list, uri);
    break;
  case LOADER_SELECT_FROM_EXTENSION:
  default:
    module = teoeyesloader_select_from_extension(loader_list, uri);
    break;
  }
  pixbuf = module->load(uri, NULL);

  return pixbuf;
}

/* ************************************************************************* */
GdkPixbuf*
teoeyes_image_load_pixbuf (TEImage	*image,
			   gboolean	create_pixmap) {
  GdkPixbuf	*pixbuf = NULL;
  GdkPixmap	*pixmap;
  GList		*list;
  
  if (!image->loader) return NULL;
  if (strcmp (image->loader->info->name, "TEO") == 0) {
    image->user_data[0] = option->normalize;
    image->user_data[1] = option->load_all;    
    pixbuf = image->loader->load(image->uri, image);
  } else {
    image->frame = 0;
    pixbuf = image->loader->load(image->uri, NULL);
    if (pixbuf) {
      image->pixbuf_list = g_list_append(image->pixbuf_list, pixbuf);
    }
  }
  if (create_pixmap) {
    for (list = image->pixbuf_list; list; list = g_list_next(list)) {
      pixmap = create_pixmap_data((GdkPixbuf *) list->data);
      image->pixmap_list = g_list_append(image->pixmap_list, pixmap);
    }
    image->pixmap = g_list_nth_data(image->pixmap_list, image->frame);
  }
  return pixbuf;
}

/* ************************************************************************* */
gboolean
teoeyes_image_load (TEImage	*image,
		    GList	*loader,
		    gint	frame,
		    gboolean	create_pixmap) {
  GList	*list;
  
  /* ѥ᡼Ͽ */
  image->frame = frame;

  /*  */
  if (!image->loader) {
    switch (tc->loader_selection) {
    case LOADER_SELECT_FROM_FILE:
      image->loader = teoeyesloader_select_from_file(loader, image->uri);
      break;
    case LOADER_SELECT_FROM_MIME:
      image->loader = teoeyesloader_select_from_mime(loader, image->uri);
      break;
    case LOADER_SELECT_FROM_EXTENSION:
    default:
      image->loader = teoeyesloader_select_from_extension(loader, image->uri);
      break;
    }
    if (!image->loader) return FALSE;
  }
  /* ˤǡ */
  if (image->pixbuf_list) {
    g_list_foreach(image->pixbuf_list, (GFunc) gdk_pixbuf_unref, NULL);
    g_list_free(image->pixbuf_list);
    image->pixbuf_list = NULL;
    image->pixbuf      = NULL;
  }
  if (image->pixmap_list) {
    g_list_foreach(image->pixmap_list, (GFunc) gdk_pixmap_unref, NULL);
    g_list_free(image->pixmap_list);
    image->pixmap_list = NULL;
    image->pixmap      = NULL;
  }
  if (image->original_list) {
    for (list = image->original_list; list; list = g_list_next(list)) {
      TeoFreeImage(list->data);
    }
    g_list_free(image->original_list);
    image->original_list = NULL;
  }
  if (image->backup) {
    gdk_pixbuf_unref(image->backup);
    image->backup = NULL;
  }
  /* ǡɤ߹ */
  image->pixbuf = teoeyes_image_load_pixbuf(image, create_pixmap);

  /* ѥ᡼Ͽ */
  if (image->pixbuf) {
    image->has_alpha = gdk_pixbuf_get_has_alpha(image->pixbuf);
    image->width     = gdk_pixbuf_get_width(image->pixbuf);
    image->height    = gdk_pixbuf_get_height(image->pixbuf);
    if (image->nchannels == 3 && image->has_alpha) image->nchannels = 4;
    return TRUE;
  } else {
    return FALSE;
  }
}

/* βǡ򥻥åȤ **************************************** */
void
teoeyes_image_set_memory (TEImage	*image,
			  GdkPixbuf	*pixbuf) {
  image->pixbuf_list = g_list_append(image->pixbuf_list, pixbuf);
  image->pixbuf = image->pixbuf_list->data;
  image->width  = gdk_pixbuf_get_width(pixbuf);
  image->height = gdk_pixbuf_get_height(pixbuf);
}

/* ****************************************************** image_loader.c *** */
