/* ****************************************************** image_window.c *** *
 * $B%a%$%s%&%#%s%I%&$K4X$9$k4X?t(B
 *
 * Copyright (C) 2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <05/07/21 10:00:42 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <dlfcn.h>
#include "teoeyes.h"
#include "teoeyes_menu.h"
#include "menu_callbacks.h"
#include "cripping.h"
#include "dnd.h"
#include "loope.h"
#include "pixel_window.h"
#include "teoeyes_plugin.h"
#include "plugin.h"

#define	STOCK_DIR	"stock"

/* ************************************************************************* */
static void	cb_expose 	(GtkWidget	*widget,
				 GdkEventExpose	*ev);
static gboolean	cb_mouse_press 	(GtkWidget	*widget,
				 GdkEventButton	*ev);
static gboolean	cb_mouse_motion (GtkWidget	*widget,
				 GdkEventMotion	*ev);
static gboolean cb_mouse_release(GtkWidget	*widget,
				 GdkEventButton	*ev);

/* $B%]%C%W%"%C%W%a%K%e!<(B **************************************************** */
#include "main_menu_item.h"
#include "popup_menu_item.h"

/* $B%(%/%9%]!<%:%$%Y%s%H(B **************************************************** */
static void
cb_expose (GtkWidget		*widget,
	   GdkEventExpose	*ev) {
  if (ti_get_width(image_list)  != widget->allocation.width ||
      ti_get_height(image_list) != widget->allocation.height) {
    G_SET_PARAMETER(image_window, "forcescroll", TRUE);
    image_window_set_size(image_window,
			  ti_get_width(image_list), ti_get_height(image_list));
  } else {
    image_window_set_size(image_window,
		     ti_get_width(image_list), ti_get_height(image_list));
  }
}

/* $B%^%&%9%\%?%s$,2!$5$l$?$H$-$N=hM}(B **************************************** */
static gboolean
cb_mouse_press (GtkWidget	*widget,
		GdkEventButton	*ev) {
  GtkWidget	*popup;
  gint		x, y, w, h, lx, ly, scale;
  
  /* $B%U%)!<%+%9$N%;%C%H(B */
  if (!GTK_WIDGET_HAS_FOCUS (widget)) gtk_widget_grab_focus (widget);

  /* $B%^%&%9%]%$%s%?$N:BI83MF@(B */
  w = widget->allocation.width;
  h = widget->allocation.height;
  x = (gint) (ev->x * ti_get_width  (image_list) / w);
  y = (gint) (ev->y * ti_get_height (image_list) / h);
  G_SET_PARAMETER (image_window, "x", x);
  G_SET_PARAMETER (image_window, "y", y);

  switch (ev->button) {
  case MOUSE_BUTTON_CENTER:
    if ((ev->state & 0xf) == 4) { /* $B%/%j%C%T%s%0$N<B9T(B */
      crip_do_crip ();
    } else {
      if (!loope) loope = loope_new (_("Loope Window"),
				     LOOPE_WINDOW_SIZE, LOOPE_WINDOW_SIZE);
      if (!GTK_WIDGET_VISIBLE (loope)) gtk_widget_show (loope);

      scale = (gint) G_GET_PARAMETER (image_window, "scale");
      lx = ly = LOOPE_WINDOW_SIZE / 2 - scale;
      G_SET_PARAMETER (image_window, "lx", lx);
      G_SET_PARAMETER (image_window, "ly", ly);

      draw_loope_image (G_GET_WIDGET (loope, "canvas"),
			image_list, x, y, lx, ly, scale);
      draw_scope (widget, x, y, scale);
    
      if (!pixel_window) pixel_window = pixel_window_new ();
      if (!GTK_WIDGET_VISIBLE(pixel_window)) gtk_widget_show_all(pixel_window);
      gdk_window_raise (pixel_window->window);
      pixel_window_show (image_list, x, y,
			 ((ev->state & 0xf) == 1) ?
			 PIXEL_INFO_TYPE_CURRENT : PIXEL_INFO_TYPE_ORIGINAL,
			 gdk_x11_drawable_get_xdisplay (ev->window), ev->time);
    }
    break;
  case MOUSE_BUTTON_RIGHT:
    popup = G_GET_WIDGET(image_window, "popupmenu");
    if (popup) {
      gtk_menu_popup(GTK_MENU(popup), NULL, NULL, NULL, NULL, 3, ev->time);
    }
    break;
  case MOUSE_BUTTON_LEFT:
  default:
    if (!pixel_window) pixel_window = pixel_window_new();
    if (!GTK_WIDGET_VISIBLE (pixel_window)) gtk_widget_show_all(pixel_window);
    gdk_window_raise(pixel_window->window);
    pixel_window_show(image_list, x, y,
		      ((ev->state & 0xf) == 1) ?
		      PIXEL_INFO_TYPE_CURRENT : PIXEL_INFO_TYPE_ORIGINAL, 
		      gdk_x11_drawable_get_xdisplay (ev->window), ev->time);

    /* CTRL$B%-!<$,2!$5$l$F$$$?$i%/%j%C%T%s%0%b!<%I$X(B */
    if ((ev->state & 0xf) == 4) crip_mouse_press ((gint) ev->x, (gint) ev->y);
    
    break;
  }
  return FALSE;
}

/* $B%^%&%9$r%I%i%C%0$7$?;~$N=hM}(B ******************************************** */
static gboolean
cb_mouse_motion (GtkWidget	*widget,
		 GdkEventMotion	*ev) {
  gint			x, y, w, h, lx, ly, ox, oy, scale;
  GdkModifierType	state;

  /* $B%^%&%9%]%$%s%?$N:BI83MF@(B */  
  if (ev->is_hint) {
    gdk_window_get_pointer (ev->window, &x, &y, &state);
    ox = x;
    oy = y;
  } else {
    x	= (gint) ev->x;
    y	= (gint) ev->y;
    ox	= x;
    oy	= y;
    state = ev->state;
  }
  w = widget->allocation.width;
  h = widget->allocation.height;

  if (x < 0)   x = 0;
  if (y < 0)   y = 0;
  if (x > w-1) x = w - 1;
  if (y > h-1) y = h - 1;  
  x = x * ti_get_width  (image_list) / w;
  y = y * ti_get_height (image_list) / h;

  /* $B3F%\%?%s$K@_Dj$5$l$?=hM}(B */  
  if ((state & GDK_BUTTON1_MASK) != 0) {	/* $B:8%\%?%s(B */
    /* $B8=:_$N:BI8$rJ]B8(B */
    G_SET_PARAMETER (image_window, "x", x);
    G_SET_PARAMETER (image_window, "y", y);

    /* $B2hAGCM$NI=<((B */    
    if (!pixel_window) pixel_window = pixel_window_new ();
    if (!GTK_WIDGET_VISIBLE (pixel_window)) gtk_widget_show_all (pixel_window);
    pixel_window_show (image_list, x, y,
		       ((ev->state & 0xf) == 1) ?
		       PIXEL_INFO_TYPE_CURRENT : PIXEL_INFO_TYPE_ORIGINAL, 
		       gdk_x11_drawable_get_xdisplay (ev->window), ev->time);

    /* CTRL$B%-!<$,2!$5$l$F$$$?$i%/%j%C%T%s%0%b!<%I$X(B */    
    if ((ev->state & 0xf) == 4) crip_mouse_move (ox, oy); 

  } else if ((state & GDK_BUTTON2_MASK) != 0) {	/* $BCf%\%?%s(B */
    if (!loope) loope = loope_new (_("Loope Window"),
				   LOOPE_WINDOW_SIZE, LOOPE_WINDOW_SIZE);
    if (!GTK_WIDGET_VISIBLE (loope)) gtk_widget_show (loope);

    if ((x != (gint) G_GET_PARAMETER (image_window, "x")) ||
	(y != (gint) G_GET_PARAMETER (image_window, "y"))) {

      scale = (gint) G_GET_PARAMETER (image_window, "scale");
      lx = ly = LOOPE_WINDOW_SIZE / 2 - scale;

      G_SET_PARAMETER (image_window, "x",  x);
      G_SET_PARAMETER (image_window, "y",  y);
      G_SET_PARAMETER (image_window, "lx", lx);
      G_SET_PARAMETER (image_window, "ly", ly);

      draw_loope_image (G_GET_WIDGET(loope, "canvas"),
			image_list, x, y, lx, ly, scale);
      draw_scope (widget, x, y, scale);      
    }
    if (!pixel_window) pixel_window = pixel_window_new ();
    if (!GTK_WIDGET_VISIBLE (pixel_window)) gtk_widget_show_all (pixel_window);
    pixel_window_show (image_list, x, y,
		       ((ev->state & 0xf) == 1) ?
		       PIXEL_INFO_TYPE_CURRENT : PIXEL_INFO_TYPE_ORIGINAL, 
		       gdk_x11_drawable_get_xdisplay (ev->window), ev->time);
  }
  return FALSE;
}

/* $B%^%&%9%\%?%s$r2!$7$?;~$N=hM}(B ******************************************** */
static gboolean
cb_mouse_release (GtkWidget		*widget,
		  GdkEventButton	*ev) {
  gint	in_crip;

  in_crip = (gint) G_GET_PARAMETER (image_window, "crip_do");
  if (!in_crip) {
    gdk_window_clear_area (widget->window, 0, 0,
			   widget->allocation.width, 
			   widget->allocation.height);
  }	
  return FALSE;
}

/* $B%9%/%m!<%k5!G=IU$-%&%#%s%I%&$NI=<((B ************************************** */
void
image_window_set_size (GtkWidget	*widget,
		       gint		width,
		       gint		height) {
  GtkWidget	*canvas;
  GtkWidget	*scroll_window;
  GtkWidget	*box;
  GtkWidget	*alignment;
  gboolean	scrollable;
  gboolean	forcescroll;
  gint		rw, rh;

  /* $B%&%#%8%'%C%H$N3MF@(B */
  canvas 	= G_GET_WIDGET(widget, "canvas");
  scroll_window = G_GET_WIDGET(widget, "scrollwindow");
  box		= G_GET_WIDGET(widget, "imagebox");
  alignment	= G_GET_WIDGET(widget, "alignment");

  /* $B%Q%i%a!<%?$N3MF@(B */
  scrollable  = (gboolean) G_GET_PARAMETER(widget, "scrollable");
  forcescroll = (gboolean) G_GET_PARAMETER(widget, "forcescroll");

  /* $B2hLL%5%$%:$N3MF@(B */
  gdk_window_get_size (GDK_ROOT_PARENT(), &rw, &rh);

  /* $B%9%/%m!<%k%P!<$,I=<($5$l$F$$$J$$>l9g(B...
     $B2hA|%5%$%:$,2hLL%5%$%:$h$jBg$-$+$C$?$i(B */
  if (!scrollable) {
    if (width > rw && height > rh) {
      gtk_widget_set_size_request(widget, rw - 64, rh - 64);
    } else if (width > rw) {
      gtk_widget_set_size_request(widget, rw - 64, height - 32);      
    } else if (height > rh) {
      gtk_widget_set_size_request(widget, width - 32, rh - 64);
    }
  }
  if (width > rw || height > rh || forcescroll) {
    if (!scrollable) {
      gtk_window_set_policy(GTK_WINDOW (widget), TRUE, TRUE, FALSE);
      gtk_widget_show(scroll_window);
      gtk_widget_reparent(canvas, alignment);
      gtk_widget_set_size_request(scroll_window, -1, -1);
        G_SET_PARAMETER(widget, "scrollable", TRUE);
    }
  }
  /* $B2hA|$NIA2h(B */
  gtk_widget_set_size_request(canvas, width, height);  
  draw_image(image_list, width, height);
}

/* $B%a%K%e!<%"%$%3%s$N@_Dj(B ************************************************** */
static void
set_icon (TeoeyesUIInfo	uiinfo[],
	  gchar		*icon_file[],
	  int		nitems) {
  int	n;
  
  for (n = 0; n < nitems; n++) {
    if (icon_file[n]) {
      uiinfo[n].pixmap_info
	= (gpointer) g_build_filename(tc->icon_folder,
				      STOCK_DIR, icon_file[n], NULL);
    }
  }
}

/* ************************************************************************* */
static void
plugin_menu_set (TeoeyesUIInfo		*plugin_menu,
		 TeoeyesPluginInfo	*pinfo,
		 gint			id) {
  plugin_menu->type            = pinfo->menuitem.type;
  plugin_menu->label           = g_strdup (pinfo->menuitem.label);
  plugin_menu->hint            = pinfo->menuitem.hint;
  plugin_menu->moreinfo        = (gpointer) plugin_callback;
  plugin_menu->user_data       = (gpointer) id;
  plugin_menu->unused_data     = pinfo->menuitem.unused_data;
  plugin_menu->pixmap_type     = pinfo->menuitem.pixmap_type;
  plugin_menu->pixmap_info     = pinfo->menuitem.pixmap_info;
  plugin_menu->accelerator_key = pinfo->menuitem.accelerator_key;
  plugin_menu->ac_mods         = pinfo->menuitem.ac_mods;
  plugin_menu->widget          = pinfo->menuitem.widget;
}

/* $B%a%$%s%a%K%e!<$N@8@.(B **************************************************** */
static GtkWidget*
main_menu_new (GtkWidget	*window) {
  GtkWidget		*menubar;
  GtkAccelGroup		*accel;
  TeoeyesUIInfo		*plugin_menu;
  TeoeyesPluginInfo	*pinfo;
  GList			*list;
  gint			n;
  
  set_icon(file_menu_uiinfo, file_menu_icon,
	   sizeof(file_menu_icon) / sizeof(file_menu_icon[0]));
  set_icon(view_menu_uiinfo, view_menu_icon,
	   sizeof(view_menu_icon) / sizeof(view_menu_icon[0]));
  set_icon(imagecontrol_menu_uiinfo, imagecontrol_menu_icon,
	   sizeof(imagecontrol_menu_icon) / sizeof(imagecontrol_menu_icon[0]));
  set_icon(framecontrol_menu_uiinfo, framecontrol_menu_icon,
	   sizeof(framecontrol_menu_icon) / sizeof(framecontrol_menu_icon[0]));
  set_icon(planecontrol_menu_uiinfo, planecontrol_menu_icon,
	   sizeof(planecontrol_menu_icon) / sizeof(planecontrol_menu_icon[0]));
  set_icon(size_menu_uiinfo, size_menu_icon,
	   sizeof(size_menu_icon) / sizeof(size_menu_icon[0]));
  set_icon(edit_menu_uiinfo, edit_menu_icon,
	   sizeof(edit_menu_icon) / sizeof(edit_menu_icon[0]));
  set_icon(window_menu_uiinfo, window_menu_icon,
	   sizeof(window_menu_icon) / sizeof(window_menu_icon[0]));
  set_icon(property_menu_uiinfo, property_menu_icon,
	   sizeof(property_menu_icon) / sizeof(property_menu_icon[0]));
  set_icon(help_menu_uiinfo, help_menu_icon,
	   sizeof(help_menu_icon) / sizeof(help_menu_icon[0]));

  plugin_menu = menu_uiinfo[3].moreinfo
    = (gpointer) g_new0(TeoeyesUIInfo, g_list_length(plugin_list) + 2);
  for (n = 1, list = plugin_list; list; n++, list = g_list_next(list)) {
    pinfo = dlsym(list->data, "plugin_info");
    plugin_menu_set (&plugin_menu[n], pinfo, n-1);
  }
  plugin_menu[0].type = TEOEYES_UI_TEAROFF;
  plugin_menu[g_list_length(plugin_list) + 1].type = TEOEYES_UI_ENDOFINFO;
  menu_uiinfo[3].type = TEOEYES_UI_SUBTREE;

  accel   = gtk_accel_group_new();
  menubar = gtk_menu_bar_new();
  teoeyes_fill_menu(GTK_MENU_SHELL(menubar), accel, menu_uiinfo);

  return menubar;
}
/* $B%]%C%W%"%C%W%a%K%e!<$N@8@.(B ********************************************** */
static GtkWidget*
popup_menu_new (GtkWidget	*window) {
  GtkWidget		*menu;
  GtkAccelGroup		*accel;
  TeoeyesUIInfo		*plugin_menu;
  TeoeyesPluginInfo	*pinfo;
  GList			*list;
  gint			n;
  
  set_icon(p_menu_uiinfo, p_menu_icon,
	   sizeof(p_menu_icon) / sizeof(p_menu_icon[0]));
  set_icon(p_file_menu_uiinfo, p_file_menu_icon,
	   sizeof(p_file_menu_icon) / sizeof(p_file_menu_icon[0]));
  set_icon(p_view_menu_uiinfo, p_view_menu_icon,
	   sizeof(p_view_menu_icon) / sizeof(p_view_menu_icon[0]));
  set_icon(p_imagecontrol_menu_uiinfo, p_imagecontrol_menu_icon,
	   sizeof(p_imagecontrol_menu_icon)
	   / sizeof(p_imagecontrol_menu_icon[0]));
  set_icon(p_framecontrol_menu_uiinfo, p_framecontrol_menu_icon,
	   sizeof(p_framecontrol_menu_icon)
	   / sizeof(p_framecontrol_menu_icon[0]));
  set_icon(p_planecontrol_menu_uiinfo, p_planecontrol_menu_icon,
	   sizeof(p_planecontrol_menu_icon)
	   / sizeof(p_planecontrol_menu_icon[0]));
  set_icon(p_size_menu_uiinfo, p_size_menu_icon,
	   sizeof(p_size_menu_icon) / sizeof(p_size_menu_icon[0]));
  set_icon(p_edit_menu_uiinfo, p_edit_menu_icon,
	   sizeof(p_edit_menu_icon) / sizeof(p_edit_menu_icon[0]));
  set_icon(p_window_menu_uiinfo, p_window_menu_icon,
	   sizeof(p_window_menu_icon) / sizeof(p_window_menu_icon[0]));

  plugin_menu = p_menu_uiinfo[6].moreinfo
    = (gpointer) g_new0(TeoeyesUIInfo, g_list_length(plugin_list) + 1);
  for (n = 1, list = plugin_list; list; n++, list = g_list_next(list)) {
    pinfo = dlsym(list->data, "plugin_info");
    plugin_menu_set (&plugin_menu[n], pinfo, n-1);
  }
  plugin_menu[0].type   = TEOEYES_UI_TEAROFF;
  plugin_menu[g_list_length(plugin_list) + 1].type = TEOEYES_UI_ENDOFINFO;
  p_menu_uiinfo[6].type = TEOEYES_UI_SUBTREE;

  accel = gtk_accel_group_new();
  gtk_window_add_accel_group(GTK_WINDOW(window), accel);
  menu = gtk_menu_new();
  teoeyes_fill_menu(GTK_MENU_SHELL(menu), accel, p_menu_uiinfo);

  return menu;
}


/* $B2hA|%&%#%s%I%&$N@8@.(B **************************************************** */
GtkWidget*
image_window_new (const gchar	*title,
		  gint		width,
		  gint		height) {
  GtkWidget	*window;
  GtkWidget	*box;
  GtkWidget	*hbox;
  GtkWidget	*canvas;
  GtkWidget	*scrollwindow;
  GtkWidget	*alignment;
  GtkWidget	*menubar;
  GtkWidget	*popupmenu;
  gchar		*iconfile;
  
  /* $B%&%#%s%I%&$N@8@.(B */
  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_size_request(window, width, height);

  /* $B%?%$%H%k$N@_Dj(B */
  gtk_window_set_title(GTK_WINDOW(window), title);

  /* $B%\!<%@!<%5%$%:$N@_Dj(B */
  gtk_container_set_border_width(GTK_CONTAINER(window), 0);

  /* $B%j%5%$%:$N@_Dj(B */
  gtk_window_set_resizable(GTK_WINDOW(window), TRUE);

  /* $B%&%#%s%I%&$KBP$9$k%3!<%k%P%C%/4X?t$N@_Dj(B */
  g_signal_connect(G_OBJECT(window), "destroy", G_CALLBACK(cb_quit), NULL);

  /* $B%Q%C%-%s%0%\%C%/%9$N@8@.(B */
  box = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(window), box);
  {
    hbox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(box), hbox, FALSE, FALSE, 0);
    {
      /* $B%a%K%e!<$N@8@.(B */
      menubar = main_menu_new(window);
      gtk_box_pack_start(GTK_BOX(hbox), menubar, FALSE, FALSE, 0);
    }
    /* $B%-%c%s%P%9$N@8@.(B */
    canvas = gtk_drawing_area_new();
    gtk_box_pack_start(GTK_BOX(box), canvas, TRUE, TRUE, 0);
    gtk_widget_set_size_request(canvas, width, height);

    /* $B%-%c%s%P%9$KBP$9$k%3!<%k%P%C%/4X?t$N@_Dj(B */
    gtk_widget_set_events(canvas,
			  GDK_EXPOSURE_MASK |
			  GDK_BUTTON_PRESS_MASK |
			  GDK_BUTTON_RELEASE_MASK |
			  GDK_POINTER_MOTION_MASK |
			  GDK_POINTER_MOTION_HINT_MASK);

    g_signal_connect(G_OBJECT(canvas),
		     "expose_event", G_CALLBACK(cb_expose), NULL);
    g_signal_connect(G_OBJECT(canvas),
		     "button_press_event", G_CALLBACK(cb_mouse_press), NULL);
    g_signal_connect(G_OBJECT(canvas),
		     "button_release_event",G_CALLBACK(cb_mouse_release),NULL);
    g_signal_connect(G_OBJECT(canvas),
		     "motion_notify_event", G_CALLBACK(cb_mouse_motion), NULL);

    scrollwindow = gtk_scrolled_window_new(NULL, NULL);
    gtk_box_pack_start(GTK_BOX(box), scrollwindow, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrollwindow),
				   GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    {
      /* $B%"%i%$%s%a%s%H$N@8@.(B */
      alignment = gtk_alignment_new(0.5, 0.5, 0.0, 0.0);
      gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrollwindow),
					    alignment);
    }
  }
  /* $B%]%C%W%"%C%W%a%K%e!<$N@8@.(B */
  popupmenu = popup_menu_new(window);

  /* $B%I%i%C%0(B&$B%I%m%C%W$N@_Dj(B */
  dnd_drop_on_widget (window);

  /* $B%"%$%3%s$NEPO?(B */
  iconfile = g_strdup_printf("%s/%s", PACKAGE_PIXMAPS_DIR, "teoeyes-icon.png");
  gtk_widget_realize(window);
  gtk_window_set_icon_from_file(GTK_WINDOW(window), iconfile, NULL);
  gdk_window_set_icon_name(window->window, _("TeoEyes"));
  g_free(iconfile);
  
  /* $B%&%#%8%'%C%H$NEPO?(B */
  G_SET_OBJECT(window, "imagebox",	box);
  G_SET_OBJECT(window, "canvas",	canvas);
  G_SET_OBJECT(window, "hbox",		hbox);
  G_SET_OBJECT(window, "scrollwindow",	scrollwindow);
  G_SET_OBJECT(window, "alignment",	alignment);
  G_SET_OBJECT(window, "menubar",	menubar);  
  G_SET_OBJECT(window, "popupmenu",	popupmenu);

  /* $B%Q%i%a!<%?$NEPO?(B */
  G_SET_PARAMETER (window, "scrollable",	FALSE);
  G_SET_PARAMETER (window, "forcescroll",	FALSE);
  G_SET_PARAMETER (window, "show_meunbar",	FALSE);
  G_SET_PARAMETER (window, "x",			0);
  G_SET_PARAMETER (window, "y",			0);
  G_SET_PARAMETER (window, "lx", LOOPE_WINDOW_SIZE / 2 - tc->loope_size);
  G_SET_PARAMETER (window, "ly", LOOPE_WINDOW_SIZE / 2 - tc->loope_size);
  G_SET_PARAMETER (window, "scale",		tc->loope_size);

  gtk_widget_show_all(window);
  gtk_widget_show_all(popupmenu);
  gtk_widget_hide(scrollwindow);
  gtk_widget_hide(menubar);

  return window;
}

/* *********************************************** End of image_window.c *** */
