/* ************************************************************** init.c *** *
 * ؿ
 *
 * Copyright (C) 2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/07/20 11:32:59 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "teoeyes.h"

#include "teoeyes_icon.icon"

/* ************************************************************************* */
static gchar *prop_key_version        = "/apps/teoeyes/version";

/* 饤֥ν ****************************************************** */
GnomeProgram*
teoeyes_init (int	argc,
	      char	**argv) {
  GnomeProgram	*program;

  /*  */
  bindtextdomain(GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
  textdomain(GETTEXT_PACKAGE);

  /* GTK/GNOME饤֥ν */
  g_thread_init(NULL);
  program = gnome_program_init(PACKAGE, VERSION, LIBGNOMEUI_MODULE,
			       argc, argv, NULL);
  /* Хѿν */
  pixel_window  = NULL;
  list_window   = NULL;
  edit_window   = NULL;
  browse_window = NULL;
  player	= NULL;
  loope		= NULL;
  assistant	= NULL;
  info_dialog   = NULL;
  config_dialog = NULL;
  update_timer	= 0;
  
  return program;
}

/* եɤ߹ ************************************************** */
TEConfig*
teoeyes_config_init (GnomeProgram	*program,
		     GConfClient	**client,
		     gchar		**path) {
  gchar		*version = NULL;
  
  /* GConf饤ȤؤΥ */
  *client = gconf_client_get_default();
  gconf_client_set_error_handling(*client, GCONF_CLIENT_HANDLE_UNRETURNED);
  *path = gnome_gconf_get_app_settings_relative(program, "");
  gconf_client_add_dir(*client, *path, GCONF_CLIENT_PRELOAD_RECURSIVE, NULL);

  /* ϤƤεưʤ¸ */
  version = gconf_client_get_string(*client, prop_key_version, NULL);
  if (!version || strcmp (version, VERSION) < 0) config_save_first(*client);
  if (version)  g_free(version);
  
  /* ɤ߹ */
  return config_load (*client);
}

/* ץν ****************************************************** */
TEOption*
teoeyes_option_new (TEConfig	*config) {
  TEOption	*option;

  option = g_new0(TEOption, 1);
  option->load_all      = config->option_load_all;
  option->normalize     = config->option_normalize;
  option->create_pixmap = config->option_create_pixmap;
  option->frame		= 0;
  option->wallpaper	= 0;
  option->min		= (tc->option_normalize) ? -1 : 0;
  option->max		= (tc->option_normalize) ? -1 : 0;
  option->geometry	= NULL;

  return option;
}

/* ץ¤ΰβ ********************************************** */
void
teoeyes_option_free (TEOption	*option) {
  if (option) {
    if (option->geometry) g_free (option->geometry);
    g_free (option);
  }
}

/* ƥ ************************************************ */
GdkPixbuf*
teoeyes_icon_new (void) {
  GdkPixbuf	*pixbuf;

  pixbuf = gdk_pixbuf_new_from_inline (-1, teoeyes_icon_data, FALSE, NULL);
  
  return pixbuf;
}

/* ******************************************************* End of init.c *** */
