/* ******************************************************** parse_args.c *** *
 * ϴؿ
 *
 * Copyright (C) 2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/07/01 02:20:30 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "teoeyes.h"
#include <ctype.h>

/* ؿ ************************************************************ */
static void		parse_geometry_size 	(gchar		*option,
						 WindowGeometry	**geometry);
static void		parse_geometry_position	(gchar		*option,
						 WindowGeometry	**geometry);
static WindowGeometry*	parse_geometry		(gchar		*option);
static void		parse_sequence_file	(GList		**list,
						 gchar		*filename,
						 gint		start,
						 gint		end,
						 gint		step);

/* ץλɽ **************************************************** */
void
usage (void) {
  /* ɽ */
  g_print("\n"
	  "----------------------------------------------------------"
	  "-----------------\n");
  g_print("  TeoEyes Version %s                                       "
	  "     Usage\n", VERSION);
  g_print("----------------------------------------------------------"
	  "-----------------\n"
	  "> teoeyes file1 file2 ... [option]\n"
	  "\n"
	  "[option]\n"
	  "   -l                         : load all the image\n"
	  "   -Nl                        : cancel -l option\n"
	  "\n"

	  "   -p                         : create pixmap data\n"
	  "   -Np                        : cancel -p option\n"
	  "\n"
	  
	  "   -f #                       "
	  ": display #th frame (only TEO format)\n"
	  "\n"

	  "   -s [file_header] #1 #2 #3  : load sequence files\n"
	  "                                (#1:Start #2:End #3:Step)\n"
	  "\n"

	  "   --wallpaper #              : set the image as wallpaper.\n"
	  "                                "
	  "(# 1:TILED 2:CENTERED 3:STRETCHED 4:SCALED)\n"
	  "\n"
	  "   -g window-geometry         : set the window geometry\n"
	  "\n"
	  "   -h                         : show this usage\n"
	  "   -v                         : show the teoeyes version\n"
	  "----------------------------------------------------------"
	  "-----------------\n"
	  "\n");
  exit(1);
}
   
/* Сɽ ********************************************************** */
void
version (void) {
  g_print("TeoEyes Ver%s\n", VERSION);
  exit(1);
}

/* Υå ********************************************************** */
GList*
parse_args (int		argc,                                    /* ο */
	    char	**argv,                                      /*  */
	    TEOption	**option) {
  GList		*image_list = NULL;
  TEImage	*image;
  GnomeVFSURI	*uri;
  gchar		*uri_text, *filename;
  int		args;
  int		start, end, step;
  
  for(args = 1; args < argc; ++args) {
    if ((*argv[args] == '-') && *(argv[args]+1)) {
      if ((strcmp("h", ++argv[args])) == 0) {		/* -h */
	usage();
      } else if ((strcmp ("v", argv[args])) == 0) {	/* -v */
	version();
      } else if ((strcmp ("l", argv[args])) == 0) {	/* -l */
	(*option)->load_all = TRUE;
      } else if ((strcmp ("Nl", argv[args])) == 0) {	/* -Nl */
	(*option)->load_all = FALSE;
      } else if ((strcmp ("N", argv[args])) == 0) {	/* -N */
	(*option)->normalize = TRUE;
      } else if ((strcmp ("NN", argv[args])) == 0) {	/* -NN */
	(*option)->normalize = FALSE;
      } else if ((strcmp ("p", argv[args])) == 0) {	/* -p */
	(*option)->create_pixmap = TRUE;
      } else if ((strcmp ("Np", argv[args])) == 0) {	/* -Np */
	(*option)->create_pixmap = FALSE;
      } else if ((strcmp ("f", argv[args])) == 0) {	/* -f */
	if (++args >= argc) return 0;
	(*option)->frame = atoi(argv[args]);
      } else if ((strcmp ("s", argv[args])) == 0) {     /* -s */
	if (++args >= argc) return 0;
	filename = argv[args];
        if (++args >= argc) return 0;
        start = atoi (argv[args]);
        if (++args >= argc) return 0;
	end   = atoi (argv[args]);
	if (++args >= argc) return 0;
	step  = atoi (argv[args]);
	parse_sequence_file (&image_list,filename, start, end, step);
      } else if ((strcmp ("g", argv[args])) == 0) {	/* -g */
	if (++args >= argc) return 0;
	(*option)->geometry = parse_geometry (argv[args]);
      } else if ((strcmp ("-wallpaper", argv[args])) == 0) {/* --wallpaper */
	if (++args >= argc) return 0;
	(*option)->wallpaper = atoi(argv[args]);
      }
    } else {
      if (strcmp(argv[args], "-") == 0) {	/* ɸϤ */
	image = teoeyes_image_new(argv[args], GNOME_VFS_FILE_MEMORY);
      } else {					/* ե뤫 */
	uri_text = gnome_vfs_ext_get_uri(argv[args]);
	image = teoeyes_image_new(uri_text,
				  gnome_vfs_ext_get_location(uri_text));
	g_free(uri_text);
      }
      if (image) image_list = g_list_append(image_list, image);
    }
  }
  if (!image_list) {
    /* ¸ߤ뤫Ĵ٤ */
    uri_text = gnome_vfs_ext_get_uri(tc->title_image);
    uri = gnome_vfs_uri_new(uri_text);
    if (!gnome_vfs_uri_exists(uri)) {
      g_printerr("%s '%s'.\n",
		 _("Could not find file"), uri_text);
      gnome_vfs_uri_unref(uri);
      g_free(uri_text);
      exit (1);
    }
    gnome_vfs_uri_unref(uri);
    
    /*  */
    image = teoeyes_image_new(uri_text, GNOME_VFS_FILE_LOCAL);
    if (!image) exit(1);
    image_list = g_list_append(image_list, image);
  }
  return image_list;
}

/* ************************************************************************* *
 * ץβϥ롼
 * ************************************************************************* */
	
/* -gץΰϴؿ () ************************************* */
static void
parse_geometry_size (gchar		*option,
		     WindowGeometry	**geometry) {
  gchar	buf[64];
  gchar	*ptr;

  /*  */
  ptr = buf;
  while (isdigit (*option)) *ptr++ = *option++;
  *ptr = '\0';
  (*geometry)->width = atoi (buf);

  /* x */
  if (*option++ != 'x') {
    (*geometry)->height = UNDEF_VAL;
    return;
  }
  /* ⤵ */
  ptr = buf;
  while (isdigit (*option)) *ptr++ = *option++;
  *ptr = '\0';
  (*geometry)->height = atoi (buf);
}

/* -gץΰϴؿ () *************************************** */
static void
parse_geometry_position (gchar		*option,
			 WindowGeometry	**geometry) {
  gchar	buf[64];
  gchar	*ptr;

  /* X */
  if (*option != '+' && *option != '-') {
    (*geometry)->x = UNDEF_VAL;
    (*geometry)->y = UNDEF_VAL;
    return;
  }
  (*geometry)->xsign = (*option++ == '+') ? 1 : -1;

  /* X */
  if (!isdigit (*option)) {
    (*geometry)->x = UNDEF_VAL;
    (*geometry)->y = UNDEF_VAL;
    return;
  }
  ptr = buf;
  while (isdigit (*option)) *ptr++ = *option++;
  *ptr = '\0';
  (*geometry)->x = atoi (buf);

  /* Y */
  if (*option != '+' && *option != '-') {
    (*geometry)->x = UNDEF_VAL;
    (*geometry)->y = UNDEF_VAL;
    return;
  }
  (*geometry)->ysign = (*option++ == '+') ? 1 : -1;
  
  /* Y */
  if (!isdigit (*option)) {
    (*geometry)->x = UNDEF_VAL;
    (*geometry)->y = UNDEF_VAL;
    return;
  }
  ptr = buf;
  while (isdigit (*option)) *ptr++ = *option++;
  *ptr = '\0';
  (*geometry)->y = atoi (buf);
}

/* -gץΰϴؿ ********************************************** */
static WindowGeometry*
parse_geometry (gchar	*option) {
  WindowGeometry	*geometry = NULL;
  gchar			*tmp;

  tmp = option;
  if (*tmp == '+' || *tmp == '-') tmp++;
  /* ץλְ꤬äƤ饪ץ̵ˤ */
  if (!isdigit (*tmp)) return NULL;
  
  /* ץβ */
  while (tmp && isdigit (*tmp)) tmp++;

  if (*tmp == 'x') {
    geometry = g_new (WindowGeometry, 1);
    parse_geometry_size (option, &geometry);
    while (option && !isalpha (*option)) option++;
    if (!option || *option != 'x') {
      geometry->x = UNDEF_VAL;
      geometry->y = UNDEF_VAL;
    } else {
      option++;
      while (option && isdigit (*option)) option++;
      if (*option == '+' || *option == '-') {
	parse_geometry_position (option, &geometry);
      } else {
	geometry->x = UNDEF_VAL;
	geometry->y = UNDEF_VAL;
      }
    }
  } else if (*tmp == '+' || *tmp == '-') {
    geometry = g_new (WindowGeometry, 1);
    parse_geometry_position (option, &geometry);
    geometry->width  = UNDEF_VAL;
    geometry->height = UNDEF_VAL;
  }
  return geometry;
}

/* -sץβϴؿ ************************************************** */
static void
parse_sequence_file (GList	**list,
		     gchar	*filename,
		     gint	start,
		     gint	end,
		     gint	step) {
  TEImage	*tmpimg;
  gchar		*uri_text, name[1024];
  gint		n;

  for (n = start; n <= end; n+= step) {
    /* ե̾ */
    sprintf (name, filename, n);
    uri_text = gnome_vfs_ext_get_uri(name);
    
    /*  */
    tmpimg = teoeyes_image_new(uri_text,
			       gnome_vfs_ext_get_location(uri_text));
    *list =  g_list_append (*list, (gpointer) tmpimg);
    g_free(uri_text);
  }
}

/* ************************************************* End of parse_args.c *** */
