/* ****************************************************** pixel_window.c *** *
 * ɽؿ
 *
 * Copyright (C) 1998-2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <05/04/17 02:38:04 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "teoeyes.h"
#include "pixel_window.h"
#include <teo.h>

/* ꤷβͤɽ ******************************************** */
void
pixel_window_show (GList		*list,
		   gint			x,
		   gint			y,
		   PixelInfoType	ptype,
		   Display		*dsp,
		   guint32		time) {
  GtkWidget	*entry;
  gchar		info[256];  
  gchar		*buffer;
  gint		wx, wy, w, h, d, n, nchannels;
  gdouble	pixel[3];

  /* ͤγ */
  for (n = 0; n < 3; n++) pixel[n] = 0;
  nchannels = (ti_get_nchannels(list) >= 3) ? 3 : ti_get_nchannels(list);
  if (ptype == PIXEL_INFO_TYPE_CURRENT || !ti_get_original_list(list)) {
    for (n = 0; n < nchannels; n++) {
      pixel[n] = (gdouble) ti_get_pixel (list, x, y, n);
    }
  } else {
    for (n = 0; n < nchannels; n++) {
      pixel[n] = (gdouble) ti_get_pixel_from_original(list, x, y, n);
    }    
  }
  /* ɽѤΥ٥ */
  if (ptype == PIXEL_INFO_TYPE_CURRENT || !ti_get_original_list(list) ||
      ((ti_get_original_list(image_list)) &&
       ti_get_type(list) != TI_PIXEL_FLOAT)) {
    sprintf (info, "(%4d, %4d) %ld : %ld : %ld", 
	     x + ti_get_xoffset(list), y + ti_get_yoffset(list),
	     (glong) pixel[0], (glong) pixel[1], (glong) pixel[2]);
  } else {
    sprintf (info, "(%4d, %4d) %.8e : %.8e : %.8e",
	     x + ti_get_xoffset(list), y + ti_get_yoffset(list),
	     pixel[0], pixel[1], pixel[2]);
  }
  /* ͤɽ */
  entry = G_GET_WIDGET (pixel_window, "label");
  gtk_entry_set_text (GTK_ENTRY (entry), info);

  /* åץܡɤؤϿ */
  buffer = g_strconcat (info, "\n", NULL);
  gtk_clipboard_set_text (gtk_widget_get_clipboard (GTK_WIDGET (entry),
						    GDK_SELECTION_PRIMARY),
			  buffer, -1);
  g_free (buffer);

  gdk_window_get_geometry     (image_window->window, &wx, &wy, &w, &h, &d);
  gdk_window_get_origin       (image_window->window, &wx, &wy);
  gtk_widget_set_size_request (pixel_window, strlen (info) * 8, 20);
  gtk_widget_set_uposition    (pixel_window, wx, wy + h + 7);
}

/* ɽɥɽ ******************************************** */
void
pixel_window_hide (GtkWidget		*widget,
		   GdkEventButton	*ev,
		   gpointer		data) {
  /*ޥαܥǥɥ򱣤 */
  if (ev->button == MOUSE_BUTTON_RIGHT) gtk_widget_hide (widget);
}

/* ɽɥ ********************************************** */
GtkWidget*
pixel_window_new (void) {
  GtkWidget	*window;
  GtkWidget	*label;

  /* ɽɥ */
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_events (window, GDK_BUTTON_PRESS_MASK);
  g_signal_connect (G_OBJECT (window), "button_press_event",
		    G_CALLBACK (pixel_window_hide), NULL);
  gtk_widget_realize (window);
  gdk_window_set_decorations (window->window, FALSE);

  /* ܡ2ԥ  */
  gtk_container_set_border_width (GTK_CONTAINER (window), 2);

  /* ɽѥȥ */
  label= gtk_entry_new ();
  G_SET_OBJECT (window, "label", label);
  gtk_entry_set_editable (GTK_ENTRY (label), FALSE);
  gtk_container_add (GTK_CONTAINER (window), label);

  return window;
}

/* *********************************************** End of pixel_window.c *** */
