/* ************************************************************ plugin.c *** *
 * ץ饰˴ؤؿ
 *
 * Copyright (C) 2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/05/24 05:20:53 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dlfcn.h>
#include <gtk/gtk.h>
#include <libgnomevfs/gnome-vfs.h>
#include "teoeyes.h"
#include "teoeyes_plugin.h"
#include "gnome-vfs-extension.h"
#include "operation.h"

/* ץ饰ν ******************************************************* */
GList*
teoeyes_plugin_init (GSList	*name_list) {
  GList			*plugin_list = NULL;
  GSList		*list;
  gchar			*plugin_name;
  void			*handle;
  
  for (list = name_list; list; list = g_slist_next(list)) {
    plugin_name = (gchar *) list->data;
    handle = dlopen(plugin_name, RTLD_LAZY);
    plugin_list = g_list_append(plugin_list, handle);
  }
  return plugin_list;
}

/* ************************************************************************* */
void
plugin_callback (GtkWidget	*widget,
		 gpointer	data) {
  TeoeyesPluginInfo	*pinfo;
  GdkPixbuf		*work, *dest;

  pinfo = dlsym(g_list_nth_data(plugin_list, (gint) data), "plugin_info");
  
  /* Хåå */
  do_backup (image_list);
  
  work = gdk_pixbuf_copy(ti_get_pixbuf(image_list));
  dest = gdk_pixbuf_copy(ti_get_pixbuf(image_list));
  pinfo->plugin_func (work, dest, NULL);

  gdk_pixbuf_copy_area (dest,
			0, 0,
			gdk_pixbuf_get_width (dest),
			gdk_pixbuf_get_height(dest),
			ti_get_pixbuf(image_list),
			0, 0);
  
  if (ti_get_pixmap_list(image_list)) modify_pixmap(image_list);
  draw_image (image_list, ti_get_width(image_list), ti_get_height(image_list));
}

/* ***************************************************** End of plugin.c *** */
