/* ********************************************************* property.c **** *
 * ե˴ؤؿ
 *
 * Copyright (C) 2004-2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <05/05/24 05:15:17 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "teoeyes.h"
#include <gconf/gconf-client.h>
#include "teoeyes_property_default.h"

/* ͤ񤭹ؿ ************************************************ */
void
config_save_first (GConfClient	*client) {
  gchar		*app_path, *path;
  gchar		buf[1024];
  GSList	*list = NULL;
  int		n;
  
  /* ƥΥǡǥ쥯ȥؤΥѥ */
  app_path = g_build_filename(PACKAGE_DATA_DIR, PACKAGE, NULL);

  /* ͤ񤭹 */
  {
    /* С */
    gconf_client_set_string(client, prop_key_version, VERSION, NULL);

    /* ǥեȥץǧ */
    for (n = 0; n < 3; n++) {
      gconf_client_set_bool(client,
			    prop_key_option[n], prop_default_option[n], NULL);
    }
    for (n = 0; n < 2; n++) {
      gconf_client_set_bool(client,
			    prop_key_confirm[n], prop_default_confirm[n],NULL);
    }
    /* ͥ */
    sprintf(buf, prop_default_thumbnail_folder, g_get_home_dir());
    gconf_client_set_string(client, prop_key_thumbnail[0], buf, NULL);
    gconf_client_set_int(client,
			 prop_key_thumbnail[1], prop_default_thumbnail_width,
			 NULL);
    gconf_client_set_int(client,
			 prop_key_thumbnail[2], prop_default_thumbnail_height,
			 NULL);

    /* 롼ڥ */
    gconf_client_set_int(client,
			 prop_key_loope_size, prop_default_loope_size, NULL);

    /* ˡ */
    gconf_client_set_int(client,
			 prop_key_loader_select, prop_default_loader_selection,
			 NULL);

    /* ե */
    path = g_strdup_printf(prop_default_loader_folder, PACKAGE_DATA_DIR);
    for (n = 0;
	 n < sizeof(prop_default_loader)/sizeof(prop_default_loader[0]); n++) {
      list = g_slist_append(list,
			    (gpointer) g_strdup_printf(prop_default_loader[n],
						       path));
    }
    gconf_client_set_list(client,
			  prop_key_loader, GCONF_VALUE_STRING, list,
			  NULL);
    g_slist_foreach(list, (GFunc) g_free, NULL);
    g_free(path);
    list = NULL;

    /* ȥ */
    sprintf(buf, prop_default_assistant_skin, app_path);
    gconf_client_set_string(client, prop_key_assistant_skin, buf, NULL);

    /* ȥɥȥե */
    sprintf(buf, prop_default_doc_folder, app_path);
    list = g_slist_append(list, (gpointer) g_strdup(buf));
    gconf_client_set_list(client,
			  prop_key_doc_folder, GCONF_VALUE_STRING, list, NULL);
    g_slist_foreach(list, (GFunc) g_free, NULL);
    list = NULL;

    /* ץ饰ե */
    path = g_strdup_printf(prop_default_plugin_folder, PACKAGE_DATA_DIR);
    for (n = 0;
	 n < sizeof(prop_default_plugin)/sizeof(prop_default_plugin[0]); n++) {
      list = g_slist_append(list,
			    (gpointer) g_strdup_printf(prop_default_plugin[n],
						       path));
    }
    gconf_client_set_list(client,
			  prop_key_plugin, GCONF_VALUE_STRING, list,
			  NULL);
    g_slist_foreach(list, (GFunc) g_free, NULL);
    g_free(path);
    list = NULL;

    /* ȥ */
    sprintf(buf, prop_default_title_image, app_path);
    gconf_client_set_string(client, prop_key_title_image, buf, NULL);

    /* ץ졼䥹 */
    sprintf(buf, prop_default_player_skin, app_path);  
    gconf_client_set_string(client, prop_key_player_skin, buf, NULL);

    /* ե */
    sprintf(buf, prop_default_icon_folder, app_path);  
    gconf_client_set_string(client, prop_key_icon_folder, buf, NULL);
    
    /* Хɤ */
    for (n = 0;
	 n < sizeof(prop_key_keybind) / sizeof(prop_key_keybind[0]); n++) {
      gconf_client_set_string(client,
			      prop_key_keybind[n], prop_default_keybind[n],
			      NULL);
    }
  }
  g_free(app_path);  
}

/* ͤ񤭹ؿ **************************************************** */
void
config_save (GConfClient	*client) {
  GSList	*list = NULL;
  gint		n;
  
  /* ͤ񤭹 */
  {
    /* С */
    gconf_client_set_string(client, prop_key_version, VERSION, NULL);

    /* ǥեȥץǧ */
    gconf_client_set_bool(client,
			  prop_key_option[0], tc->option_load_all, NULL);
    gconf_client_set_bool(client,
			  prop_key_option[1], tc->option_normalize, NULL);
    gconf_client_set_bool(client,
			  prop_key_option[2], tc->option_create_pixmap, NULL);

    /* ǧ */
    gconf_client_set_bool(client,
			  prop_key_confirm[0], tc->confirm_save, NULL);
    gconf_client_set_bool(client,
			  prop_key_confirm[1], tc->confirm_overwrite, NULL);

    /* ͥ */
    gconf_client_set_string(client,
			    prop_key_thumbnail[0], tc->thumbnail_folder, NULL);
    gconf_client_set_int(client,
			 prop_key_thumbnail[1], tc->thumbnail_width, NULL);
    gconf_client_set_int(client,
			 prop_key_thumbnail[2], tc->thumbnail_height, NULL);

    /* 롼ڥ */    
    gconf_client_set_int(client, prop_key_loope_size, tc->loope_size, NULL);

    /* ˡ */
    gconf_client_set_int(client,
			 prop_key_loader_select, tc->loader_selection, NULL);
    
    /* ꥹȤ */    
    gconf_client_set_list(client,
			  prop_key_loader, GCONF_VALUE_STRING,
			  tc->loader_list, NULL);

    /* ȥ */
    gconf_client_set_string(client,
			    prop_key_assistant_skin, tc->assistant_skin, NULL);

    /* ȥɥȥե */    
    gconf_client_set_list(client,
			  prop_key_doc_folder, GCONF_VALUE_STRING,
			  tc->assistant_doc_folders, NULL);

    /* ץ饰ꥹȤ */    
    gconf_client_set_list(client,
			  prop_key_plugin, GCONF_VALUE_STRING,
			  tc->plugin_list, NULL);

    /* ȥ */    
    gconf_client_set_string(client,
			    prop_key_title_image, tc->title_image, NULL);

    /* ץ졼䥹 */    
    gconf_client_set_string(client,
			    prop_key_player_skin, tc->player_skin, NULL);

    /* ե */    
    gconf_client_set_string(client,
			    prop_key_icon_folder, tc->icon_folder, NULL);

    /* Хɤ */
    for (n = 0, list = tc->shortcut;
	 n < sizeof(prop_key_keybind) / sizeof(prop_key_keybind[0]); n++) {
      gconf_client_set_string(client, prop_key_keybind[n],
			      (gchar *) list->data, NULL);
      list = g_slist_next(list);
    }
  }
}

/* ɤ߹ ********************************************************** */
TEConfig*
config_load (GConfClient	*client) {
  TEConfig	*config;
  GSList	*list, *work_list;
  int		n;
  
  /* ƥ깽¤Τ */
  config = g_new0(TEConfig, 1);

  /* ͥ¸ */  
  config->thumbnail_folder =
    gconf_client_get_string(client, prop_key_thumbnail[0], NULL);

  /* ȥ */  
  config->assistant_skin =
    gconf_client_get_string(client, prop_key_assistant_skin, NULL);

  /* ȥ */
  config->title_image =
    gconf_client_get_string(client, prop_key_title_image, NULL);

  /* ץ졼䥹 */  
  config->player_skin =
    gconf_client_get_string(client, prop_key_player_skin, NULL);

  /* ե */  
  config->icon_folder =
    gconf_client_get_string(client, prop_key_icon_folder, NULL);
  
  /* ǥեȥץ */  
  config->option_load_all = 
    gconf_client_get_bool(client, prop_key_option[0], NULL);

  config->option_normalize =
    gconf_client_get_bool(client, prop_key_option[1], NULL);

  config->option_create_pixmap =
    gconf_client_get_bool(client, prop_key_option[2], NULL);
  
  /* ǧܤ */  
  config->confirm_save =
    gconf_client_get_bool(client, prop_key_confirm[0], NULL);

  config->confirm_overwrite =
    gconf_client_get_bool(client, prop_key_confirm[1], NULL);

  /* ͥ礭 */
  config->thumbnail_width = 
    gconf_client_get_int(client, prop_key_thumbnail[1], NULL);
  
  config->thumbnail_height = 
    gconf_client_get_int(client, prop_key_thumbnail[2], NULL);

  /* 롼ڥ */  
  config->loope_size = 
    gconf_client_get_int(client, prop_key_loope_size, NULL);

  /* ˡ */  
  config->loader_selection =
    gconf_client_get_int(client, prop_key_loader_select, NULL);

  /* 롼ڥ */  
  config->loader_selection = 
    gconf_client_get_int(client, prop_key_loader_select, NULL);

  /* ꥹȤ */  
  work_list =
    gconf_client_get_list(client,
			  prop_key_loader, GCONF_VALUE_STRING, NULL);
  for (list = work_list; list; list = g_slist_next(list)) {
    if (g_file_test((gchar *) list->data, G_FILE_TEST_EXISTS)) {
      config->loader_list = g_slist_append(config->loader_list,
					   g_strdup(list->data));
    }
  }
  g_slist_foreach(work_list, (GFunc) g_free, NULL);
  g_slist_free(work_list);

  /* ȥɥȥե */  
  config->assistant_doc_folders =
    gconf_client_get_list(client,
			  prop_key_doc_folder, GCONF_VALUE_STRING, NULL);

  /* ץ饰ꥹȤ */
  work_list =
    gconf_client_get_list(client,
			  prop_key_plugin, GCONF_VALUE_STRING, NULL);
  for (list = work_list; list; list = g_slist_next(list)) {
    if (g_file_test((gchar *) list->data, G_FILE_TEST_EXISTS)) {
      config->plugin_list = g_slist_append(config->plugin_list,
					   g_strdup(list->data));
    }
  }
  g_slist_foreach(work_list, (GFunc) g_free, NULL);
  g_slist_free(work_list);

  /* Хɤ */
  for (n = 0, config->shortcut = NULL;
       n < sizeof (prop_key_keybind) / sizeof (prop_key_keybind[0]); n++) {
    config->shortcut =
      g_slist_append(config->shortcut,
		     gconf_client_get_string(client,
					     prop_key_keybind[n], NULL));
  }
  return config;
}

/* ܹ¤Τΰ ************************************************ */
void
config_free (TEConfig	*config) {
  if (config) {
    if (config->thumbnail_folder) g_free(config->thumbnail_folder);
    if (config->assistant_skin)   g_free(config->assistant_skin);
    if (config->title_image)      g_free(config->title_image);
    if (config->player_skin)      g_free(config->player_skin);
    if (config->icon_folder)      g_free(config->icon_folder);    
    if (config->loader_list) {
      g_slist_foreach(config->loader_list, (GFunc) g_free, NULL);
    }
    if (config->assistant_doc_folders) {
      g_slist_foreach(config->assistant_doc_folders, (GFunc) g_free, NULL);
    }
    if (config->plugin_list) {
      g_slist_foreach(config->plugin_list, (GFunc) g_free, NULL);
    }
    if (config->shortcut) {
      g_slist_foreach(config->shortcut, (GFunc) g_free, NULL);
    }
    g_free (config);
  }
}

/* *************************************************** End of property.c *** */
