/* *************************************************** teoeyes_browser.c *** *
 * ֥饦
 *
 * Copyright (C) 2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/05/03 01:38:57 sugaya>
 * ************************************************************************* */
#ifndef __TEOEYES_BROWSER__
#define __TEOEYES_BROWSER__

#include <gtk/gtk.h>
#include <gnome.h>
#include "gtkdirtreeview.h"
#include "glib-fileutil-extension.h"

#define GTK_TYPE_TEOEYES_BROWSER (teoeyes_browser_get_type())
#define TEOEYES_BROWSER(obj) (GTK_CHECK_CAST((obj), GTK_TYPE_TEOEYES_BROWSER, TeoeyesBrowser))
#define TEOEYES_BROWSER_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass), GTK_TYPE_TEOEYES_BROWSER, TeoeyesBrowserClass))
#define GTK_IS_TEOEYES_BROWSER(obj) (GTK_CHECK_TYPE((obj), GTK_TYPE_TEOEYES_BROWSER))
#define GTK_IS_TEOEYES_BROWSER_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GTK_TYPE_TEOEYES_BROWSER))
#define GTK_TEOEYES_BROWSER_GET_CLASS(obj) (GTK_CHECK_GET_CLASS((obj), GTK_TYPE_TEOEYES_BROWSER, TeoeyesBrowserClass))

typedef struct _TeoeyesBrowser		TeoeyesBrowser;
typedef struct _TeoeyesBrowserClass	TeoeyesBrowserClass;

struct _TeoeyesBrowser {
  GtkWindow	window;
  GtkWidget	*folder_combo;
  GtkWidget	*folder_entry;
  GtkWidget	*folder_tree;
  GtkWidget	*icon_window;
  GtkWidget	*file_window;
  GtkWidget	*iconview;
  GtkWidget	*fileview;
  GtkWidget	*progressbar;
  GtkWidget	*state_label;
  GList		*combolist;
  gchar		*folder;
  gchar		*icon_folder;
  gint		icon_width;
  gint		icon_height;
  gint		sort_type;
  gint		mode;
};

struct _TeoeyesBrowserClass {
  GtkWindowClass	parent_class;
};

GtkType    teoeyes_browser_get_type	(void);
GtkWidget* teoeyes_browser_new		(const gchar	*stock_folder,
					 const gchar	*icon_folder,
					 gint		icon_width,
					 gint		icon_height);
void       teoeyes_browser_scan_folder 	(TeoeyesBrowser	*browser,
					 const gchar	*folder);

#endif /* __TEOEYES_BROWSER__ */

/* ******************************************** End of teoeyes_browser.c *** */
