/* ****************************************************** teoeyes_menu.c *** *
 * ˥塼˴ؤؿ إåե
 *
 * Copyright (C) 2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <05/07/05 20:03:24 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <gtk/gtk.h>
#include <string.h>
#include "teoeyes.h"
#include "gettext.h"
#include "teoeyes_menu.h"

/* ************************************************************************* */
static GtkWidget* teoeyes_menu_item_new		(TeoeyesUIInfo	ui,
						 GtkAccelGroup	*accel,
						 GtkTooltips	*tips);
static GtkWidget* teoeyes_toggle_menu_item_new 	(TeoeyesUIInfo	ui,
						 GtkAccelGroup	*accel,
						 GtkTooltips	*tips);
static void	  teoeyes_submenu_item_new 	(GtkWidget	*submenu,
						 GtkAccelGroup	*accel,
						 GtkTooltips	*tips,
						 TeoeyesUIInfo	*ui);
static GtkWidget* teoeyes_submenu_new 		(TeoeyesUIInfo	ui,
						 GtkAccelGroup	*accel,
						 GtkTooltips	*tips);

/* ˥塼ƥκ ************************************************** */
static GtkWidget*
teoeyes_menu_item_new (TeoeyesUIInfo	ui,
		       GtkAccelGroup	*accel,
		       GtkTooltips	*tips) {
  GtkWidget	*menuitem;
  GtkWidget	*image;
  gchar		*accel_label;
  
  /* ˥塼ƥ */
  menuitem = gtk_image_menu_item_new_with_mnemonic(L_(ui.label));

  /* ˥塼 */
  switch (ui.pixmap_type) {
  case TEOEYES_PIXMAP_STOCK:
    image = gtk_image_new_from_stock((gchar *) ui.pixmap_info,
				     GTK_ICON_SIZE_MENU);
    gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
    break;
  case TEOEYES_PIXMAP_DATA: /* not implemented */
    break;
  case TEOEYES_PIXMAP_FILENAME:
    image = gtk_image_new_from_file((gchar *) ui.pixmap_info);
    gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
    break;
  case TEOEYES_PIXMAP_NONE:
  default:
    break;
  }
  /* ҥȤ */
  if (ui.hint) gtk_tooltips_set_tip (tips, menuitem, ui.hint, NULL);

  /* 졼 */
  if (ui.unused_data) {
    accel_label = (gchar *) g_slist_nth_data(tc->shortcut,
					     ((gint) ui.unused_data - 1));
    gtk_accelerator_parse(accel_label, &ui.accelerator_key, &ui.ac_mods);
  }
  if (ui.accelerator_key != 0 && accel) {
    gtk_widget_add_accelerator (menuitem, "activate", accel,
				ui.accelerator_key, ui.ac_mods,
				GTK_ACCEL_VISIBLE);
  }
  /* Хåؿ */
  if (ui.moreinfo && ui.type != TEOEYES_UI_SUBTREE) {
    g_signal_connect ((gpointer) menuitem,
		      "activate", G_CALLBACK (ui.moreinfo), ui.user_data);
  }
  return menuitem;
}

/* å˥塼ƥκ ****************************************** */
static GtkWidget*
teoeyes_toggle_menu_item_new (TeoeyesUIInfo	ui,
			      GtkAccelGroup	*accel,
			      GtkTooltips	*tips) {
  GtkWidget	*menuitem;
  gchar		*accel_label;
  
  /* ˥塼ƥ */
  menuitem = gtk_check_menu_item_new_with_mnemonic(L_(ui.label));

  /* ҥȤ */
  if (ui.hint) gtk_tooltips_set_tip (tips, menuitem, ui.hint, NULL);

  /* 졼 */
  if (ui.unused_data) {
    accel_label = (gchar *) g_slist_nth_data(tc->shortcut,
					     ((gint) ui.unused_data - 1));
    gtk_accelerator_parse(accel_label, &ui.accelerator_key, &ui.ac_mods);
  }
  if (ui.accelerator_key != 0 && accel) {
    gtk_widget_add_accelerator (menuitem, "activate", accel,
				ui.accelerator_key, ui.ac_mods,
				GTK_ACCEL_VISIBLE);
  }
  /* ɸ֤ */
  gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (menuitem), FALSE);

  /* Хåؿ */
  if (ui.moreinfo && ui.type != TEOEYES_UI_SUBTREE) {  
    g_signal_connect ((gpointer) menuitem,
		      "activate", G_CALLBACK (ui.moreinfo), ui.user_data);
  }
  return menuitem;
}

/* ֥˥塼ƥκ ********************************************** */
static void
teoeyes_submenu_item_new (GtkWidget	*submenu,
			  GtkAccelGroup	*accel,
			  GtkTooltips	*tips,
			  TeoeyesUIInfo	*ui) {
  GtkWidget	*menuitem;
  int		n;

  for (n = 0; ui[n].type != TEOEYES_UI_ENDOFINFO; n++) {
    switch (ui[n].type) {
    case TEOEYES_UI_ITEM:
      menuitem = teoeyes_menu_item_new(ui[n], accel, tips);
      gtk_container_add(GTK_CONTAINER(submenu), menuitem);
      break;
    case TEOEYES_UI_TOGGLEITEM:
      menuitem = teoeyes_toggle_menu_item_new(ui[n], accel, tips);
      gtk_container_add(GTK_CONTAINER(submenu), menuitem);
      break;
    case TEOEYES_UI_SUBTREE:
      menuitem = teoeyes_submenu_new(ui[n], accel, tips);
      gtk_container_add(GTK_CONTAINER(submenu), menuitem);
      break;
    case TEOEYES_UI_SEPARATOR:
      menuitem = gtk_menu_item_new();
      gtk_widget_set_sensitive (menuitem, FALSE);
      gtk_container_add(GTK_CONTAINER(submenu), menuitem);      
      break;
    case TEOEYES_UI_TEAROFF:
      menuitem = gtk_tearoff_menu_item_new();
      gtk_container_add(GTK_CONTAINER(submenu), menuitem);      
      break;
    default:
      break;
    }
  }
}

/* ֥˥塼ƥκ ********************************************** */
static GtkWidget*
teoeyes_submenu_new (TeoeyesUIInfo	ui,
		     GtkAccelGroup	*accel,
		     GtkTooltips	*tips) {
  GtkWidget	*menuitem;
  GtkWidget	*subitem;
  
  menuitem = teoeyes_menu_item_new(ui, accel, tips);
  subitem  = gtk_menu_new();
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuitem), subitem);
  if (ui.moreinfo) {
    teoeyes_submenu_item_new(subitem, accel, tips,
			     (TeoeyesUIInfo *) ui.moreinfo);
  }
  return menuitem;
}
  
/* ˥塼κ ********************************************************** */
void
teoeyes_fill_menu (GtkMenuShell		*menu,
		   GtkAccelGroup	*accel,
		   TeoeyesUIInfo	*ui) {
  GtkWidget	*menuitem;
  GtkTooltips	*tips;
  int		n;

  /* ġåץ */
  tips = gtk_tooltips_new();
  
  for (n = 0; ui[n].type != TEOEYES_UI_ENDOFINFO; n++) {
    switch (ui[n].type) {
    case TEOEYES_UI_ITEM:
      menuitem = teoeyes_menu_item_new(ui[n], accel, tips);
      gtk_container_add(GTK_CONTAINER(menu), menuitem);
      break;
    case TEOEYES_UI_TOGGLEITEM:
      menuitem = teoeyes_toggle_menu_item_new(ui[n], accel, tips);
      gtk_container_add(GTK_CONTAINER(menu), menuitem);
      break;
    case TEOEYES_UI_SUBTREE:
      menuitem = teoeyes_submenu_new(ui[n], accel, tips);
      gtk_container_add(GTK_CONTAINER(menu), menuitem);
      break;
    case TEOEYES_UI_SEPARATOR:
      menuitem = gtk_menu_item_new();
      gtk_widget_set_sensitive (menuitem, FALSE);
      gtk_container_add(GTK_CONTAINER(menu), menuitem);      
      break;
    case TEOEYES_UI_TEAROFF:
      menuitem = gtk_tearoff_menu_item_new();
      gtk_container_add(GTK_CONTAINER(menu), menuitem);      
      break;
    default:
      break;
    }
  }
}

/* *********************************************** End of teoeyes_menu.c *** */
