#include <cv.h>
#include "teo2ipl.h"
IplImage *cvCloneTEO(TEOIMAGE *image){
  CvSize size;
  IplImage *output;
  int depth;
  size.width = TeoWidth(image);
  size.height = TeoHeight(image);
  if(TeoIsBIT(image))
    depth = IPL_DEPTH_1U;
  else if(TeoIsUINT8(image))
    depth = IPL_DEPTH_8U;
  else if(TeoIsSINT8(image))
    depth = IPL_DEPTH_8S;
  else if(TeoIsUINT16(image))
    depth = IPL_DEPTH_16U;
  else if(TeoIsSINT16(image))
    depth = IPL_DEPTH_16S;
  else if(TeoIsSINT32(image))
    depth = IPL_DEPTH_32S;
  else if(TeoIsFLOAT32(image))
    depth = IPL_DEPTH_32F;
  output = cvCreateImage(size, depth, TeoPlane(image));
  cvCopyTEOImage(output,image);
  return output;
}
TEOIMAGE *TeoCloneIPL(IplImage *image){
  TEOIMAGE *output;
  switch(image->depth){
  case IPL_DEPTH_1U:
    output = TeoAllocImage(image->width,image->height,0,0,TEO_UNSIGNED,1,image->nChannels);
    break;
  case IPL_DEPTH_8U:
    output = TeoAllocImage(image->width,image->height,0,0,TEO_UNSIGNED,8,image->nChannels);
    break;
  case IPL_DEPTH_8S:
    output = TeoAllocImage(image->width,image->height,0,0,TEO_SIGNED,8,image->nChannels);
    break;
  case IPL_DEPTH_16U:
    output = TeoAllocImage(image->width,image->height,0,0,TEO_UNSIGNED,16,image->nChannels);
    break;
  case IPL_DEPTH_16S:
    output = TeoAllocImage(image->width,image->height,0,0,TEO_SIGNED,16,image->nChannels);
    break;
  case IPL_DEPTH_32S:
    output = TeoAllocImage(image->width,image->height,0,0,TEO_SIGNED,32,image->nChannels);
    break;
  case IPL_DEPTH_32F:
    output = TeoAllocImage(image->width,image->height,0,0,TEO_FLOAT,32,image->nChannels);
    break;
  }
  TeoCopyIPLImage(output,image);
  return output;
}
IplImage *cvWrapTEO(TEOIMAGE *image){
  CvSize size;
  IplImage *output;
  int depth;
  size.width = TeoWidth(image);
  size.height = TeoHeight(image);
  if(TeoIsBIT(image))
    depth = IPL_DEPTH_1U;
  else if(TeoIsUINT8(image))
    depth = IPL_DEPTH_8U;
  else if(TeoIsSINT8(image))
    depth = IPL_DEPTH_8S;
  else if(TeoIsUINT16(image))
    depth = IPL_DEPTH_16U;
  else if(TeoIsSINT16(image))
    depth = IPL_DEPTH_16S;
  else if(TeoIsSINT32(image))
    depth = IPL_DEPTH_32S;
  else if(TeoIsFLOAT32(image))
    depth = IPL_DEPTH_32F;
  output = cvCreateImageHeader(size, depth, TeoPlane(image));
  output->imageData = TeoData(image);
  return output;
}
TEOIMAGE *TeoWrapIPL(IplImage *image){
  TEOIMAGE *output;
  switch(image->depth){
  case IPL_DEPTH_1U:
    output = TeoAllocImage(image->width,image->height,0,0,TEO_UNSIGNED,1,image->nChannels);
    break;
  case IPL_DEPTH_8U:
    output = TeoAllocImage(image->width,image->height,0,0,TEO_UNSIGNED,8,image->nChannels);
    break;
  case IPL_DEPTH_8S:
    output = TeoAllocImage(image->width,image->height,0,0,TEO_SIGNED,8,image->nChannels);
    break;
  case IPL_DEPTH_16U:
    output = TeoAllocImage(image->width,image->height,0,0,TEO_UNSIGNED,16,image->nChannels);
    break;
  case IPL_DEPTH_16S:
    output = TeoAllocImage(image->width,image->height,0,0,TEO_SIGNED,16,image->nChannels);
    break;
  case IPL_DEPTH_32S:
    output = TeoAllocImage(image->width,image->height,0,0,TEO_SIGNED,32,image->nChannels);
    break;
  case IPL_DEPTH_32F:
    output = TeoAllocImage(image->width,image->height,0,0,TEO_FLOAT,32,image->nChannels);
    break;
  }
  free(TeoData(output));
  TeoData(output) = image->imageData;
  return output;
}
void cvCopyTEOImage(IplImage *dest,TEOIMAGE *src){
  int y;
  int teostep = TeoWidth(src)*TeoPlane(src)*(TeoBit(src)/8);
  if(dest->widthStep==teostep){
    memcpy(dest->imageData,TeoData(src),TeoFsize(src));
  }else{
    for(y=0;y<TeoHeight(src);y++)
      memcpy(dest->imageData+dest->widthStep*y,
	     (unsigned char*)(TeoData(src))+teostep*y,
	     teostep);
  }
}
void TeoCopyIPLImage(TEOIMAGE *dest,IplImage *src){
  int y;
  int teostep = TeoWidth(dest)*TeoPlane(dest)*(TeoBit(dest)/8);
  if(src->widthStep==teostep){
    memcpy(TeoData(dest),src->imageData,TeoFsize(dest));
  }else{
    for(y=0;y<TeoHeight(dest);y++)
      memcpy((unsigned char*)(TeoData(dest))+teostep*y,
	     src->imageData+src->widthStep*y,
	     teostep);
  }
}
