/* **************************************************** gdk-pixbuf2teo.h *** *
 * teogdk-pixbuf֤Ѵ饤֥
 * gdk-pixbufteoؤѴؿ
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA, <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-10-30 22:56:36 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include <teo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "intl.h"

/* GdkPixbufTEOIMAGE ***************************************** */
TEOIMAGE*
teo2gdk_pixbuf_convert_to_teoimage (GdkPixbuf	*pix,
				    int		has_alpha) {
  GdkPixbuf	*back = NULL;
  TEOIMAGE	*img  = NULL;
  unsigned char	*src_ptr, *dst_ptr;
  int		n, w, h, p;

  w = gdk_pixbuf_get_width  (pix);
  h = gdk_pixbuf_get_height (pix);

  /* ץ졼η */
  if (gdk_pixbuf_get_has_alpha (pix) && has_alpha) {
    p = 4;
  } else {
    p = 3;
  }
  /* ΰ */
  img = TeoAllocImage (w, h, 0, 0, TEO_UNSIGNED, 8, p);
  if (!img) {
    fprintf (stderr, _("Can not allocate enough memory.\n"));
    return NULL;
  }
  /* ץ졼 */
  if (gdk_pixbuf_get_has_alpha (pix) && !has_alpha) {
    back = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, w, h);
    gdk_pixbuf_composite_color (pix, back,
				0, 0, w, h, 0, 0, 1.0, 1.0,
				GDK_INTERP_TILES,
				255,
				0, 0,
				16, 0xaaaaaa, 0x555555);
    src_ptr = (unsigned char *) gdk_pixbuf_get_pixels (back);
  } else {
    src_ptr = (unsigned char *) gdk_pixbuf_get_pixels (pix);
  }
  /* ϲؤΥݥ */
  dst_ptr = (unsigned char *) img->data;

  /* ǡΥԡ */
  for (n = TeoFsize (img); n > 0; n--) *dst_ptr++ = *src_ptr++;

  /* ѥǡΰ */
  if (back) gdk_pixbuf_unref (back);  

  return img;
}

/* ********************************************* End of gdk-pixbuf2teo.c *** */
