/* *********************************************************************** *
 *	teo2eps (original source is gil2eps)
 *				transplanted by sugaya	1997  8/ 3
 * *********************************************************************** */ 
#include<stdio.h>
#include<string.h>
#include<teo.h>

int get_args (int argc, char **argv, char **in_file, char **out_file,
              int *frame, int *plane, unsigned char *flg,
	      int *width, int *height, float *scale);
void exit_with_usage (char *comname);
TEOIMAGE *U_TeoCreateMagnifyImage (TEOFILE *in, int frame,
                                   float block_size_x, float block_size_y);
void teoeps (FILE *fp, TEOIMAGE *teo, char *name, 
	     int plane, int color,
	     int xsize, int ysize, int xcord, int ycord, char *creator);

int main (int argc, char **argv)
{
  TEOFILE	*teo;
  TEOIMAGE	*img;
  FILE		*fp;
  char		*filename, *savename;
  char		x_size[10], y_size[10];
  unsigned char	color;
  int		i, xsize, ysize, xcord, ycord;
  int 		frame, plane;
  float		scale, block_size_x, block_size_y;

  if ((get_args (argc, argv, &filename, &savename, &frame, &plane, &color,
		 &xsize, &ysize, &scale)) == -1)
    exit_with_usage (argv[0]);
    
  if (savename)
    fp = fopen (savename, "w");
  else
    fp = stdout;

  if ((teo = TeoOpenFile (filename)) == NULL) TeoError ();
  
  if ((xsize == 0) && (ysize == 0)) {
    block_size_x = 1 / scale;
    block_size_y = 1 / scale;
    img = U_TeoCreateMagnifyImage (teo, frame, block_size_x, block_size_y);
    xsize = (int) (teo_width (teo) * scale);
    ysize = (int) (teo_height(teo) * scale);
  } else {
    if (xsize == 0) xsize = teo_width (teo);
    if (ysize == 0) ysize = teo_height(teo);
    block_size_x = (float) teo_width (teo) / xsize;
    block_size_y = (float) teo_height(teo) / ysize;
    img = U_TeoCreateMagnifyImage (teo, frame, block_size_x, block_size_y);
  }

  /* A4 centering */
  xcord = (595-xsize)/2;
  ycord = (850-ysize)/2;

  teoeps (fp, img, filename, plane, color, xsize, ysize,
	  xcord, ycord, argv[0]);

  TeoCloseFile (teo);
  TeoFreeImage (img);
  fclose (fp);
  exit(0);
}
