// -*- Mode: C++ -*-
#include <stdio.h>
#include <stdlib.h>
#include <teopp.h>

void usage(char *pname){
    fprintf(stderr,"usage: %s [-f <start frame> <num of frames>] x y width height [teofile]\n",pname);
    exit(-1);
}

int main(int argc,char **argv){
  int sf=0,ef=0;
  int i=1;
  while(i<argc&&argv[i][0]=='-')
    switch(argv[i++][1]){
    case 'f':
      if(i+2 >= argc) usage(argv[0]);
      sf = atoi(argv[i++]);
      ef = atoi(argv[i++]);
      break;
    default:
      break;
    }

  int xx,yy,width=0,height=0;
  if(i+4 < argc){

    xx = atoi(argv[i++]);
    yy = atoi(argv[i++]);
    width = atoi(argv[i++]);
    height = atoi(argv[i++]);
  }
  TeoFile file;
  if(i < argc){
    file = TeoFile(argv[i++]);
  } else {
    file = TeoFile("-");
  }
  if(width <= 0 && height <= 0){
    xx = file.Xstart();
    yy = file.Ystart();
    width = file.Width();
    height = file.Height();
  }
  if(sf == 0 && ef == 0) ef = file.Frame();
  TeoFile output = TeoFile("-",width,height,0,0,file.Type(),file.Bit(),
		   file.Plane(),ef,0,NULL);

  TeoAnyImage inimg;
  TeoAnyImage outimg(output.Width(),output.Height(),
		     output.Xoffset(),output.Yoffset(),
		     output.Type(),output.Bit(),output.Plane());

  char *srcp,*distp;
  int plane=file.Plane();

  int linesize = (width*plane*(file.Bit()/8));

  file.SetAbsFrame(sf);
  while(file.CheckFrame()&&file.Current()<sf+ef){
    inimg = file.GetImage();
    for(int y=0;y<height;y++){
      srcp = (char *)inimg.Address(xx,y+yy,0);
      distp = (char *)outimg.Address(0,y,0);
      for(int j=0;j<linesize;j++)
	*(distp++)=*(srcp++);
    }
    output.PutImage(outimg);
  }
  return 0;
}
