<?php
/*
  $Id: REMISECSP.php,v 1.0.5a 2004/06/25
  catalog/includes/modules/payment/remisecsp.php
  http://www.endless.ne.jp/

  Copyright (c) 2003-2004 Endless Net
  
  Released under the GNU General Public License

*/

// PHPϡ4.0.6ʾ

  class remisecsp {
    var $code, $title, $description, $enabled;

// class constructor
    function remisecsp() {
      global $order;
 
      if(ini_get('output_handler') != 'mb_output_handler')
      ob_start("mb_output_handler");
	  
      $this->code = 'remisecsp';
      $this->title = MODULE_PAYMENT_REMISECSP_TEXT_TITLE;
      $this->description = MODULE_PAYMENT_REMISECSP_TEXT_DESCRIPTION;
      $this->explain = MODULE_PAYMENT_REMISECSP_TEXT_EXPLAIN;
      $this->sort_order = MODULE_PAYMENT_REMISECSP_SORT_ORDER;
      $this->enabled = ((MODULE_PAYMENT_REMISECSP_STATUS == 'True') ? true : false);

      if ((int)MODULE_PAYMENT_REMISECSP_ORDER_STATUS_ID > 0) {
        $this->order_status = MODULE_PAYMENT_REMISECSP_ORDER_STATUS_ID;
      }

      if (is_object($order)) $this->update_status();

      $this->form_action_url =MODULE_PAYMENT_REMISECSP_URL;
      $this->email_footer = MODULE_PAYMENT_REMISECSP_TEXT_EMAIL_FOOTER;
    }

// class methods
    function update_status() {
      global $order;

      if ( ($this->enabled == true) && ((int)MODULE_PAYMENT_REMISECSP_ZONE > 0) ) {
        $check_flag = false;
        $check_query = tep_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_PAYMENT_REMISECSP_ZONE . "' and zone_country_id = '" . $order->billing['country']['id'] . "' order by zone_id");
        while ($check = tep_db_fetch_array($check_query)) {
          if ($check['zone_id'] < 1) {
            $check_flag = true;
            break;
          } elseif ($check['zone_id'] == $order->billing['zone_id']) {
            $check_flag = true; 
            break;
          }
        }

        if ($check_flag == false) {
          $this->enabled = false;
        }
      }
    }

    function javascript_validation() {
      return false;
    }

    function selection() {

      return array('id' => $this->code,
                  'module' => $this->title,
                  'fields' => array(array('title' => $this->explain,'field' => '')));
    }

    function pre_confirmation_check() {
      global $order;
      
      	$encode =mb_http_input();			
		if($encode == 'ASCII' ){ $encode = 'UTF-8';}
      
		$phonenum=ereg_replace("-","",mb_convert_kana($order->customer['telephone'],"a")); 
	
		if(strlen($phonenum)>11 || strlen($phonenum)<9){
			
			$error=mb_convert_encoding(MODULE_PAYMENT_REMISECSP_TEXT_ERROR_INVALID_PHONE_NUM,$encode);
				
			$payment_error_return = 'payment_error=' . $this->code . '&error=' . urlencode($error);
			tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, $payment_error_return, 'SSL', true, false));
		}
	      				
		return false;
		
    }

    function confirmation() {
      return false;
    }

    function process_button() {
      global $HTTP_SERVER_VARS, $order, $currencies,$customer_id;
      
      	mb_http_output("SJIS-win");
      
		$customer_address = mb_convert_kana($order->delivery['state'].$order->delivery['city'].$order->delivery['street_address']. $order->delivery['suburb'],"KVHAS");
		
		if(strlen($customer_address)<=50){
			$address1 = $customer_address;
			$address2 = '';
			$address3 = '';
		}elseif (strlen($customer_address)<=100){    	
			$address1 = mb_strcut($customer_address,0,50);
			$address2 = mb_strcut($customer_address,26,50);
			$address3 = '';
		}else{
			$address1 = mb_strcut($customer_address,0,50);
			$address2 = mb_strcut($customer_address,26,50);
			$address3 = mb_strcut($customer_address,51,100);
		}
		                
      $process_button_string = 
			tep_draw_hidden_field('SHOPCO', MODULE_PAYMENT_REMISECSP_SHOP_CODE) .
			tep_draw_hidden_field('HOSTID', MODULE_PAYMENT_REMISECSP_HOST_ID) .
			tep_draw_hidden_field('S_TORIHIKI_NO', $customer_id . date('ymdHis')) .
			tep_draw_hidden_field('NAME1', mb_strcut(mb_convert_kana($order->billing['lastname'],"KVHA"),0,20)) .
			tep_draw_hidden_field('NAME2', mb_strcut(mb_convert_kana($order->billing['firstname'],"KVHA"),0,20)) .
			tep_draw_hidden_field('KANA1', mb_strcut(mb_convert_kana(MODULE_PAYMENT_REMISECSP_TEXT_INPUT_KANA,"KVHA"),0,20)) .
			tep_draw_hidden_field('KANA2', mb_strcut(mb_convert_kana(MODULE_PAYMENT_REMISECSP_TEXT_INPUT_KANA,"KVHA"),0,20)) .
			tep_draw_hidden_field('YUBIN1', ereg_replace("-","",mb_convert_kana(substr($order->delivery['postcode'],0,3),"a"))) .
			tep_draw_hidden_field('ADD1', $address1) .
			tep_draw_hidden_field('ADD2', $address2) .
			tep_draw_hidden_field('ADD3', $address3) . 
			tep_draw_hidden_field('TEL', substr(ereg_replace("-","",mb_convert_kana($order->customer['telephone'],"a")),0,11) ) .
			tep_draw_hidden_field('MAIL', mb_convert_kana($order->customer['email_address'],"a") ) .
			tep_draw_hidden_field('TAX', '0') .
			tep_draw_hidden_field('TOTAL', $order->info['total']) .
			tep_draw_hidden_field('S_PAYDATE', date('Ymd',mktime(0,0,0,date(m),date(d)+MODULE_PAYMENT_REMISECSP_PAYDATE,date(Y)))) .
			tep_draw_hidden_field('SEIYAKUDATE', date('Ymd')) .
			tep_draw_hidden_field('RETURL', tep_href_link(FILENAME_CHECKOUT_PROCESS, '', 'SSL', true)) . 
			tep_draw_hidden_field('NG_RETURL', tep_href_link(FILENAME_CHECKOUT_PAYMENT, 'payment_error=' . $this->code, 'NONSSL', true)) .  
			tep_draw_hidden_field('MNAME_01', mb_convert_kana(MODULE_PAYMENT_REMISECSP_TEXT_GOODS_NAME,"KVHA") ) .
			tep_draw_hidden_field('MSUM_01', $order->info['total']);

      return $process_button_string;
    }

    function before_process() {
      return true;
    }

    function after_process() {
      return false;
    }

    function output_error() {
      return false;
    }

    function get_error() {
      global $HTTP_GET_VARS;
      
	  if (isset($HTTP_GET_VARS['error']) && (strlen($HTTP_GET_VARS['error']) > 0)) {
        $error = stripslashes(urldecode($HTTP_GET_VARS['error']));
      }else{
      	$error = MODULE_PAYMENT_REMISECSP_TEXT_ERROR_MESSAGE;
      }
      
      return array('title' => MODULE_PAYMENT_REMISECSP_TEXT_ERROR,
                   'error' => $error);
    }

    function check() {
		if (!isset($this->_check)) {
			$check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_REMISECSP_STATUS'");
			$this->_check = tep_db_num_rows($check_query);
		}
		return $this->_check;
    }

    function install() {
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Enable REMISECSP Module', 'MODULE_PAYMENT_REMISECSP_STATUS', 'True', 'ߡӥ˷Ѥͭˤޤ?', '6', '0', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('REMISECSP Url', 'MODULE_PAYMENT_REMISECSP_URL', 'https://test.remise.jp/rpgw/paycvs.asp', 'ѾURL', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Shop Code', 'MODULE_PAYMENT_REMISECSP_SHOP_CODE', '00000000', 'Ź', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Host Id', 'MODULE_PAYMENT_REMISECSP_HOST_ID', '00000000', 'ۥֹ', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Pay Date', 'MODULE_PAYMENT_REMISECSP_PAYDATE', '10', 'ʧ(2ʾ59)', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('ɽ', 'MODULE_PAYMENT_REMISECSP_SORT_ORDER', '0', 'ɽǤޤۤɾ̤ɽޤ', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Payment Zone', 'MODULE_PAYMENT_REMISECSP_ZONE', '0', 'If a zone is selected, only enable this payment method for that zone.', '6', '2', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, use_function, date_added) values ('ʸơ', 'MODULE_PAYMENT_REMISECSP_ORDER_STATUS_ID', '0', 'ꤷơŬѤޤ', '6', '0', 'tep_cfg_pull_down_order_statuses(', 'tep_get_order_status_name', now())");
    }

    function remove() {
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_PAYMENT_REMISECSP_STATUS', 'MODULE_PAYMENT_REMISECSP_URL','MODULE_PAYMENT_REMISECSP_SHOP_CODE','MODULE_PAYMENT_REMISECSP_HOST_ID', 'MODULE_PAYMENT_REMISECSP_PAYDATE','MODULE_PAYMENT_REMISECSP_ZONE', 'MODULE_PAYMENT_REMISECSP_ORDER_STATUS_ID', 'MODULE_PAYMENT_REMISECSP_SORT_ORDER');
    }
  }
?>