<?php
/*
  $Id: _nipponex.php,v 1.1 2005/03/17 01:12:03 ptosh Exp $

  NipponEx Shipping Calculator.
  Calculate shipping costs.

 Based on sagawaex written by TAMURA Toshihiko (tamura@bitscope.co.jp) 2003/04/10 for MS2.1
 
 */
/*
    $rate = new _NipponEx('nipponex','̾');
    $rate->SetOrigin('01', 'JP');   // ̳ƻ
    $rate->SetDest('13', 'JP');     // Ԥޤ
    $rate->SetWeight(10);           // kg
    $quote = $rate->GetQuote();
    print $quote['type'] . "<br>";
    print $quote['cost'] . "\n";
*/
class _NipponEx {
    var $quote;
    var $OriginZone;
    var $OriginCountryCode = 'JP';
    var $DestZone;
    var $DestCountryCode = 'JP';
    var $Weight = 0;
    var $Length = 0;
    var $Width  = 0;
    var $Height = 0;

    // 󥹥ȥ饯
    // $id:   module id
    // $titl: module name
    // $zone: ƻܸ '01''47'
    // $country: country code
    function _NipponEx($id, $title, $zone = NULL, $country = NULL) {
        $this->quote = array('id' => $id, 'title' => $title);
        if($zone) {
            $this->SetOrigin($zone, $country);
        }
    }
    // ȯ򥻥åȤ
    // $zone: ƻܸ '01''47'
    // $country: country code
    function SetOrigin($zone, $country = NULL) {
        $this->OriginZone = $zone;
        if($country) {
            $this->OriginCountryCode = $country;
        }
    }
    function SetDest($zone, $country = NULL) {
        $this->DestZone = $zone;
        if($country) {
            $this->DestCountryCode = $country;
        }
    }
    function SetWeight($weight) {
        $this->Weight = $weight;
    }
    function SetSize($length = NULL, $width = NULL, $height = NULL) {
        if($length) {
            $this->Length = $length;
        }
        if($width) {
            $this->Width = $width;
        }
        if($height) {
            $this->Height = $height;
        }
    }
    // ʬ(05)֤
    // ʳξ9֤
    //
    // ʬ  ̾  շ   
    // ----------------------------------
    // 0     60  60cmޤ  2kgޤ
    // 1     80  80cmޤ  5kgޤ
    // 2    100 100cmޤ 10kgޤ
    // 3    120 120cmޤ 15kgޤ
    // 4    140 140cmޤ 20kgޤ
    // 5    170 170cmޤ 30kgޤ
    // 9    ʳ    
    function GetSizeClass() {
        $a_classes = array(
            array(0,  60,  2),  // ʬ,շ,
            array(1,  80,  5),
            array(2, 100, 10),
            array(3, 120, 15),
            array(4, 140, 20),
            array(5, 170, 30)
        );

        $n_totallength = $this->Length + $this->Width + $this->Height;

        while (list($n_index, $a_limit) = each($a_classes)) {
            if ($n_totallength <= $a_limit[1] && $this->Weight <= $a_limit[2]) {
                return $a_limit[0];
            }
        }
        return -1;  // ʳ
    }
    // ո褫饭
    //
    function GetDistKey() {
        $s_key = '';
        $s_z1 = $this->GetLZone($this->OriginZone);
        $s_z2 = $this->GetLZone($this->DestZone);
        if ( $s_z1 && $s_z2 ) {
            // ӥɤ򥢥ե٥åȽϢ뤹
            if ( ord($s_z1) < ord($s_z2) ) {
                $s_key = $s_z1 . $s_z2;
            } else {
                $s_key = $s_z2 . $s_z1;
            }
        }
        return $s_key;
    }
    // ƻܸɤӥɤ
    // $zone: ƻܸ
    function GetLZone($zone) {
        // ƻܸɤӥ('A''K')Ѵ
        //     ̳ƻ :'A' = ̳ƻ
        //        :'B' = Ŀ,ĸ,,긩,ܾ븩,ʡ縩
        // 졦 :'C' = ,,̸,ո,ڸ,븩,ϸ,,Ĺ,㸩
        // Φ :'D' = θ,Ÿ,츩,Ų,ٻ,,ʡ温
        //        :'E' = ,ʼ˸,ɸ,²λ,,츩
        //        :'F' = Ļ踩,纬,,縩,
        //       ͹ :'G' = 縩,,ɲ,θ
        //       彣 :'H' = ʡ,츩,Ĺ긩,ʬ,ܸ,ܺ긩,縩
        //        :'I' = 츩
        
        $a_zonemap = array(
        '01'=>'A',  // ̳ƻ
        '02'=>'B',  // Ŀ
        '03'=>'B',  // 긩
        '04'=>'B',  // ܾ븩
        '05'=>'B',  // ĸ
        '06'=>'B',  // 
        '07'=>'B',  // ʡ縩
        '08'=>'C',  // 븩
        '09'=>'C',  // ڸ
        '10'=>'C',  // ϸ
        '11'=>'C',  // ̸
        '12'=>'C',  // ո
        '13'=>'C',  // 
        '14'=>'C',  // 
        '15'=>'C',  // 㸩
        '16'=>'D',  // ٻ
        '17'=>'D',  // 
        '18'=>'D',  // ʡ温
        '19'=>'C',  // 
        '20'=>'C',  // Ĺ
        '21'=>'D',  // 츩
        '22'=>'D',  // Ų
        '23'=>'D',  // θ
        '24'=>'D',  // Ÿ
        '25'=>'E',  // 츩
        '26'=>'E',  // 
        '27'=>'E',  // 
        '28'=>'E',  // ʼ˸
        '29'=>'E',  // ɸ
        '30'=>'E',  // ²λ
        '31'=>'F',  // Ļ踩
        '32'=>'F',  // 纬
        '33'=>'F',  // 
        '34'=>'F',  // 縩
        '35'=>'F',  // 
        '36'=>'G',  // 縩
        '37'=>'G',  // 
        '38'=>'G',  // ɲ
        '39'=>'G',  // θ
        '40'=>'H',  // ʡ
        '41'=>'H',  // 츩
        '42'=>'H',  // Ĺ긩
        '43'=>'H',  // ܸ
        '44'=>'H',  // ʬ
        '45'=>'H',  // ܺ긩
        '46'=>'H',  // 縩
        '47'=>'I'   // 츩
        );
        return $a_zonemap[$zone];
    }

    function GetQuote() {
        // Υ̤βʥ: 󥯥 => (60,80,100,120,140,170)
        $a_pricerank = array(
        'N01'=>array( 740, 950,1160,1370,1580,1790),// ̾(01) Υ
        'N02'=>array( 840,1050,1260,1470,1680,1890),// ̾(02)   
        'N03'=>array( 950,1160,1370,1580,1790,2000),// ̾(03)
        'N04'=>array(1050,1260,1470,1680,1890,2100),// ̾(04)
        'N05'=>array(1160,1370,1580,1790,2000,2210),// ̾(05)
        'N06'=>array(1260,1470,1680,1890,2100,2310),// ̾(06)
        'N07'=>array(1370,1580,1790,2000,2210,2420),// ̾(07)
        'N08'=>array(1470,1680,1890,2100,2310,2520),// ̾(08)
        'N09'=>array(1580,1790,2000,2210,2420,2630),// ̾(09)
        'N10'=>array(1680,1890,2100,2310,2520,2730),// ̾(10)
        'N11'=>array(1790,2000,2210,2420,2630,2840),// ̾(11)
        'N12'=>array(1160,1680,2210,2730,3260,3780),// ̾(12)
        'N13'=>array(1260,1790,2310,2840,3360,3890),// ̾(13)
        'N14'=>array(1470,2000,2520,3050,3570,4100),// ̾(14)   
        'N15'=>array(1890,2420,2940,3470,3990,4520) // ̾(15) Υ
        );
        //  - Ӵ֤βʥ
        // () http://www19.nittsu.co.jp/fare/index2.htm
        $a_dist_to_rank = array(
        'AA'=>'N01',
        'AB'=>'N03','BB'=>'N01',
        'AC'=>'N05','BC'=>'N01','CC'=>'N01',
        'AD'=>'N06','BD'=>'N02','CD'=>'N01','DD'=>'N01',
        'AE'=>'N08','BE'=>'N03','CE'=>'N02','DE'=>'N01','EE'=>'N01',
        'AF'=>'N09','BF'=>'N05','CF'=>'N03','DF'=>'N02','EF'=>'N01','FF'=>'N01',
        'AG'=>'N10','BG'=>'N06','CG'=>'N04','DG'=>'N03','EG'=>'N02','FG'=>'N02','GG'=>'N01',
        'AH'=>'N11','BH'=>'N07','CH'=>'N05','DH'=>'N03','EH'=>'N02','FH'=>'N01','GH'=>'N02','HH'=>'N01',
        'AI'=>'N15','BI'=>'N14','CI'=>'N13','DI'=>'N13','EI'=>'N13','FI'=>'N13','GI'=>'N13','HI'=>'N12','II'=>'N01'
        );

        $s_key = $this->GetDistKey();
        if ( $s_key ) {
            $s_rank = $a_dist_to_rank[$s_key];
            if ( $s_rank ) {
                $n_sizeclass = $this->GetSizeClass();
                if ($n_sizeclass < 0) {
                    $this->quote['error'] = MODULE_SHIPPING_NIPPONEX_TEXT_OVERSIZE;
                } else {
                    $this->quote['cost'] = $a_pricerank[$s_rank][$n_sizeclass];
                }
            //  $this->quote['DEBUG'] = ' zone=' . $this->OriginZone . '=>' . $this->DestZone   //DEBUG
            //                  . ' cost=' . $a_pricerank[$s_rank][$n_sizeclass];           //DEBUG
            } else {
                $this->quote['error'] = MODULE_SHIPPING_NIPPONEX_TEXT_OUT_OF_AREA . '(' . $s_key .')';
            }
        } else {
            $this->quote['error'] = MODULE_SHIPPING_NIPPONEX_TEXT_ILLEGAL_ZONE . '(' . $this->OriginZone . '=>' . $this->DestZone . ')';
        }

        return $this->quote;
    }
}
?>