import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.IOException;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;


/*
 * Created  : 2004/01/20
 * Modified : 2007/08/27
 *
 * It creates for management of the item of the test carried out by JUnit.
 * Java source -> XML file -> testcase of TestLink
 */

/**
 * @author Masahide Katsumata
 *
 * The comment of the test method carried out by JUnit is outputted in XML form.
 */
public class JavaToXml {
	private static final String TL_XMLHEAD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
	private static final String TL_TESTCASES = "testcases";
	private static final String TL_TESTCASENAME = "testcase";
	private static final String TL_SUMMARY = "summary";
	private static final String TL_STEPS = "steps";
	private static final String TL_EXPECTEDRESULTS = "expectedresults";
	private static final String TL_KEYWORDS = "keywords";
	private static final String TL_KEYWORD = "keyword";
	private static final String TL_NOTES = "notes";
	private static final String TL_XMLHEADER = TL_XMLHEAD + "\n<" + TL_TESTCASES + ">";
	private static final String TL_XMLFOOTER = "</" + TL_TESTCASES + ">";

	private static final String TL_TESTCASENAME_TAG = "tltestcase";
	private static final String TL_SUMMARY_TAG = "tlsummary";
	private static final String TL_STEPS_TAG = "tlsteps";
	private static final String TL_EXPECTEDRESULTS_TAG = "tlexpectedresults";
	private static final String TL_KEYWORD_TAG = "tlkeyword";
	private static final String TL_NOTES_TAG = "tlnotes";

	private static final String XMLFILE = "testcases.xml";


	/**
	 * This is started from Javadoc. and invoke makeXML().
	 * @param root root of Javadoc
	 * @return return to docletB
	 * @since 1.1
	 */
	public static boolean start(RootDoc root){ 
		makeXML(root.classes());
		return true;
	}

	/**
	 * Input data is written in a file.
	 * At a certain time, a file already adds only difference with input data.
	 * @param xml file which makeXML() created
	 * @since 1.0
	 */
	private static void writeXML(StringBuffer xml) {
		FileOutputStream	outStream        = null;
		FileInputStream		inputStream	      = null;
		File		inFile	      = null;
		OutputStreamWriter     fileWriter     = null;
		InputStreamReader	fileReader = null;
		BufferedWriter bufferedWriter = null;
		BufferedReader bufferedReader = null;
		StringBuffer   currentXML     = null;
		String         line;
		int           start;
		int           end;

		try {
			inFile = new File(XMLFILE);
			currentXML = new StringBuffer();

			if (inFile.exists()) {
				inputStream = new FileInputStream(XMLFILE);
				fileReader = new InputStreamReader(inputStream, "UTF-8");
				bufferedReader = new BufferedReader(fileReader);

				while (bufferedReader.ready()) {
					line = bufferedReader.readLine();
					if (!line.equals(TL_XMLFOOTER)){
						currentXML.append(line + "\n");
					}
				}

				bufferedReader.close();
				bufferedReader = null;

				start = 0;
				end = 0;
				while (xml.length() > start){
					end = xml.indexOf("\n", start +1);
//					 System.out.println("start = " + start + "\n end = " + end);
					line = xml.substring(start, end);
//					System.out.println("line=" + line);
					if (currentXML.indexOf(line) == -1){
						currentXML.append(line + "\n");
					}
					start = end + 1;
				}
				currentXML.append(TL_XMLFOOTER + "\n");
			} else {
				currentXML.append(TL_XMLHEADER + "\n");
				currentXML.append(xml);
				currentXML.append(TL_XMLFOOTER + "\n");
			}
			inputStream = null;
			fileReader = null;
			inFile = null;

			outStream = new FileOutputStream(XMLFILE);
			fileWriter     = new OutputStreamWriter(outStream, "UTF-8");
			bufferedWriter = new BufferedWriter(fileWriter);
			bufferedWriter.write(currentXML.toString());

			bufferedWriter.flush();
			bufferedWriter.close();
			bufferedWriter = null;
			fileWriter     = null;
			outStream        = null;

		} catch (IOException ioe) {
			ioe.printStackTrace();

			throw new RuntimeException(ioe.toString());
		}

	
	}
	
	/**
	 * The information for generating list of test cases from source files
	 * @param classes target class
	 * @since 1.0
	 */
	private static void makeXML(ClassDoc[] classes) {

		StringBuffer XML = new StringBuffer();
		for (int i=0; i < classes.length; i++) {
			MethodDoc[] methods = classes[i].methods();
			for (int j=0; j < methods.length; j++) {
				Tag[] testcasenameTag = methods[j].tags(TL_TESTCASENAME_TAG);
				Tag[] summaryTag = methods[j].tags(TL_SUMMARY_TAG);
				Tag[] stepsTag = methods[j].tags(TL_STEPS_TAG);
				Tag[] expectedresultsTag = methods[j].tags(TL_EXPECTEDRESULTS_TAG);
				Tag[] keywordTag = methods[j].tags(TL_KEYWORD_TAG);
				Tag[] notesTag = methods[j].tags(TL_NOTES_TAG);

				if (testcasenameTag.length > 0) {
					for (int k=0; k < testcasenameTag.length; k++) {
//						 System.out.println("<" + TL_TESTCASENAME + " name=\"" + testcasenameTag[k].text() + "\">"
//						+ "<" + TL_SUMMARY + "><![CDATA[<p>" + summaryTag[k].text() + "</p>]]></" + TL_SUMMARY + ">"
//						+ "<" + TL_STEPS + "><![CDATA[<p>" + stepsTag[k].text() + "</p>]]></" + TL_STEPS + ">"
//						+ "<" + TL_EXPECTEDRESULTS + "><![CDATA[<p>" + expectedresultsTag[k].text() + "</p>]]></" + TL_EXPECTEDRESULTS + ">"
//						+ "<" + TL_KEYWORDS + ">"
//						+ "<" + TL_KEYWORD + " name=\"" + keywordTag[k].text() + "\">"
//						+ "<" + TL_NOTES + "><![CDATA[<p>" + notesTag[k].text() + "</p>]]></" + TL_NOTES + ">"
//						+ "</" + TL_KEYWORD + ">"
//						+ "</" + TL_KEYWORDS + ">"
//						+ "</" + TL_TESTCASENAME + ">\n");
						XML.append("<" + TL_TESTCASENAME + " name=\"" + testcasenameTag[k].text() + "\">"
						+ "<" + TL_SUMMARY + "><![CDATA[<p>" + summaryTag[k].text() + "</p>]]></" + TL_SUMMARY + ">"
						+ "<" + TL_STEPS + "><![CDATA[<p>" + stepsTag[k].text() + "</p>]]></" + TL_STEPS + ">"
						+ "<" + TL_EXPECTEDRESULTS + "><![CDATA[<p>" + expectedresultsTag[k].text() + "</p>]]></" + TL_EXPECTEDRESULTS + ">"
						+ "<" + TL_KEYWORDS + ">"
						+ "<" + TL_KEYWORD + " name=\"" + keywordTag[k].text() + "\">"
						+ "<" + TL_NOTES + "><![CDATA[<p>" + notesTag[k].text() + "</p>]]></" + TL_NOTES + ">"
						+ "</" + TL_KEYWORD + ">"
						+ "</" + TL_KEYWORDS + ">"
						+ "</" + TL_TESTCASENAME + ">\n");
					}
				} 
			}
		}
		writeXML(XML);
	}
}
