<?php
/* TestLink Open Source Project - http://testlink.sourceforge.net/ 
 * This script is distributed under the GNU General Public License 2 or later. 
 *
 * Filename $RCSfile: planMilestones.php,v $
 *
 * @version $Revision: 1.12 $
 * @modified $Date: 2007/06/22 17:12:35 $
 */
require_once('../../config.inc.php');
require_once("../functions/common.php");
require_once("plan.inc.php");
testlinkInitPage($db);

$milestone_mgr=new milestone_mgr($db);

$_POST = strings_stripSlashes($_POST);
$name = isset($_POST['milestone_name']) ? $_POST['milestone_name'] : '';

// Important!!!
// name of this variables is generated by smarty
$date_year = isset($_POST['Date_Year']) ? $_POST['Date_Year'] : null;
$date_month = isset($_POST['Date_Month']) ? $_POST['Date_Month'] : null;
$date_day = isset($_POST['Date_Day']) ? $_POST['Date_Day'] : null;
$date=null;

if( !is_null($date_year) && !is_null($date_month) && !is_null($date_day) )
{
  $date= $date_year . "-" . $date_month . "-" . $date_day;
}
$A = isset($_POST['A']) ? $_POST['A'] : 0;
$B = isset($_POST['B']) ? $_POST['B'] : 0;
$C = isset($_POST['C']) ? $_POST['C'] : 0;
$newMileStone = isset($_POST['newMilestone']) ? $_POST['newMilestone'] : null;
$bDelete = isset($_GET['delete']) ? $_GET['delete'] : null;
$bUpdate = isset($_POST['update']) ? $_POST['update'] : null;
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$pid = isset($_POST['id']) ? intval($_POST['id']) : 0;
$idPlan = isset($_SESSION['testPlanId']) ? $_SESSION['testPlanId'] : 0;
$tpName = $_SESSION['testPlanName'];

$sqlResult = null;
$mileStone = null;
$action = null;

if ($id && !$bDelete && !$bUpdate && !$newMileStone)
{
	$ms_map = $milestone_mgr->get_by_id($id);
	$mileStone = $ms_map[$id];
}
else if ($bDelete && $id)
{
	$sqlResult = 'ok';
	if (!$milestone_mgr->delete($id))
		$sqlResult = lang_get('milestone_delete_fails'). ' : ' . $db->error_msg();
	$action = "deleted";
}
else if($newMileStone || $bUpdate)
{
	$mileStone = array(
		"name" => $name,
		"target_date" => $date,
		"A" => $A,
		"B" => $B,
		"C" => $C,
	);
	$sqlResult = checkMileStone($name,$date,$A,$B,$C);
	if (is_null($sqlResult))
	{
		$sqlResult = 'ok';
		if ($newMileStone)
		{
			if (!$milestone_mgr->create($idPlan,$name,$date,$A,$B,$C))
				$sqlResult = lang_get("warning_milestone_add_failed") . $db->error_msg();
		}
		else if ($pid)
		{
			if (!$milestone_mgr->update($pid,$name,$date,$A,$B,$C))
				$sqlResult = lang_get("warning_milestone_update_failed") . $db->error_msg();
		}
		if ($sqlResult == 'ok')
			$mileStone = null;
	}
	//reset info, after successful updating	
	$action = $bUpdate ? "updated" : "do_add";
}

$mileStones = $milestone_mgr->get_all_by_testplan($idPlan);

$smarty = new TLSmarty();
$smarty->assign('sqlResult', $sqlResult);
$smarty->assign('tpName', $tpName);
$smarty->assign('arrMilestone', $mileStones);
$smarty->assign('mileStone', $mileStone);
$smarty->assign('action', $action);
$smarty->display('planMilestones.tpl');
?>

<?php
/**
 * Checks the milestone parameter for correctness
 *
 * @param string $name the name for the milestone
 * @param string $date the milestone date
 * @param int $A the A-Val [0,100]
 * @param int $B the B-Val [0,100]
 * @param int $C the C-Val [0,100]
 * @return string returns null on success, an error msg else
 **/
function checkMileStone($name,$date,$A,$B,$C)
{
	$msg = null;
	if (preg_match("/\D/",$A) || preg_match("/\D/",$B) || preg_match("/\D/",$C)
		|| !strlen($A) || !strlen($B) || !strlen($C))
		$msg = lang_get("warning_invalid_percentage_value");	
	else if (intval($A) > 100 || intval($B) > 100 || intval($C) > 100)
		$msg = lang_get("warning_invalid_percentage_value");	
	else if ((intval($A) + intval($B) + intval($C)) > 100)
		$msg = lang_get("warning_percentage_value_higher_than_100");	
	else if (strlen($name))
	{
		if(strlen($date))
		{
			$s1 = strtotime($date." 23:59:59");
			$s2 = strtotime("now");
			if ($s1 < $s2)
				$msg = lang_get('warning_milestone_date');
		}
		else
			$msg = lang_get("warning_enter_valid_date");
	}
	else
		$msg = lang_get("warning_empty_milestone_name");
		
	return $msg;
}
?>