package com.torn.tetoru.parts;


/* SMyBlockA3_̏ */
public class Mino extends Block implements Cloneable {

	/* ]̌ */
	public static final int R_NO = 0;
	public static final int R_RIGHT = 1;
	public static final int R_LEFT = -1;


	private static final int MINO_TBL_NUM = 8;
	private static final int MINO_INFO_NUM = 3; /* eg(4) - 1 */

	/* 3_̏̃e[u */
	private static int[][][] infoTbl = new int[MINO_TBL_NUM][MINO_INFO_NUM][2];
	private static int[][] info_ = {{ 0, 0},{ 0, 0},{ 0, 0}};
	private static int[][] infoI = {{ 1, 0},{ -2, 0},{-1, 0}};
	private static int[][] infoO = {{ 0,-1},{-1,-1},{-1, 0}};
	private static int[][] infoT = {{ 0,-1},{ 1, 0},{-1, 0}};
	private static int[][] infoS = {{ 0,-1},{ 1,-1},{-1, 0}};
	private static int[][] infoZ = {{ 0,-1},{ 1, 0},{-1,-1}};
	private static int[][] infoJ = {{ 1, 0},{-1, 0},{-1,-1}};
	private static int[][] infoL = {{ 1, 0},{-1, 0},{ 1,-1}};

	static {
		infoTbl[_] = info_;
		infoTbl[I] = infoI;
		infoTbl[O] = infoO;
		infoTbl[T] = infoT;
		infoTbl[S] = infoS;
		infoTbl[Z] = infoZ;
		infoTbl[J] = infoJ;
		infoTbl[L] = infoL;
	};


	/* S */
	// MyBlock center; /* MyBlockpĂ邽ߕsv */

	/* 3_̈ʒu */
	private int[][] info;

	/* ](0`3)*/
	private int state; 


	Mino(int type) {
		this(type, 0, 0);
	}
	Mino(int type, int x, int y) {
		/* S̐ݒ */
		super(type, x, y);

		/* 3_̐ݒ */
		info = new int[MINO_INFO_NUM][2];
		for (int cnt = 0; cnt < info.length; cnt++) {
			info[cnt][0] = infoTbl[type][cnt][0];
			info[cnt][1] = infoTbl[type][cnt][1];
		}
	}

	/**
	 * 3_̈ʒu̎擾
	 * @return
	 */
	public int[][] getInfo() {
		return info;
	}

	/**
	 * 3_̈ʒu̐ݒ
	 * @param info
	 */
	public void setInfo(int[][] info) {
		this.info = info;
	}

	/**
	 * S̐ݒ
	 * @param x
	 * @param y
	 */
	public void setCenter(int x, int y) {
		setX(x);
		setY(y);
	}


	/**************************************************************************/
	/* ]~m															  */
	/**************************************************************************/
	/* N[̐ */
	public Mino clone() {
		try {
			Mino cloned = (Mino) super.clone();

			/* intźAmɃRs[ */
			cloned.info = new int[MINO_INFO_NUM][2];
			for (int cnt = 0; cnt < info.length; cnt++) {
				cloned.info[cnt][0] = info[cnt][0];
				cloned.info[cnt][1] = info[cnt][1];
			}

			return cloned;
		} catch (CloneNotSupportedException e) {
			return null;
		}
	}

	/**
	 * ]Ԃݒ
	 * @param state
	 */
	void setState(int state) {
		this.state = state;
	}

	/**
	 * ]Ԃ擾
	 * @return
	 */
	int getState() {
		return state;
	}


	/**
	 * ʒủ]
	 * IvbNɂĂ͒Sړ
	 * @param dr
	 * @return
	 */
	public boolean rotateInfo(int dr) {
		/* `FbN */
		if (R_RIGHT != dr && R_LEFT != dr) {
			return false;
		}

		/* O~m͉]Ȃ */
		if (O == getType()) {
			return false;
		}

		/* 3_̉] */
		for (int cnt = 0; cnt < Mino.MINO_INFO_NUM; cnt++) {
			int x = info[cnt][0];
			int y = info[cnt][1];

			if (R_RIGHT == dr) {	/* Panelł̌ڂ͍] */
				info[cnt][0] = -y;
				info[cnt][1] = x;
			} else { /* R_LEFT == dr */
				info[cnt][0] = y;
				info[cnt][1] = -x;
			}
		}

		/* Ԃς */
		if (R_RIGHT == dr) {
			state = (state + 1) % 4;
		} else {
			state = (state - 1 + 4) % 4;
		}

		/* I~m̏ꍇAS̈ړ(S̍lႤ) */
		if (I == getType()) {
			if (R_RIGHT == dr) {
				switch (state) {
				case 1:
					setY(getY() + 1); /*  */
					Debug.println("first");
					break;
				case 2:
					setX(getX() - 1); /*  */
					break;
				case 3:
					setY(getY() - 1); /*  */
					break;
				case 0:
					setX(getX() + 1); /* E */
					break;
				}
			} else {
				switch (state) {
				case 3:
					setX(getX() - 1); /*  */
					break;
				case 2:
					setY(getY() + 1); /*  */
					break;
				case 1:
					setX(getX() + 1); /* E */
					break;
				case 0:
					setY(getY() - 1); /*  */
					break;
				}
			}
		}
		return true;
	}
}
