package com.torn.tetoru.parts;

import static com.torn.tetoru.parts.Block.$;
import static com.torn.tetoru.parts.Block.D;
import static com.torn.tetoru.parts.Block._;


public class Table {

	/* c~2z */
	private int[][] table;

	/* ubN̏oʒu */
	private static final int START_X = 5;
	private static final int START_Y = 1;

	/* lNXg */
	private NextTable nextTable;

	public Table() {
		this(12, 21);
	}
	public Table(int width, int height) {
		/* e[u` */
		table = new int[height][width];
		/* lNXge[u */
		nextTable = new NextTable();

		/* e[u */
		for (int y = 0; y < table.length; y++) {
			if (table.length-1 == y) {
				for (int x = 0; x < table[y].length; x++) {
					table[y][x] = $;
				}
			} else {
				for (int x = 1; x < table[y].length-1; x++) {
					table[y][x] = _;
				}
				table[y][0] = $;
				table[y][table[y].length-1] = $;
			}
		}
	}

	/**
	 * e[u\p擾
	 */
	public String toString() {
		StringBuilder builder;
		builder = new StringBuilder();

		for (int[] yoko : table) {
			for (int block : yoko) {
				builder.append(block);
			}
			builder.append(System.getProperty("line.separator"));
		}

		return builder.toString();
	}

	/**
	 * lNXg\p擾B
	 * NextTable#toStringbvB
	 * @return
	 */
	public String toStringNext() {
		return nextTable.toString();
	}

	/**************************************************************************/
	/* ~m																	  */
	/**************************************************************************/
	/**
	 * ~m
	 * @return
	 */
	public Mino initMino() {
		/* ނ擾 */
		int type = nextTable.getNextType();

		/* ʒu̐ݒ */
		int x = START_X;
		int y = START_Y;

		/* ~m̐ */
		return new Mino(type, x, y);
	}

	/**
	 * ~mu邩B
	 * ɒS̈ʒuw肷B
	 * @param current
	 * @param x
	 * @param y
	 * @return
	 */
	public boolean isSetMino(Mino current, int x, int y) {
		int cnt;
		int[][] info = current.getInfo();
		boolean ret = true;


//		Debug.println("x:" + x + " y:" + y);

		/* S̔ */
		if (_ != table[y][x]) {
			ret = false;;
		} else {
			/* 3_̔ */
			for (cnt = 0; cnt < info.length; cnt++) {
				int offsetX = info[cnt][0];
				int offsetY = info[cnt][1];

//				Debug.println("{" + offsetX + ", " + offsetY + "}");
				if (_ != table[y + offsetY][x + offsetX]) {
					ret = false;
					break;
				}
			}
		}

		return ret;
	}

	/**
	 * ~me[uɐݒB
	 * S̐ݒς݂ƂB(Mino#setCenter(int,int)ĂяoĂ)
	 * 	 * @param current
	 */
	public void setMino(Mino current) {
		int cnt;
		int type = current.getType();
		int x = current.getX();
		int y = current.getY();
		int[][] info = current.getInfo();

		/* 3_e[uɐݒ */
		for (cnt = 0; cnt < info.length; cnt++) {
			int offsetX = info[cnt][0];
			int offsetY = info[cnt][1];
			
			table[y + offsetY][x + offsetX] = type;
		}
		/* Se[uɐݒ */
		table[y][x] = type;
	}
	/**
	 * ~m̍폜
	 * @param current
	 */
	public void delMino(Mino current) {
		int cnt;
		int type = _;
		int x = current.getX();
		int y = current.getY();
		int[][] info = current.getInfo();

		/* 3_e[uɐݒ */
		for (cnt = 0; cnt < info.length; cnt++) {
			int offsetX = info[cnt][0];
			int offsetY = info[cnt][1];
			
			table[y + offsetY][x + offsetX] = type;
		}
		/* Se[uɐݒ */
		table[y][x] = type;
	}
	
	/**
	 * Ɉړ
	 * @param current
	 * @return
	 */
	public boolean moveDown(Mino current) {
		int x = current.getX();
		int y = current.getY();

		/* ̈ʒuU */
		delMino(current);

		/* ɒu邩 */
		if (!isSetMino(current, x, y+1)) {
			Debug.println("ɐݒu");

			/* ̈ʒuɐݒ*/
			setMino(current);
			return false;
		}


		/* PɈړ */
		current.setCenter(x, y+1);

		/* 1ɒu */
		setMino(current);

		return true;
	}

	/**
	 * EɈړ
	 * @param current
	 * @return
	 */
	public boolean moveRight(Mino current) {
		int x = current.getX();
		int y = current.getY();

		/* ̈ʒuU */
		delMino(current);

		/* Eɒu邩 */
		if (!isSetMino(current, x+1, y)) {
			/* ̈ʒuɐݒ*/
			setMino(current);
			return false;
		}

		/* PEɈړ */
		current.setCenter(x+1, y);

		/* 1Eɒu */
		setMino(current);

		return true;
	}

	/**
	 * Ɉړ
	 * @param current
	 * @return
	 */
	public boolean moveLeft(Mino current) {
		int x = current.getX();
		int y = current.getY();

		/* ̈ʒuU */
		delMino(current);

		/* ɒu邩 */
		if (!isSetMino(current, x-1, y)) {
			/* ̈ʒuɐݒ*/
			setMino(current);
			return false;
		}

		/* PɈړ */
		current.setCenter(x-1, y);

		/* 1ɒu */
		setMino(current);

		return true;
	}
	
	/**********************************************************************/
	/* ]																  */
	/**********************************************************************/
	/**
	 * ]~mݒuł邩
	 * @param tmpMino
	 * @param dr
	 * @return
	 */
	boolean isSetRotateMino(Mino tmpMino, int dr) {
		boolean ret = false;

		/* p[^擾 */
		int type = tmpMino.getType();
		int dir = dr;
		int turn =					 /* ̉] */
			(Mino.R_RIGHT == dr)	
			? (tmpMino.getState() - 1 + 4) % 4
			: (tmpMino.getState() + 1) % 4;

		/* S̈ʒu */
		int x = tmpMino.getX();
		int y = tmpMino.getY();

		/* ]@5܂œKp */
		for (int i = 1; i <= 5; i++) {
			Point p = RotateRule.moveDirection(i, type, turn, dir);
			Debug.print("(" + p.x + "," + p.y + ")");

			/* ~mzuł */
			/* TODO:I~m̗̈Oւ̈ړ̃`FbN */
			ret = isSetMino(tmpMino, x + p.x, y + p.y); 
			if (ret) {
				/* S̈ړs */
				tmpMino.setCenter(x + p.x, y + p.y);
				break;
			}
		}
		Debug.println("");

		return ret;
	}

	/**
	 * ]~me[uɐݒu
	 * @param current
	 * @param dr
	 * @return
	 */
	public boolean rotate(Mino current, int dr) {
		boolean ret;

		/* `FbN */
		if (Mino.R_RIGHT != dr && Mino.R_LEFT != dr) {
			return false;
		}

		/* ̈ʒuU */
		delMino(current);

		/* ~m̃Rs[쐬 */
		Mino tmpMino = current.clone();

		/* Rs[~m] */
		ret = tmpMino.rotateInfo(dr);
		if (!ret) {
			/* ̈ʒuɐݒ*/
			setMino(current);
			return false;
		}

		/* ]~mu邩(SRSɏ]AS̈ړ) */
		ret = isSetRotateMino(tmpMino, dr);
		if (!ret) {
			/* ̈ʒuɐݒ*/
			setMino(current);
			return false;
		}

		/* 쒆̃~mɕύXKp */
		current.setCenter(tmpMino.getX(), tmpMino.getY());
		current.setInfo(tmpMino.getInfo());
		current.setState(tmpMino.getState());


		/* ~me[uɐݒ */
		setMino(current);

		return true;
	}
	
	/**********************************************************************/
	/* C폜														  */
	/**********************************************************************/
	/* 1s폜(ۂɂ͍폜A폜Ώۂ̃~mƂĐݒ) */
	private void delLine(int y) {
		for (int i = 1; i < table[y].length - 1; i++) {
			table[y][i] = D;
		}
	}

	/* 1s폜ł邩 */
	private boolean isDelLine(int y) {
		boolean ret = true;

		for (int i = 1; i < table[y].length - 1; i++) {
			if (_ == table[y][i]) {
				ret = false;
				break;
			}
		}

		return ret;
	}

	/**
	 * s폜
	 * @param mino
	 * @return
	 */
	public boolean delMultiLine(Mino mino) {
		boolean ret = false;
		int[][] info = mino.getInfo();
		int y = mino.getY();
		int delY = y;

		/* S郉C̍폜 */
		if (isDelLine(delY)) {
			ret = true;
			delLine(delY);
		}

		/* S郉C̍폜 */
		for (int cnt = 0; cnt < info.length; cnt++) {
			delY = y + info[cnt][1];
			
			if (isDelLine(delY)) {
				ret = true;
				delLine(delY);
			}
		}

		return ret;
	}

	/**
	 * 폜Ώۃ~m̃Cl߂
	 */
	public void pack() {
		int packLineNum = 0; /* l߂郉C */
		final int CHECK_X = 1; /* Cō폜Ώۃ~m`FbNʒu

		/* ŉʍs폜Ώۂ`FbN */
		packLineNum = (D == table[table.length-2][CHECK_X]) ? 1 : 0;

		/* es폜Ώۂ`FbNȂAl߂ */
		for (int y = table.length-3; y >= 0; y--) {
			/* 폜Ώۂ̍s */
			if (D == table[y][CHECK_X]) {
				/* 폜Ώۂ̍s̏ꍇAl߂郉C1 */
				packLineNum++;
			} else {
				/* 폜ΏۂłȂꍇAysڂpackLineNumsAɋl߂ */
				if (0 != packLineNum) {
					/* 1ubNmɐݒ */
					for (int i = 1; i < table[y].length - 1; i++) {
						table[y + packLineNum][i] = table[y][i];
					}
				}
			}
		}

		/* ŏʂpackLineNums */
		for (int y = 0; y < packLineNum; y++) {
			for (int i = 1; i < table[y].length - 1; i++) {
				table[y][i] = _;
			}
		}
	}
}
