package com.torn.tetoru.sample.console;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

import javax.swing.JFrame;

import com.torn.tetoru.parts.Debug;

@SuppressWarnings("serial")
class MyConsolePlayerClient extends JFrame implements Runnable, TextListener {

	/* ǂݎԊu */
	private static final int READ_WAIT_TIME = 100;

	/* vC[ */
	private MyConsolePlayer player;

	/* eLXgtB[h */
	private TextField textField;

	/* eLXgtB[ǂݎ */
	private String inText;

	MyConsolePlayerClient(MyConsolePlayer player) {
		this.player = player;
		setUndecorated(true); /* ^Cgo[\Ȃ */		
		setBackground(new Color(0, 0, 0, 0)); /* (EBhEĂƃG[) */
		
		setTitle("eg(͗pt[)");
		setSize(new Dimension(100, 100));
		setDefaultCloseOperation(EXIT_ON_CLOSE);
		setLayout(null);
		setVisible(true);

		/* eLXgtB[h */
		textField = new TextField(10) {
			/* CX^Xq */
			{
				setBackground(Color.WHITE);
				setSize(new Dimension(100, 50));
				addTextListener(MyConsolePlayerClient.this);
			}
		};
		add(textField); /* t[ɒadd */

		/*  */
		textField.requestFocus();
		inText = "";

		/* ̂mȂAeLXgtB[hȂ */
		/* SwingAWTǉH */
	}

	public void run() {
		/* Ԋuœǂݎ */
		while (true) {
			readInput();

			/* ǂݎԊu */
			try {
				Thread.sleep(READ_WAIT_TIME);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}


	public void readInput() {
		/******************************/
		/* inText1byte擾 */
		/******************************/
		if (inText.isEmpty()) {
			return;
		}
		byte inCode = (byte)inText.charAt(0);

		/******************************/
		/* ̓ */
		/******************************/
		Debug.println("input : " + inCode);
		/*  */
		inText = "";
		textField.setText(""); /* textValueChangeds */

		/***************************************/
		/* inCodevC[̓͂ɏ */
		/***************************************/
		player.writeInputType(inCode);
	}


	@Override
	public void textValueChanged(TextEvent e) {
		/* ͂ꂽꍇ */
		TextField text = (TextField)e.getSource();
		inText = text.getText();
	}

}
