/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.TextExtraction;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author Banana_King 
 */
public class RecursiveSearch {

	private String _path = "";
	private String _extension = "";
	private List<File> _files = new ArrayList<File>();

	//コンストラクタ
	public RecursiveSearch() {
	}

	//パス付きコンストラクタ
	public RecursiveSearch(String path) throws CustomException {

		this.setPath(path);
	}

	public void setExtension(String extension) {
		_extension = extension;
	}

	public void setPath(String path) throws CustomException {

		File file = new File(path);
		if (!file.isDirectory()) {
			throw new CustomException("指定されたパスはフォルダではない");
		}

		this._path = path;
	}

	public String getPath() {
		return this._path;
	}

	//取得したファイル群を返す
	public List<File> getFiles() {

		return _files;

	}

	public void addFiles(File f) {
		_files.add(f);
	}

	//再帰検索開始
	public void Search() {

		Recursive(getPath());
	}

	//指定のパス直下のファイルを検索し追加
	//ファイルではない場合は、自分自身を呼び出し再帰検索
	private void Recursive(String path) {

		//パスから情報を取得
		File directory1 = new File(path);

		//パス直下のファイルを取得
		File[] files = directory1.listFiles();

		//取得したファイルを繰り返し処理
		for (File file : files) {

			//ファイルなら追加
			if (file.isFile()) {

				//拡張子絞り込みが設定されている場合は指定の拡張のみ追加
				if (_extension != null && _extension.equals("") == false) {
					String[] ext = file.getName().split("\\.");
					if (ext != null && ext.length > 0 && ext[ext.length-1].equals(_extension)) {
						addFiles(file);
					}

					continue;
				}else{
					//拡張子絞り込みの設定がされていない場合は全ファイルを対象とする
					addFiles(file);
				}

			} else {
				//ディレクトリなら再帰検索
				this.Recursive(file.getAbsolutePath());
			}
		}
	}

	//取得したファイル群をファイルパス群として返す
	public String[] toArray() {

		//無いなら空を返す
		if (_files == null || _files.size() < 1) {
			return new String[0];
		}

		String[] paths = new String[_files.size()];

		for (int i = 0; i < paths.length; i++) {
			paths[i] = _files.get(i).getAbsolutePath();
		}

		return paths;
	}
}
