/*
 * Decompiled with CFR 0.152.
 */
package org.mafait.thinknowlogy;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.mafait.thinknowlogy.FileItem;
import org.mafait.thinknowlogy.FileResultType;
import org.mafait.thinknowlogy.GlobalVariables;
import org.mafait.thinknowlogy.List;
import org.mafait.thinknowlogy.WordItem;

class FileList
extends List {
    private static boolean doesFileNameContainExtension(String fileNameString) {
        if (fileNameString != null) {
            int position = fileNameString.length();
            while (position > 0 && fileNameString.charAt(position - 1) != '/' && fileNameString.charAt(position - 1) != '\\') {
                if (fileNameString.charAt(--position) != '.') continue;
                return true;
            }
        }
        return false;
    }

    private FileItem firstActiveFileItem() {
        return (FileItem)this.firstActiveItem();
    }

    private FileResultType createFileItem(boolean isInfoFile, boolean isTestFile, String readFileNameString, String writeFileNameString, BufferedReader readFile, BufferedWriter writeFile) {
        FileResultType fileResult = new FileResultType();
        fileResult.createdFileItem = new FileItem(isInfoFile, isTestFile, readFileNameString, writeFileNameString, readFile, writeFile, this, this.myWordItem());
        if (fileResult.createdFileItem == null) {
            return this.startFileResultError(1, "I failed to create a file item");
        }
        if (this.addItemToList('+', fileResult.createdFileItem) != 1) {
            return this.addFileResultError(1, "I failed to add a file item");
        }
        return fileResult;
    }

    protected FileList(WordItem myWordItem) {
        this.initializeListVariables('F', "FileList", myWordItem);
    }

    protected boolean isCurrentFileTestFile() {
        FileItem currentFileItem = this.firstActiveFileItem();
        return currentFileItem == null ? false : currentFileItem.isTestFile();
    }

    protected boolean isCurrentlyTesting() {
        FileItem searchFileItem = this.firstActiveFileItem();
        while (searchFileItem != null) {
            if (searchFileItem.isTestFile()) {
                return true;
            }
            searchFileItem = searchFileItem.nextFileItem();
        }
        return false;
    }

    protected boolean isDisplayingLine() {
        FileItem searchFileItem = this.firstActiveFileItem();
        while (searchFileItem != null) {
            if (searchFileItem.isInfoFile() || searchFileItem.isTestFile()) {
                return false;
            }
            searchFileItem = searchFileItem.nextFileItem();
        }
        return true;
    }

    protected int currentFileSentenceNr() {
        FileItem currentFileItem = this.firstActiveFileItem();
        return currentFileItem == null ? 0 : currentFileItem.activeSentenceNr();
    }

    protected byte closeCurrentFile(FileItem closeFileItem) {
        FileItem currentFileItem = this.firstActiveFileItem();
        if (currentFileItem == null) {
            return this.startError(1, "There is no file to close");
        }
        if (currentFileItem != closeFileItem) {
            return this.startError(1, "The given file item isn't the current file");
        }
        try {
            if (currentFileItem.readFile() != null) {
                currentFileItem.readFile().close();
                currentFileItem.clearReadFile();
            }
        }
        catch (IOException exception) {
            return this.startError(1, "IOException: I couldn't close read file: \"" + currentFileItem.readFileNameString() + "\"");
        }
        try {
            if (currentFileItem.writeFile() != null) {
                currentFileItem.writeFile().close();
                currentFileItem.clearWriteFile();
            }
        }
        catch (IOException exception) {
            return this.startError(1, "IOException: I couldn't close write file: \"" + currentFileItem.writeFileNameString() + "\"");
        }
        if (this.deleteItem(currentFileItem) != 1) {
            return this.addError(1, "I failed to delete a file item");
        }
        return 1;
    }

    protected BufferedReader currentReadFile() {
        FileItem currentFileItem = this.firstActiveFileItem();
        return currentFileItem != null ? currentFileItem.readFile() : null;
    }

    protected BufferedWriter currentWriteFile() {
        FileItem currentFileItem = this.firstActiveFileItem();
        return currentFileItem != null ? currentFileItem.writeFile() : null;
    }

    protected FileResultType openFile(boolean isAddingSubPath, boolean isInfoFile, boolean isTestFile, boolean isReportingErrorIfFileDoesNotExist, String defaultSubPathString, String fileNameString, String testOutputFileSubPathString, String testReferenceFileSubPathString) {
        FileResultType fileResult;
        block17: {
            BufferedReader readFile = null;
            BufferedWriter writeFile = null;
            StringBuffer readFileNameStringBuffer = new StringBuffer();
            StringBuffer referenceFileNameStringBuffer = new StringBuffer();
            StringBuffer writeFileNameStringBuffer = new StringBuffer();
            fileResult = new FileResultType();
            if (defaultSubPathString == null) {
                return this.startFileResultError(1, "The given default subpath string is undefined");
            }
            if (fileNameString == null) {
                return this.startFileResultError(1, "The given file name string is undefined");
            }
            if (fileNameString.length() == 0) {
                return this.startFileResultError(1, "The copied file name string buffer is empty");
            }
            if (fileNameString.charAt(0) != '/' && fileNameString.charAt(0) != '\\' && fileNameString.indexOf(":") < 0) {
                readFileNameStringBuffer.append(GlobalVariables.currentPathStringBuffer);
                referenceFileNameStringBuffer.append(GlobalVariables.currentPathStringBuffer);
                writeFileNameStringBuffer.append(GlobalVariables.currentPathStringBuffer);
                if (isAddingSubPath && fileNameString.indexOf(defaultSubPathString) < 0) {
                    readFileNameStringBuffer.append(defaultSubPathString);
                    if (testReferenceFileSubPathString != null) {
                        referenceFileNameStringBuffer.append(testReferenceFileSubPathString);
                    }
                    if (testOutputFileSubPathString != null) {
                        writeFileNameStringBuffer.append(testOutputFileSubPathString);
                    }
                }
            }
            readFileNameStringBuffer.append(fileNameString);
            referenceFileNameStringBuffer.append(fileNameString);
            writeFileNameStringBuffer.append(fileNameString);
            if (!FileList.doesFileNameContainExtension(fileNameString)) {
                readFileNameStringBuffer.append(".txt");
                referenceFileNameStringBuffer.append(".txt");
                writeFileNameStringBuffer.append(".txt");
            }
            try {
                readFile = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(readFileNameStringBuffer.toString()), "UTF-8"));
                if (testReferenceFileSubPathString != null) {
                    fileResult.referenceFile = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(referenceFileNameStringBuffer.toString()), "UTF-8"));
                }
                if (testOutputFileSubPathString != null) {
                    writeFile = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(writeFileNameStringBuffer.toString()), "UTF-8"));
                    writeFile.write("\ufeff");
                }
                if (testReferenceFileSubPathString == null) {
                    fileResult = this.createFileItem(isInfoFile, isTestFile, readFileNameStringBuffer.toString(), testOutputFileSubPathString == null ? null : writeFileNameStringBuffer.toString(), readFile, writeFile);
                    if (fileResult.result != 1) {
                        if (fileResult.createdFileItem != null) {
                            this.closeCurrentFile(fileResult.createdFileItem);
                        }
                        return this.addFileResultError(1, "I failed to create a file item");
                    }
                } else {
                    fileResult.outputFile = readFile;
                }
            }
            catch (IOException exception) {
                if (!isReportingErrorIfFileDoesNotExist) break block17;
                if (fileNameString.equals("startup")) {
                    return this.startFileResultError(1, "You are probably trying to start this Java application still being packed in a Zip file.\nYou need to unpack the Zip file to start this Java application");
                }
                return this.startFileResultError(1, "I couldn't open " + (readFile == null ? "file for reading: \"" + readFileNameStringBuffer + "\"" : (testReferenceFileSubPathString != null && fileResult.referenceFile == null ? "reference file for reading: \"" + referenceFileNameStringBuffer + "\"" : (testOutputFileSubPathString == null ? "an unknown file" : " file for writing: \"" + writeFileNameStringBuffer + "\""))));
            }
        }
        return fileResult;
    }
}

