/*
 * Decompiled with CFR 0.152.
 */
package org.mafait.thinknowlogy;

import org.mafait.thinknowlogy.Console;
import org.mafait.thinknowlogy.GlobalVariables;
import org.mafait.thinknowlogy.GrammarItem;
import org.mafait.thinknowlogy.InputOutput;
import org.mafait.thinknowlogy.RelatedResultType;
import org.mafait.thinknowlogy.SpecificationItem;
import org.mafait.thinknowlogy.WordItem;
import org.mafait.thinknowlogy.WriteItem;

class WordWrite {
    private boolean hasFoundAllRelationWords_ = false;
    private boolean hasFoundAllRelationWordsBeforeConjunction_ = false;
    private boolean hasFoundAllSpecificationWords_ = false;
    private boolean hasFoundAllSpecificationWordsBeforeConjunction_ = false;
    private boolean hasFoundWordToWrite_ = false;
    private boolean hasGeneralizationWord_ = false;
    private boolean hasFoundSingleSpecificationWord_ = false;
    private boolean hasFoundSpecificationGeneralizationVerb_ = false;
    private boolean hasFoundSpecificationWord_ = false;
    private boolean isChineseCurrentLanguage_ = false;
    private boolean isSkippingClearWriteLevel_ = false;
    private boolean isSpecificationWaitingForConjunction_ = false;
    private boolean isUnknownPluralOfNoun_ = false;
    private short writeWordTypeNr_ = 0;
    private int generalizationStartWordPosition_ = 0;
    private int specificationStartWordPosition_ = 0;
    private SpecificationItem lastFoundSpecificationItem_ = null;
    private WordItem lastFoundRelationWordItem_ = null;
    private String writeWordString_ = null;
    private String moduleNameString_ = this.getClass().getName();
    private StringBuffer lastSpecificationStringBuffer_ = null;
    private StringBuffer previousSpecificationStringBuffer_ = null;
    private WordItem myWordItem_ = null;

    private void initializeVariables() {
        this.hasFoundAllRelationWords_ = false;
        this.hasFoundAllRelationWordsBeforeConjunction_ = false;
        this.hasFoundAllSpecificationWords_ = false;
        this.hasFoundAllSpecificationWordsBeforeConjunction_ = false;
        this.hasGeneralizationWord_ = false;
        this.hasFoundSingleSpecificationWord_ = false;
        this.hasFoundSpecificationGeneralizationVerb_ = false;
        this.hasFoundSpecificationWord_ = false;
        this.isChineseCurrentLanguage_ = this.myWordItem_.isChineseCurrentLanguage();
        this.isSkippingClearWriteLevel_ = false;
        this.isSpecificationWaitingForConjunction_ = false;
        this.isUnknownPluralOfNoun_ = false;
        this.generalizationStartWordPosition_ = 0;
        this.specificationStartWordPosition_ = 0;
        this.lastFoundSpecificationItem_ = null;
        this.lastFoundRelationWordItem_ = null;
        this.writeWordString_ = null;
        this.lastSpecificationStringBuffer_ = null;
        this.previousSpecificationStringBuffer_ = null;
        GlobalVariables.currentWriteLevel = 0;
        GlobalVariables.writtenSentenceStringBuffer = new StringBuffer();
        this.myWordItem_.deleteTemporaryWriteList();
    }

    private byte checkAssumptionLevel(SpecificationItem writeSpecificationItem) {
        if (writeSpecificationItem == null) {
            return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "The given write specification item is undefined");
        }
        short previousAssumptionLevel = writeSpecificationItem.assumptionLevel();
        if (writeSpecificationItem.calculateAssumptionLevel() != 1) {
            return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to calculate the assumption level of the write specification");
        }
        if (writeSpecificationItem.assumptionLevel() != previousAssumptionLevel && writeSpecificationItem.isOlderItem() && InputOutput.writeDiacriticalText((short)7, "\nThe assumption level of the following specification item has changed during the process, but it isn't recalculated.\nSo, this specification may have a recalculation or update issue.\n\tPrevious assumption level: " + previousAssumptionLevel + ", recalculated assumption level: " + writeSpecificationItem.assumptionLevel() + ";\n\tSpecificationItem: " + writeSpecificationItem.itemToStringBuffer((short)0) + ".\n\n") != 1) {
            return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "I failed to write an interface warning");
        }
        return 1;
    }

    private byte cleanupWriteInfo(boolean isWritingCurrentSpecificationWordOnly, short startWriteLevel, int startWordPosition, SpecificationItem clearSpecificationItem) {
        StringBuffer writtenSentenceStringBuffer = GlobalVariables.writtenSentenceStringBuffer;
        if (writtenSentenceStringBuffer == null || writtenSentenceStringBuffer.length() <= startWordPosition) {
            return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "The given start position is equal or smaller than the size of the write sentence string buffer");
        }
        GlobalVariables.writtenSentenceStringBuffer = new StringBuffer(startWordPosition > 0 ? GlobalVariables.writtenSentenceStringBuffer.substring(0, startWordPosition) : "");
        if (GlobalVariables.currentWriteLevel > startWriteLevel) {
            if (this.clearWriteLevel(isWritingCurrentSpecificationWordOnly, startWriteLevel, clearSpecificationItem) != 1) {
                return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to cleanup the write levels of the write words");
            }
            if (this.generalizationStartWordPosition_ > startWordPosition) {
                this.generalizationStartWordPosition_ = 0;
            }
            if (this.specificationStartWordPosition_ > startWordPosition) {
                this.hasFoundAllSpecificationWordsBeforeConjunction_ = false;
                this.isSpecificationWaitingForConjunction_ = false;
                if (!clearSpecificationItem.isQuestion()) {
                    this.hasFoundSpecificationGeneralizationVerb_ = false;
                }
                this.specificationStartWordPosition_ = 0;
            }
        }
        return 1;
    }

    private byte clearWriteLevel(boolean isWritingCurrentSpecificationWordOnly, short currentWriteLevel, SpecificationItem clearSpecificationItem) {
        boolean isExclusiveSpecification = false;
        boolean isNegative = false;
        boolean isPossessive = false;
        boolean isSelfGenerated = false;
        if (clearSpecificationItem == null) {
            return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "The given clear specification item is undefined");
        }
        if (GlobalVariables.currentWriteLevel < currentWriteLevel) {
            return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "The given current write level of this wordf is higher than the global current write level");
        }
        this.myWordItem_.clearGeneralizationWriteLevel(currentWriteLevel);
        WordItem currentSpecificationWordItem = clearSpecificationItem.specificationWordItem();
        if (currentSpecificationWordItem != null) {
            currentSpecificationWordItem.clearSpecificationWriteLevel(currentWriteLevel);
            int relationContextNr = clearSpecificationItem.relationContextNr();
            if (relationContextNr == 0) {
                SpecificationItem currentSpecificationItem;
                int specificationCollectionNr;
                if (!isWritingCurrentSpecificationWordOnly && (specificationCollectionNr = clearSpecificationItem.specificationCollectionNr()) > 0 && (currentSpecificationItem = this.myWordItem_.firstSpecificationItem(false, clearSpecificationItem.isAssignment(), clearSpecificationItem.isInactiveAssignment(), clearSpecificationItem.isArchivedAssignment(), clearSpecificationItem.questionParameter())) != null) {
                    isExclusiveSpecification = clearSpecificationItem.isExclusiveSpecification();
                    isNegative = clearSpecificationItem.isNegative();
                    isPossessive = clearSpecificationItem.isPossessive();
                    isSelfGenerated = clearSpecificationItem.isSelfGenerated();
                    short assumptionLevel = clearSpecificationItem.assumptionLevel();
                    int generalizationContextNr = clearSpecificationItem.generalizationContextNr();
                    do {
                        if (currentSpecificationItem == clearSpecificationItem || (currentSpecificationWordItem = currentSpecificationItem.relatedSpecificationWordItem(isExclusiveSpecification, isNegative, isPossessive, isSelfGenerated, assumptionLevel, (short)0, specificationCollectionNr, generalizationContextNr, relationContextNr)) == null) continue;
                        currentSpecificationWordItem.clearSpecificationWriteLevel(currentWriteLevel);
                    } while ((currentSpecificationItem = currentSpecificationItem.nextSelectedQuestionParameterSpecificationItem()) != null);
                }
            } else {
                WordItem currentContextWordItem = GlobalVariables.firstContextWordItem;
                if (currentContextWordItem != null) {
                    if (currentWriteLevel == 0) {
                        this.hasFoundAllRelationWords_ = false;
                        this.hasFoundAllRelationWordsBeforeConjunction_ = false;
                    }
                    do {
                        currentContextWordItem.clearRelationWriteLevel(currentWriteLevel, relationContextNr);
                    } while ((currentContextWordItem = currentContextWordItem.nextContextWordItem) != null);
                }
            }
        }
        return 1;
    }

    private byte writeGeneralizationWordToSentence(boolean isPluralSpecificationGeneralization, short grammarDefinitionWordTypeNr) {
        int writeWordTypeNr = grammarDefinitionWordTypeNr;
        this.hasGeneralizationWord_ = false;
        this.isUnknownPluralOfNoun_ = false;
        this.writeWordString_ = this.myWordItem_.activeWordTypeString((short)(isPluralSpecificationGeneralization && !this.isChineseCurrentLanguage_ ? 12 : grammarDefinitionWordTypeNr));
        if (this.writeWordString_ == null && (this.writeWordString_ = this.myWordItem_.singularNounString()) != null) {
            if (!this.isChineseCurrentLanguage_) {
                this.isUnknownPluralOfNoun_ = true;
            }
            writeWordTypeNr = 11;
        }
        if (this.writeWordString_ != null) {
            if (this.myWordItem_.markGeneralizationWordTypeAsWritten((short)writeWordTypeNr) != 1) {
                return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to mark a word type of a generalization word as written");
            }
            this.hasGeneralizationWord_ = true;
        }
        return 1;
    }

    private byte writeCurrentSpecificationWordToSentence(boolean isPossessive, short grammarDefinitionWordTypeNr, short specificationWordTypeNr, int relationContextNr, SpecificationItem writeSpecificationItem, WordItem specificationWordItem) {
        boolean hasFoundNumberOfRelations = false;
        boolean isWordTypeNumeral = grammarDefinitionWordTypeNr == 2;
        boolean isWordTypePluralNoun = grammarDefinitionWordTypeNr == 12;
        int nContextRelations = 0;
        if (writeSpecificationItem == null) {
            return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "The given write specification item is undefined");
        }
        if (specificationWordItem == null) {
            return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "The given specification word item is undefined");
        }
        if (isPossessive && (nContextRelations = writeSpecificationItem.nContextRelations()) == 0) {
            nContextRelations = this.myWordItem_.nContextWords(relationContextNr, specificationWordItem);
        }
        if ((nContextRelations == 0 || nContextRelations == 1) && grammarDefinitionWordTypeNr == specificationWordTypeNr || nContextRelations > 1 && (isWordTypeNumeral || isWordTypePluralNoun)) {
            String specificationWordString = specificationWordItem.activeWordTypeString(grammarDefinitionWordTypeNr);
            if (specificationWordString == null) {
                if (isWordTypeNumeral) {
                    if (!this.isChineseCurrentLanguage_ || relationContextNr == 0) {
                        hasFoundNumberOfRelations = true;
                        this.writeWordString_ = "" + nContextRelations;
                    }
                } else if (isWordTypePluralNoun) {
                    this.writeWordString_ = specificationWordItem.singularNounString();
                    if (this.writeWordString_ != null) {
                        if (!this.isChineseCurrentLanguage_) {
                            this.isUnknownPluralOfNoun_ = true;
                        }
                        this.writeWordTypeNr_ = (short)11;
                    }
                } else {
                    this.writeWordString_ = specificationWordItem.anyWordTypeString();
                }
            } else {
                this.writeWordString_ = specificationWordString;
            }
            if (!hasFoundNumberOfRelations && this.writeWordString_ != null) {
                if (specificationWordItem.markSpecificationWordTypeAsWritten(this.writeWordTypeNr_) != 1) {
                    return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to mark specification word \"" + specificationWordItem.anyWordTypeString() + "\" as written");
                }
                this.hasFoundSpecificationWord_ = true;
                this.lastFoundSpecificationItem_ = writeSpecificationItem;
                if (this.isChineseCurrentLanguage_ && writeSpecificationItem.isUncountableGeneralizationNoun()) {
                    this.hasFoundAllSpecificationWordsBeforeConjunction_ = true;
                }
                if (this.hasFoundAllSpecificationWordsBeforeConjunction_) {
                    this.hasFoundAllSpecificationWords_ = true;
                    this.isSkippingClearWriteLevel_ = false;
                }
            }
        }
        return 1;
    }

    private byte writeSpecificationWordToSentence(boolean isAssignment, boolean isInactiveAssignment, boolean isArchivedAssignment, boolean isExclusiveSpecification, boolean isNegative, boolean isPossessive, boolean isSelfGenerated, boolean isSpecificationGeneralization, boolean isWritingCurrentSpecificationWordOnly, short assumptionLevel, short grammarDefinitionWordTypeNr, short questionParameter, short specificationWordTypeNr, int specificationCollectionNr, int generalizationContextNr, int relationContextNr, SpecificationItem writeSpecificationItem, WordItem specificationWordItem) {
        boolean hasSkippedDifferentSpecification = false;
        this.hasFoundSingleSpecificationWord_ = false;
        this.isUnknownPluralOfNoun_ = false;
        this.writeWordTypeNr_ = grammarDefinitionWordTypeNr;
        this.writeWordString_ = null;
        if (writeSpecificationItem == null) {
            return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "The given write specification item is undefined");
        }
        if (specificationWordItem == null) {
            return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "The given specification word item is undefined");
        }
        if (isWritingCurrentSpecificationWordOnly) {
            if (!specificationWordItem.isSpecificationWordTypeAlreadyWritten(specificationWordTypeNr) && this.writeCurrentSpecificationWordToSentence(isPossessive, grammarDefinitionWordTypeNr, specificationWordTypeNr, relationContextNr, writeSpecificationItem, specificationWordItem) != 1) {
                return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to write a specification word only to the sentence");
            }
        } else {
            boolean isAnsweredQuestion = writeSpecificationItem.isAnsweredQuestion();
            SpecificationItem currentSpecificationItem = this.myWordItem_.firstSpecificationItem(isAnsweredQuestion, isAssignment, isInactiveAssignment, isArchivedAssignment, questionParameter);
            if (currentSpecificationItem != null) {
                do {
                    WordItem currentSpecificationWordItem;
                    if (currentSpecificationItem != writeSpecificationItem && currentSpecificationItem.relatedSpecificationWordItem(isExclusiveSpecification, isNegative, isPossessive, isSelfGenerated, assumptionLevel, (short)0, specificationCollectionNr, generalizationContextNr, relationContextNr) == null || (currentSpecificationWordItem = currentSpecificationItem.specificationWordItem()) == null) continue;
                    short currentSpecificationWordTypeNr = currentSpecificationItem.specificationWordTypeNr();
                    if (currentSpecificationWordItem.isSpecificationWordTypeAlreadyWritten(currentSpecificationWordTypeNr)) {
                        if (currentSpecificationItem == writeSpecificationItem) continue;
                        hasSkippedDifferentSpecification = true;
                        continue;
                    }
                    if (this.writeCurrentSpecificationWordToSentence(isPossessive, grammarDefinitionWordTypeNr, currentSpecificationWordTypeNr, relationContextNr, currentSpecificationItem, currentSpecificationWordItem) == 1) continue;
                    return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to write the current specification word to the sentence");
                } while (this.writeWordString_ == null && (currentSpecificationItem = currentSpecificationItem.nextSelectedQuestionParameterSpecificationItem(isAnsweredQuestion)) != null);
            }
        }
        if (!(this.hasFoundSpecificationWord_ || this.hasFoundAllSpecificationWords_ || this.hasFoundAllSpecificationWordsBeforeConjunction_ || this.lastFoundSpecificationItem_ == null || this.lastFoundSpecificationItem_.specificationWordTypeNr() != grammarDefinitionWordTypeNr)) {
            if (hasSkippedDifferentSpecification) {
                if (this.previousSpecificationStringBuffer_ != null && this.previousSpecificationStringBuffer_.length() > 0) {
                    this.hasFoundAllSpecificationWordsBeforeConjunction_ = true;
                    this.isSpecificationWaitingForConjunction_ = true;
                    if (!isSpecificationGeneralization) {
                        this.isSkippingClearWriteLevel_ = true;
                    }
                    GlobalVariables.writtenSentenceStringBuffer = this.previousSpecificationStringBuffer_;
                    WordItem lastFoundSpecificationWordItem = this.lastFoundSpecificationItem_.specificationWordItem();
                    if (lastFoundSpecificationWordItem != null) {
                        lastFoundSpecificationWordItem.clearSpecificationWriteLevel((short)0);
                    }
                }
            } else if (isSpecificationGeneralization) {
                this.hasFoundAllSpecificationWords_ = true;
                this.hasFoundSingleSpecificationWord_ = true;
            }
        }
        return 1;
    }

    private byte writeRelationWordToSentence(short grammarDefinitionWordTypeNr, SpecificationItem writeSpecificationItem) {
        this.writeWordString_ = null;
        if (writeSpecificationItem == null) {
            return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "The given write specification item is undefined");
        }
        WordItem firstUnwrittenRelationWordItem = writeSpecificationItem.firstUnwrittenRelationWordItem(grammarDefinitionWordTypeNr, null);
        if (firstUnwrittenRelationWordItem == null) {
            this.hasFoundAllRelationWords_ = true;
            this.hasFoundAllRelationWordsBeforeConjunction_ = true;
        } else {
            this.writeWordString_ = firstUnwrittenRelationWordItem.activeWordTypeString(grammarDefinitionWordTypeNr);
            if (this.writeWordString_ == null) {
                return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "Relation context word \"" + firstUnwrittenRelationWordItem.anyWordTypeString() + "\" doesn't have the requested word type");
            }
            if (firstUnwrittenRelationWordItem.markRelationWordTypeAsWritten(grammarDefinitionWordTypeNr) != 1) {
                return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to mark relation context word \"" + firstUnwrittenRelationWordItem.anyWordTypeString() + "\" as written");
            }
            if (this.hasFoundAllRelationWordsBeforeConjunction_) {
                this.hasFoundAllRelationWords_ = true;
            }
            if (this.lastFoundRelationWordItem_ != null && this.lastFoundRelationWordItem_ != firstUnwrittenRelationWordItem && writeSpecificationItem.firstUnwrittenRelationWordItem(grammarDefinitionWordTypeNr, firstUnwrittenRelationWordItem) == null) {
                this.hasFoundAllRelationWordsBeforeConjunction_ = true;
                this.writeWordString_ = null;
            }
        }
        this.lastFoundRelationWordItem_ = firstUnwrittenRelationWordItem;
        return 1;
    }

    private byte writeWordToSentence(boolean isWritingCurrentSpecificationWordOnly, short answerParameter, GrammarItem definitionGrammarItem, SpecificationItem writeSpecificationItem) {
        WordItem predefinedWordItem;
        boolean isChineseCurrentLanguage = this.isChineseCurrentLanguage_;
        boolean isInsertingSeparator = !isChineseCurrentLanguage;
        int pronounContextNr = 0;
        String predefinedWordString = null;
        this.hasGeneralizationWord_ = false;
        this.hasFoundSpecificationWord_ = false;
        this.isUnknownPluralOfNoun_ = false;
        this.writeWordTypeNr_ = 0;
        this.writeWordString_ = null;
        if (definitionGrammarItem == null) {
            return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "The given definition grammar item is undefined");
        }
        short grammarDefinitionWordTypeNr = definitionGrammarItem.grammarWordTypeNr();
        if (grammarDefinitionWordTypeNr <= 0) {
            return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "The given grammar definition has no word type");
        }
        if (writeSpecificationItem == null) {
            return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "The given write specification item is undefined");
        }
        boolean hasRelationContext = writeSpecificationItem.hasRelationContext();
        boolean isAssignment = writeSpecificationItem.isAssignment();
        boolean isActiveAssignment = writeSpecificationItem.isActiveAssignment();
        boolean isArchivedAssignment = writeSpecificationItem.isArchivedAssignment();
        boolean isCharacteristicFor = writeSpecificationItem.isCharacteristicFor();
        boolean isConditional = writeSpecificationItem.isConditional();
        boolean isEveryGeneralization = writeSpecificationItem.isEveryGeneralization();
        boolean isExclusiveSpecification = writeSpecificationItem.isExclusiveSpecification();
        boolean isGeneralizationNoun = writeSpecificationItem.isGeneralizationNoun();
        boolean isGeneralizationProperNoun = writeSpecificationItem.isGeneralizationProperNoun();
        boolean isInactiveAssignment = writeSpecificationItem.isInactiveAssignment();
        boolean isNegative = writeSpecificationItem.isNegative();
        boolean isPartOf = writeSpecificationItem.isPartOf();
        boolean isPossessive = writeSpecificationItem.isPossessive();
        boolean isQuestion = writeSpecificationItem.isQuestion();
        boolean isSelfGenerated = writeSpecificationItem.isSelfGenerated();
        boolean isSelfGeneratedAssumption = writeSpecificationItem.isSelfGeneratedAssumption();
        boolean isSelfGeneratedQuestion = writeSpecificationItem.isSelfGeneratedQuestion();
        boolean isSpecificationGeneralization = writeSpecificationItem.isSpecificationGeneralization();
        boolean isSpecificationNoun = writeSpecificationItem.isSpecificationNoun();
        boolean isSpecificationPluralNoun = writeSpecificationItem.isSpecificationPluralNoun();
        boolean isUncountableGeneralizationNoun = writeSpecificationItem.isUncountableGeneralizationNoun();
        boolean isUniqueUserRelation = writeSpecificationItem.isUniqueUserRelation();
        boolean isGeneralization = this.generalizationStartWordPosition_ == 0 && (!isSpecificationGeneralization || this.hasFoundAllSpecificationWords_ && this.hasFoundSpecificationGeneralizationVerb_);
        boolean isRelation = hasRelationContext && !isGeneralization && (this.specificationStartWordPosition_ > 0 || isChineseCurrentLanguage && !isPossessive && !this.hasFoundAllRelationWords_);
        boolean isSpecification = !isGeneralization && !isRelation;
        short grammarDefinitionParameter = definitionGrammarItem.grammarParameter();
        short assumptionLevel = writeSpecificationItem.assumptionLevel();
        short generalizationWordTypeNr = writeSpecificationItem.generalizationWordTypeNr();
        short prepositionParameter = writeSpecificationItem.prepositionParameter();
        short questionParameter = writeSpecificationItem.questionParameter();
        short specificationWordTypeNr = writeSpecificationItem.specificationWordTypeNr();
        int specificationCollectionNr = writeSpecificationItem.specificationCollectionNr();
        int generalizationContextNr = writeSpecificationItem.generalizationContextNr();
        int specificationContextNr = writeSpecificationItem.specificationContextNr();
        int relationContextNr = writeSpecificationItem.relationContextNr();
        WordItem specificationWordItem = writeSpecificationItem.specificationWordItem();
        if (grammarDefinitionParameter > 0 && (predefinedWordItem = this.myWordItem_.predefinedWordItem(grammarDefinitionParameter)) != null) {
            predefinedWordString = predefinedWordItem.wordTypeString(true, grammarDefinitionWordTypeNr);
        }
        switch (grammarDefinitionParameter) {
            case 100: {
                int nRemainingSpecificationWordsForWriting;
                if (isGeneralization || isRelation && !isUncountableGeneralizationNoun && !this.hasFoundAllRelationWordsBeforeConjunction_ || isSpecification && !this.hasFoundAllSpecificationWordsBeforeConjunction_ && (isWritingCurrentSpecificationWordOnly && isGeneralizationNoun || !isWritingCurrentSpecificationWordOnly && (!isAssignment || isExclusiveSpecification || !isQuestion && !writeSpecificationItem.isExclusiveGeneralization()) && ((nRemainingSpecificationWordsForWriting = this.myWordItem_.nRemainingSpecificationWordsForWriting(isActiveAssignment, isArchivedAssignment, isExclusiveSpecification, isNegative, isPossessive, isSelfGenerated, assumptionLevel, questionParameter, specificationWordTypeNr, specificationCollectionNr, generalizationContextNr, relationContextNr, 0)) > 1 || nRemainingSpecificationWordsForWriting == 0 && !hasRelationContext && !isNegative && !this.hasFoundAllSpecificationWords_ && (isCharacteristicFor || isInactiveAssignment || isSpecificationGeneralization || isQuestion && isExclusiveSpecification || isPossessive && !isSelfGenerated)))) {
                    isInsertingSeparator = false;
                    this.writeWordString_ = predefinedWordString;
                    break;
                }
                if (!isSpecification) break;
                this.hasFoundAllSpecificationWordsBeforeConjunction_ = true;
                break;
            }
            case 101: 
            case 107: {
                isInsertingSeparator = false;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 102: 
            case 106: {
                break;
            }
            case 103: {
                if (!isQuestion) break;
                isInsertingSeparator = false;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 104: {
                if (!isNegative || this.hasFoundAllSpecificationWords_) break;
                this.isSpecificationWaitingForConjunction_ = false;
                this.writeWordString_ = predefinedWordString;
                if (this.hasFoundAllSpecificationWordsBeforeConjunction_ || this.myWordItem_.nRemainingSpecificationWordsForWriting(isActiveAssignment, isArchivedAssignment, false, true, isPossessive, isSelfGenerated, assumptionLevel, questionParameter, specificationWordTypeNr, specificationCollectionNr, generalizationContextNr, relationContextNr, isSelfGenerated ? 0 : writeSpecificationItem.creationSentenceNr()) != 1) break;
                this.hasFoundAllSpecificationWordsBeforeConjunction_ = true;
                break;
            }
            case 105: {
                if (!isQuestion || !isExclusiveSpecification || this.hasFoundAllSpecificationWords_) break;
                this.isSpecificationWaitingForConjunction_ = false;
                this.writeWordString_ = predefinedWordString;
                if (this.myWordItem_.nRemainingSpecificationWordsForWriting(isActiveAssignment, isArchivedAssignment, isExclusiveSpecification, isNegative, isPossessive, isSelfGenerated, assumptionLevel, questionParameter, specificationWordTypeNr, specificationCollectionNr, generalizationContextNr, relationContextNr, isSelfGenerated ? 0 : writeSpecificationItem.creationSentenceNr()) != 1) break;
                this.hasFoundAllSpecificationWordsBeforeConjunction_ = true;
                break;
            }
            case 201: {
                if (!isGeneralizationNoun || isCharacteristicFor || !isEveryGeneralization && !isSpecificationGeneralization) break;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 620: {
                if (!hasRelationContext || isUncountableGeneralizationNoun) break;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 621: {
                WordItem singleRelationWordItem;
                if (!hasRelationContext || (singleRelationWordItem = writeSpecificationItem.singleRelationWordItem()) == null) break;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 622: {
                WordItem singleRelationWordItem;
                if (!hasRelationContext || (singleRelationWordItem = writeSpecificationItem.singleRelationWordItem()) == null || !singleRelationWordItem.isMale() && singleRelationWordItem.hasFeminineProperNounEnding()) break;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 623: {
                if (!isCharacteristicFor) break;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 624: 
            case 625: {
                if (!isActiveAssignment || !writeSpecificationItem.isExclusiveNonPossessiveGeneralizationAssignment()) break;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 627: 
            case 628: {
                if (!isEveryGeneralization || isSelfGeneratedAssumption || !this.myWordItem_.isCorrectAdjective(grammarDefinitionParameter, generalizationWordTypeNr)) break;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 629: 
            case 630: {
                if (!isActiveAssignment || !writeSpecificationItem.hasCurrentActiveSentenceNr() || !writeSpecificationItem.isExclusiveSpecification() && (relationContextNr <= 0 || !this.myWordItem_.hasCurrentlyConfirmedSpecification() || this.myWordItem_.nContextWords(relationContextNr, specificationWordItem) != 1)) break;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 635: 
            case 636: {
                if (!isInactiveAssignment) break;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 637: {
                if (!writeSpecificationItem.isSpecific()) break;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 633: 
            case 707: {
                if (!isNegative) break;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 705: {
                if (!isNegative || isChineseCurrentLanguage && isUniqueUserRelation) break;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 703: 
            case 706: {
                if (!isNegative || !isUniqueUserRelation) break;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 700: {
                if (isSelfGeneratedAssumption) {
                    if (this.checkAssumptionLevel(writeSpecificationItem) != 1) {
                        return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to check the assumption level for 'maybe'");
                    }
                } else if (isSelfGeneratedQuestion) {
                    assumptionLevel = 0;
                }
                if (assumptionLevel < 3) break;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 701: {
                if (isSelfGeneratedAssumption) {
                    if (this.checkAssumptionLevel(writeSpecificationItem) != 1) {
                        return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to check the assumption level for 'possibly'");
                    }
                } else if (isSelfGeneratedQuestion) {
                    assumptionLevel = 0;
                }
                if (assumptionLevel != 2) break;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 702: {
                if (isSelfGeneratedAssumption) {
                    if (this.checkAssumptionLevel(writeSpecificationItem) != 1) {
                        return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to check the assumption level for 'probably'");
                    }
                } else if (isSelfGeneratedQuestion) {
                    assumptionLevel = 0;
                }
                if (assumptionLevel != 1) break;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 800: 
            case 801: {
                if (grammarDefinitionParameter != answerParameter) break;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 900: 
            case 901: 
            case 902: 
            case 903: 
            case 904: 
            case 905: 
            case 906: 
            case 907: {
                if ((!isGeneralization || !isGeneralizationNoun || isUncountableGeneralizationNoun || isChineseCurrentLanguage && (!isEveryGeneralization || isSelfGeneratedAssumption || isSpecificationGeneralization || writeSpecificationItem.isSpecific()) || !this.myWordItem_.isCorrectIndefiniteArticle(grammarDefinitionParameter, generalizationWordTypeNr)) && (!isSpecification || !isSpecificationNoun || isChineseCurrentLanguage && !isGeneralizationProperNoun && (isEveryGeneralization && isPossessive || isSpecificationGeneralization) || isSpecificationPluralNoun && grammarDefinitionParameter == 907 || !writeSpecificationItem.isCorrectSpecificationArticle(false, grammarDefinitionParameter))) break;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 908: 
            case 909: 
            case 910: 
            case 911: 
            case 912: 
            case 913: {
                if ((!isAssignment || isArchivedAssignment && !isUniqueUserRelation || (!isGeneralization || isArchivedAssignment || !isGeneralizationNoun || !this.myWordItem_.isCorrectDefiniteArticle(grammarDefinitionParameter, generalizationWordTypeNr)) && (!isSpecification || !isGeneralizationProperNoun || isChineseCurrentLanguage && hasRelationContext || !writeSpecificationItem.isCorrectSpecificationArticle(true, grammarDefinitionParameter))) && (!isGeneralization || !isGeneralizationProperNoun || !this.myWordItem_.isProperNounPrecededByDefiniteArticle(grammarDefinitionParameter)) && (!isRelation || !writeSpecificationItem.isCorrectArticleOfFirstUnwrittenProperNounRelationWord(grammarDefinitionParameter))) break;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 1000: {
                if (!isInactiveAssignment && !isNegative && (!isSpecification || isExclusiveSpecification || !this.hasFoundAllSpecificationWordsBeforeConjunction_ || this.hasFoundAllSpecificationWords_) && (!isRelation || !this.hasFoundAllRelationWordsBeforeConjunction_ || this.hasFoundAllRelationWords_)) break;
                this.isSpecificationWaitingForConjunction_ = false;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 1001: {
                if (!isExclusiveSpecification || this.hasFoundAllSpecificationWords_) break;
                this.isSpecificationWaitingForConjunction_ = false;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 1005: {
                this.isSpecificationWaitingForConjunction_ = false;
            }
            case 200: 
            case 1004: {
                if (!writeSpecificationItem.isSpecificationWithStaticAmiguity()) break;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 1117: {
                if (!isPartOf) break;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 1118: {
                break;
            }
            case 1119: {
                if (!isQuestion || isExclusiveSpecification) break;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 1300: 
            case 1301: 
            case 1302: 
            case 1303: 
            case 1304: 
            case 1305: 
            case 1700: 
            case 1701: 
            case 1702: 
            case 1703: 
            case 1704: 
            case 1705: 
            case 1706: {
                if (isArchivedAssignment) break;
                if (isGeneralization) {
                    pronounContextNr = generalizationContextNr;
                } else if (isSpecification) {
                    pronounContextNr = specificationContextNr;
                }
                if (pronounContextNr <= 0) break;
                WordItem pronounWordItem = this.myWordItem_.predefinedWordItem(grammarDefinitionParameter);
                if (pronounWordItem == null) {
                    return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "I couldn't find the pronoun word with the definition grammar parameter");
                }
                if (pronounWordItem.contextWordTypeNr(pronounContextNr) != grammarDefinitionWordTypeNr) break;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 2100: 
            case 2101: 
            case 2102: 
            case 2103: 
            case 2104: 
            case 2109: {
                if (prepositionParameter != grammarDefinitionParameter && prepositionParameter != 0) break;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 2105: {
                if (prepositionParameter != grammarDefinitionParameter && !isGeneralizationNoun && isSpecificationPluralNoun || isChineseCurrentLanguage && (!isSpecification || !isGeneralizationNoun && !hasRelationContext)) break;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 2200: 
            case 2300: {
                if (isPossessive && (!isChineseCurrentLanguage || !isUncountableGeneralizationNoun || !this.hasFoundAllSpecificationWords_) || isAssignment && !isActiveAssignment || isSpecificationGeneralization && !isQuestion && !this.hasFoundAllSpecificationWords_ || isConditional) break;
                this.writeWordString_ = predefinedWordString;
                if (isQuestion) {
                    isInsertingSeparator = false;
                }
                if (!isSpecificationGeneralization) break;
                this.hasFoundSpecificationGeneralizationVerb_ = true;
                break;
            }
            case 2201: 
            case 2301: {
                if (isPossessive || !isInactiveAssignment && !isArchivedAssignment) break;
                if (isQuestion) {
                    isInsertingSeparator = false;
                }
                if (isSpecificationGeneralization) {
                    this.hasFoundSpecificationGeneralizationVerb_ = true;
                }
                if (isQuestion || isArchivedAssignment || writeSpecificationItem.hasSpecificationCollection()) {
                    this.writeWordString_ = predefinedWordString;
                    break;
                }
                predefinedWordItem = this.myWordItem_.predefinedWordItem(grammarDefinitionParameter == 2201 ? (short)2200 : 2300);
                if (predefinedWordItem == null) {
                    return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "I couldn't find the predefined word with word parameter " + grammarDefinitionParameter);
                }
                this.writeWordString_ = predefinedWordItem.wordTypeString(true, grammarDefinitionWordTypeNr);
                if (this.writeWordString_ != null) break;
                return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "I couldn't get the word type string from the predefined word with word parameter " + grammarDefinitionParameter);
            }
            case 2202: 
            case 2302: {
                if (!isConditional) break;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 2203: 
            case 2303: {
                if (!isPossessive || isArchivedAssignment) break;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 2204: 
            case 2304: {
                if (!isPossessive || !isArchivedAssignment) break;
                this.writeWordString_ = predefinedWordString;
                break;
            }
            case 2205: 
            case 2206: 
            case 2207: 
            case 2208: 
            case 2209: 
            case 2210: 
            case 2211: 
            case 2212: 
            case 2213: 
            case 2214: 
            case 2215: 
            case 2216: 
            case 2217: {
                break;
            }
            case 0: 
            case 600: 
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 608: 
            case 638: 
            case 1100: 
            case 1101: 
            case 1102: 
            case 1103: 
            case 1104: 
            case 1105: 
            case 1106: 
            case 1107: 
            case 1108: 
            case 1109: 
            case 1110: 
            case 1111: 
            case 1112: 
            case 1113: 
            case 1114: 
            case 1115: 
            case 1116: 
            case 1120: 
            case 1121: 
            case 1122: {
                if (this.isSpecificationWaitingForConjunction_) break;
                if (isGeneralization) {
                    if (generalizationWordTypeNr != grammarDefinitionWordTypeNr || this.writeGeneralizationWordToSentence(isSpecificationGeneralization && !this.hasFoundSingleSpecificationWord_ && !isCharacteristicFor && !isPartOf, grammarDefinitionWordTypeNr) == 1) break;
                    return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to write the generalization word to the sentence");
                }
                if (isSpecification) {
                    if (specificationWordItem == null) {
                        if (grammarDefinitionWordTypeNr != 25 || writeSpecificationItem.isSpecificationStringAlreadyWritten()) break;
                        if (writeSpecificationItem.markSpecificationStringAsWritten() != 1) {
                            return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to mark specification string \"" + writeSpecificationItem.specificationString() + "\" as written");
                        }
                        this.writeWordString_ = new String(String.valueOf('\"') + writeSpecificationItem.specificationString() + '\"');
                        break;
                    }
                    if (specificationWordTypeNr != grammarDefinitionWordTypeNr && grammarDefinitionWordTypeNr != 2 && grammarDefinitionWordTypeNr != 11 && grammarDefinitionWordTypeNr != 12 || this.writeSpecificationWordToSentence(isAssignment, isInactiveAssignment, isArchivedAssignment, isExclusiveSpecification, isNegative, isPossessive, isSelfGenerated, isSpecificationGeneralization, isWritingCurrentSpecificationWordOnly, assumptionLevel, grammarDefinitionWordTypeNr, questionParameter, specificationWordTypeNr, specificationCollectionNr, generalizationContextNr, relationContextNr, writeSpecificationItem, specificationWordItem) == 1) break;
                    return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to write a specification word to the sentence");
                }
                if (this.hasFoundAllRelationWords_ || writeSpecificationItem.relationWordTypeNr() != grammarDefinitionWordTypeNr || this.writeRelationWordToSentence(grammarDefinitionWordTypeNr, writeSpecificationItem) == 1) break;
                return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to write a relation word to the sentence");
            }
            default: {
                return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "I don't know how to handle the grammar definition with grammar parameter: " + grammarDefinitionParameter);
            }
        }
        if (this.writeWordString_ != null) {
            StringBuffer writtenSentenceStringBuffer = GlobalVariables.writtenSentenceStringBuffer;
            if (writtenSentenceStringBuffer == null || writtenSentenceStringBuffer.length() == 0) {
                GlobalVariables.writtenSentenceStringBuffer = new StringBuffer(this.writeWordString_);
            } else {
                this.isSkippingClearWriteLevel_ = false;
                if (isInsertingSeparator) {
                    GlobalVariables.writtenSentenceStringBuffer.append(" ");
                }
                GlobalVariables.writtenSentenceStringBuffer.append(this.writeWordString_);
            }
            writtenSentenceStringBuffer = GlobalVariables.writtenSentenceStringBuffer;
            if (this.isUnknownPluralOfNoun_) {
                writtenSentenceStringBuffer.append(String.valueOf(this.myWordItem_.interfaceString((short)1112)) + this.writeWordString_ + this.myWordItem_.interfaceString((short)1113));
            }
            if (this.hasGeneralizationWord_) {
                this.generalizationStartWordPosition_ = writtenSentenceStringBuffer.length();
            } else if (this.hasFoundSpecificationWord_) {
                this.specificationStartWordPosition_ = writtenSentenceStringBuffer.length();
                this.previousSpecificationStringBuffer_ = this.lastSpecificationStringBuffer_;
                this.lastSpecificationStringBuffer_ = new StringBuffer(writtenSentenceStringBuffer);
            }
        }
        if (this.writeWordString_ != null) {
            this.hasFoundWordToWrite_ = true;
        }
        return 1;
    }

    protected WordWrite(WordItem myWordItem) {
        this.myWordItem_ = myWordItem;
        if (this.myWordItem_ == null) {
            GlobalVariables.result = (byte)-1;
            Console.addError("\nClass:" + this.moduleNameString_ + "\nMethod:\t" + "<init>" + "\nError:\t\tThe given my word item is undefined.\n");
        }
    }

    protected byte writeJustificationSpecification(boolean isWritingCurrentSpecificationWordOnly, SpecificationItem justificationSpecificationItem) {
        if (justificationSpecificationItem == null) {
            return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "The given justification specification item is undefined");
        }
        if (justificationSpecificationItem.isReplacedOrDeletedItem()) {
            return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "The given justification specification item is a replaced or deleted item");
        }
        if (this.writeSelectedSpecification(false, false, true, true, true, false, isWritingCurrentSpecificationWordOnly, (short)0, justificationSpecificationItem) != 1) {
            return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to write a selected specification with justification");
        }
        StringBuffer writtenSentenceStringBuffer = GlobalVariables.writtenSentenceStringBuffer;
        if (writtenSentenceStringBuffer == null || writtenSentenceStringBuffer.length() == 0) {
            return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "I couldn't write the selected specification with justification");
        }
        if (InputOutput.writeText((short)2, writtenSentenceStringBuffer, GlobalVariables.learnedFromUserStringBuffer) != 1) {
            return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to write a justification sentence");
        }
        return 1;
    }

    protected byte writeSelectedRelationInfo(boolean isActiveAssignment, boolean isInactiveAssignment, boolean isArchivedAssignment, boolean isQuestion, WordItem writeWordItem) {
        SpecificationItem currentSpecificationItem = null;
        if (writeWordItem == null) {
            return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "The given write word item is undefined");
        }
        currentSpecificationItem = this.myWordItem_.firstSpecificationItem(isActiveAssignment, isInactiveAssignment, isArchivedAssignment, isQuestion);
        if (currentSpecificationItem != null) {
            do {
                int relationContextNr;
                if ((relationContextNr = currentSpecificationItem.relationContextNr()) <= 0 || !writeWordItem.hasContextInWord(relationContextNr, currentSpecificationItem.specificationWordItem()) || currentSpecificationItem.isHiddenSpanishSpecification()) continue;
                if (this.writeSelectedSpecification(false, false, false, false, false, false, false, (short)0, currentSpecificationItem) != 1) {
                    return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to write a selected specification");
                }
                StringBuffer writtenSentenceStringBuffer = GlobalVariables.writtenSentenceStringBuffer;
                if (writtenSentenceStringBuffer == null || writtenSentenceStringBuffer.length() <= 0) continue;
                if (InputOutput.writeInterfaceText(true, (short)4, isQuestion ? (short)1326 : 1325) != 1) {
                    return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to write a related header");
                }
                if (InputOutput.writeText((short)1, writtenSentenceStringBuffer, GlobalVariables.learnedFromUserStringBuffer) == 1) continue;
                return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to write a sentence");
            } while ((currentSpecificationItem = currentSpecificationItem.nextSelectedSpecificationItem()) != null);
        }
        return 1;
    }

    protected byte writeSelectedSpecification(boolean isAdjustedAssumption, boolean isCheckingUserSentenceForIntegrity, boolean isForcingResponseNotBeingAssignment, boolean isForcingResponseNotBeingFirstSpecification, boolean isJustification, boolean isWritingCurrentSentenceOnly, boolean isWritingCurrentSpecificationWordOnly, short answerParameter, SpecificationItem writeSpecificationItem) {
        boolean hasAssignment = false;
        boolean isCombinedSpecification = false;
        boolean isFirstRelatedSpecification = false;
        boolean isLastCompoundSpecification = false;
        boolean isLastRelatedSpecification = false;
        boolean isNegativeCompoundSpecification = false;
        boolean isSelfGeneratedDefinitionConclusion = false;
        SpecificationItem relatedSpecificationItem = null;
        StringBuffer storedSentenceWithOnlyOneSpecificationStringBuffer = null;
        GlobalVariables.learnedFromUserStringBuffer = new StringBuffer();
        GlobalVariables.writtenSentenceStringBuffer = new StringBuffer();
        if (writeSpecificationItem == null) {
            return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "The given write specification item is undefined");
        }
        if (writeSpecificationItem.isDeletedItem()) {
            return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "The given write specification item is deleted");
        }
        if (writeSpecificationItem.isHiddenSpanishSpecification()) {
            if (InputOutput.writeDiacriticalText((short)7, "\nI can't write a hidden specification:\n\tSpecificationItem: " + writeSpecificationItem.itemToStringBuffer((short)0) + ".\n") != 1) {
                return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "I failed to write an interface warning");
            }
        } else {
            boolean hasRelationContext = writeSpecificationItem.hasRelationContext();
            boolean hasSpecificationCollection = writeSpecificationItem.hasSpecificationCollection();
            boolean hasCompoundSpecificationCollection = writeSpecificationItem.hasCompoundSpecificationCollection();
            boolean isArchivedAssignment = writeSpecificationItem.isArchivedAssignment();
            boolean isAssignment = writeSpecificationItem.isAssignment();
            boolean isExclusiveSpecification = writeSpecificationItem.isExclusiveSpecification();
            boolean isNegative = writeSpecificationItem.isNegative();
            boolean isPossessive = writeSpecificationItem.isPossessive();
            boolean isOlderItem = writeSpecificationItem.isOlderItem();
            boolean isQuestion = writeSpecificationItem.isQuestion();
            boolean isSelfGenerated = writeSpecificationItem.isSelfGenerated();
            boolean isSpecificationGeneralization = writeSpecificationItem.isSpecificationGeneralization();
            boolean isSpecificationPluralNoun = writeSpecificationItem.isSpecificationPluralNoun();
            boolean isUserSpecification = writeSpecificationItem.isUserSpecification();
            int relationContextNr = writeSpecificationItem.relationContextNr();
            WordItem specificationWordItem = writeSpecificationItem.specificationWordItem();
            if (specificationWordItem != null) {
                SpecificationItem foundAssignmentItem;
                if (hasSpecificationCollection && !isWritingCurrentSpecificationWordOnly && answerParameter == 0) {
                    RelatedResultType relatedResult = this.myWordItem_.findRelatedSpecification(true, writeSpecificationItem);
                    if (relatedResult.result != 1) {
                        return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to find a related specification");
                    }
                    isFirstRelatedSpecification = relatedResult.isFirstRelatedSpecification;
                    isLastRelatedSpecification = relatedResult.isLastRelatedSpecification;
                    relatedSpecificationItem = relatedResult.relatedSpecificationItem;
                    if (relatedSpecificationItem != null && relatedSpecificationItem.isOlderItem()) {
                        if (hasCompoundSpecificationCollection) {
                            if (isNegative && !isOlderItem && (this.myWordItem_.isSpanishCurrentLanguage() || !relatedSpecificationItem.isConcludedAssumption() && !relatedSpecificationItem.hasSpecificationBeenWrittenAsAdjustedNegativeAssumption())) {
                                isNegativeCompoundSpecification = true;
                            }
                        } else if (isWritingCurrentSentenceOnly && (!isSpecificationGeneralization || isLastRelatedSpecification)) {
                            isCombinedSpecification = true;
                        }
                    }
                }
                if (!isAssignment && (foundAssignmentItem = this.myWordItem_.firstAssignmentItem(isPossessive, writeSpecificationItem.isQuestion(), relationContextNr, specificationWordItem)) != null && (foundAssignmentItem.hasRelationContext() || !foundAssignmentItem.isArchivedAssignment() || foundAssignmentItem.isSelfGenerated())) {
                    hasAssignment = true;
                }
                if (hasCompoundSpecificationCollection && !isFirstRelatedSpecification && isLastRelatedSpecification) {
                    isLastCompoundSpecification = true;
                }
                if (!isSpecificationGeneralization && writeSpecificationItem.isGeneralizationNoun() && writeSpecificationItem.isSelfGeneratedConclusion()) {
                    isSelfGeneratedDefinitionConclusion = true;
                }
            }
            if (isCombinedSpecification || isSelfGeneratedDefinitionConclusion && (isLastCompoundSpecification || isForcingResponseNotBeingFirstSpecification || !hasCompoundSpecificationCollection && isFirstRelatedSpecification || !isExclusiveSpecification && !isSpecificationPluralNoun && (!isPossessive || !this.isChineseCurrentLanguage_ || GlobalVariables.nUserSpecificationWords == 1)) || !isSelfGeneratedDefinitionConclusion && (isForcingResponseNotBeingAssignment || writeSpecificationItem.isConditional() || writeSpecificationItem.isCorrectedAssumption() || !hasAssignment && (hasRelationContext || !isArchivedAssignment || isSelfGenerated)) && (isNegativeCompoundSpecification || isFirstRelatedSpecification || isForcingResponseNotBeingFirstSpecification || relatedSpecificationItem == null || !isAdjustedAssumption && isNegative && writeSpecificationItem.assumptionLevel() != relatedSpecificationItem.assumptionLevel())) {
                StringBuffer writtenSentenceStringBuffer;
                boolean isWritingSentenceWithOnlyOneSpecification = isWritingCurrentSpecificationWordOnly && (storedSentenceWithOnlyOneSpecificationStringBuffer = writeSpecificationItem.storedSentenceWithOnlyOneSpecificationStringBuffer()) != null;
                StringBuffer storedSentenceStringBuffer = writeSpecificationItem.storedSentenceStringBuffer();
                if (storedSentenceStringBuffer != null && answerParameter == 0 && (isQuestion || isWritingSentenceWithOnlyOneSpecification || !hasRelationContext && (isExclusiveSpecification || isSelfGenerated && (!hasSpecificationCollection || (!isJustification || isArchivedAssignment) && !isSpecificationGeneralization && !isSpecificationPluralNoun) || isUserSpecification && (!hasCompoundSpecificationCollection || !isWritingCurrentSpecificationWordOnly) || !isSpecificationPluralNoun && !this.myWordItem_.hasMultipleSpecificationWordsWithSameSentenceNr(writeSpecificationItem.creationSentenceNr(), writeSpecificationItem.itemNr(), writeSpecificationItem.specificationCollectionNr())) || hasRelationContext && !writeSpecificationItem.hasRelationContextCurrentlyBeenUpdated())) {
                    if (isCheckingUserSentenceForIntegrity) {
                        GlobalVariables.writtenUserSentenceStringBuffer = storedSentenceStringBuffer;
                    }
                    GlobalVariables.writtenSentenceStringBuffer = isWritingSentenceWithOnlyOneSpecification ? storedSentenceWithOnlyOneSpecificationStringBuffer : storedSentenceStringBuffer;
                } else if (!(!isOlderItem || isQuestion && hasCompoundSpecificationCollection && isSelfGenerated || relatedSpecificationItem == null || (storedSentenceStringBuffer = relatedSpecificationItem.storedSentenceStringBuffer()) == null)) {
                    GlobalVariables.writtenSentenceStringBuffer = new StringBuffer(storedSentenceStringBuffer);
                } else {
                    if (this.writeSpecificationSentence(isAssignment, isArchivedAssignment, isCheckingUserSentenceForIntegrity, isPossessive, isQuestion, isSpecificationGeneralization, isWritingCurrentSpecificationWordOnly, answerParameter, (short)0, this.myWordItem_.firstCurrentLanguageWritingGrammarItem(isQuestion), writeSpecificationItem) != 1) {
                        return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to write a specification sentence");
                    }
                    if (answerParameter == 0 && (writtenSentenceStringBuffer = GlobalVariables.writtenSentenceStringBuffer) != null && writtenSentenceStringBuffer.length() > 0) {
                        if (isWritingCurrentSpecificationWordOnly) {
                            writeSpecificationItem.storedWrittenSentenceStringBufferWithOneSpecificationOnly();
                        } else if (!(hasCompoundSpecificationCollection && isNegative && !isUserSpecification || isExclusiveSpecification && !isOlderItem && hasRelationContext && isAssignment && !writeSpecificationItem.isInactiveAssignment())) {
                            writeSpecificationItem.storeWrittenSentenceStringBuffer();
                        }
                    }
                }
                if (writeSpecificationItem.userNr() != GlobalVariables.currentUserNr && (writtenSentenceStringBuffer = GlobalVariables.writtenSentenceStringBuffer) != null && writtenSentenceStringBuffer.length() > 0) {
                    GlobalVariables.learnedFromUserStringBuffer = new StringBuffer(String.valueOf(this.myWordItem_.interfaceString((short)1355)) + this.myWordItem_.userNameString(writeSpecificationItem.userNr()) + this.myWordItem_.interfaceString((short)1356));
                }
            }
        }
        return 1;
    }

    protected byte writeSelectedSpecificationInfo(boolean isAssignment, boolean isInactiveAssignment, boolean isArchivedAssignment, WordItem writeWordItem) {
        if (writeWordItem == null) {
            return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "The given write word item is undefined");
        }
        SpecificationItem currentSpecificationItem = this.myWordItem_.firstSpecificationItem(isAssignment, isInactiveAssignment, isArchivedAssignment, false);
        if (currentSpecificationItem != null) {
            do {
                if (currentSpecificationItem.specificationWordItem() != writeWordItem) continue;
                if (this.writeSelectedSpecification(false, false, false, false, false, false, false, (short)0, currentSpecificationItem) != 1) {
                    return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to write a selected specification");
                }
                StringBuffer writtenSentenceStringBuffer = GlobalVariables.writtenSentenceStringBuffer;
                if (writtenSentenceStringBuffer == null || writtenSentenceStringBuffer.length() <= 0) continue;
                if (InputOutput.writeInterfaceText(true, (short)1, (short)1324) != 1) {
                    return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to write a related header");
                }
                if (InputOutput.writeText((short)1, writtenSentenceStringBuffer, GlobalVariables.learnedFromUserStringBuffer) == 1) continue;
                return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to write a sentence");
            } while ((currentSpecificationItem = currentSpecificationItem.nextSelectedSpecificationItem()) != null);
        }
        return 1;
    }

    protected byte writeSpecificationSentence(boolean isAssignment, boolean isArchivedAssignment, boolean isCheckingUserSentenceForIntegrity, boolean isPossessive, boolean isQuestion, boolean isSpecificationGeneralization, boolean isWritingCurrentSpecificationWordOnly, short answerParameter, short grammarLevel, GrammarItem selectedGrammarItem, SpecificationItem writeSpecificationItem) {
        StringBuffer writtenSentenceStringBuffer;
        boolean isChineseCurrentLanguage = this.isChineseCurrentLanguage_;
        short startWriteLevel = GlobalVariables.currentWriteLevel;
        int startWordPosition = GlobalVariables.writtenSentenceStringBuffer == null ? 0 : GlobalVariables.writtenSentenceStringBuffer.length();
        GrammarItem definitionGrammarItem = selectedGrammarItem;
        WriteItem currentWriteItem = null;
        this.hasFoundWordToWrite_ = false;
        if (grammarLevel >= 50) {
            return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "The given grammar level is too high: #" + grammarLevel);
        }
        if (selectedGrammarItem == null) {
            return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "The given selected grammar item is undefined");
        }
        if (writeSpecificationItem == null) {
            return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "The given write specification item is undefined");
        }
        if (writeSpecificationItem.isDeletedItem()) {
            return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "The given write specification item is deleted");
        }
        if (grammarLevel == 0) {
            this.initializeVariables();
        }
        do {
            if (!definitionGrammarItem.isDefinitionStart()) {
                return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "The grammar definition word item isn't a definition start");
            }
            if (definitionGrammarItem.isNewStart()) {
                if (this.writeWordToSentence(isWritingCurrentSpecificationWordOnly, answerParameter, definitionGrammarItem, writeSpecificationItem) != 1) {
                    return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to write a word to a sentence");
                }
            } else if (definitionGrammarItem.isUsefulGrammarDefinition(isAssignment, isArchivedAssignment, isChineseCurrentLanguage, isPossessive, isQuestion, isSpecificationGeneralization)) {
                selectedGrammarItem = definitionGrammarItem.nextGrammarItem();
                if (selectedGrammarItem == null) {
                    return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "The grammar word item is undefined");
                }
                boolean isChoice = false;
                boolean isOption = false;
                boolean isStillSuccessful = true;
                boolean isSkippingThisChoiceOrOptionPart = false;
                boolean isSkippingNextChoiceOrOptionParts = false;
                do {
                    if (selectedGrammarItem.isNewStart() && (isChoice || isOption || selectedGrammarItem.isChoiceStart() || selectedGrammarItem.isOptionStart())) {
                        currentWriteItem = this.myWordItem_.firstActiveWriteItem();
                        while (currentWriteItem != null && (currentWriteItem.grammarLevel() != grammarLevel || currentWriteItem.startOfChoiceOrOptionGrammarItem() != selectedGrammarItem)) {
                            currentWriteItem = currentWriteItem.nextWriteItem();
                        }
                        if (isChoice || isOption) {
                            isSkippingThisChoiceOrOptionPart = false;
                            if (this.hasFoundWordToWrite_) {
                                isSkippingNextChoiceOrOptionParts = true;
                            } else if (isStillSuccessful && currentWriteItem != null && currentWriteItem.isSkipped) {
                                currentWriteItem.isSkipped = false;
                            }
                            if (currentWriteItem == null) {
                                if (this.myWordItem_.createWriteWord(!isStillSuccessful || isSkippingNextChoiceOrOptionParts, grammarLevel, selectedGrammarItem) != 1) {
                                    return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to create a write word");
                                }
                            } else {
                                if (currentWriteItem.startOfChoiceOrOptionGrammarItem().activeSentenceNr() != selectedGrammarItem.activeSentenceNr() || currentWriteItem.startOfChoiceOrOptionGrammarItem().itemNr() != selectedGrammarItem.itemNr()) {
                                    return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "I lost track of the selected grammar path");
                                }
                                if (currentWriteItem.grammarLevel() != grammarLevel) {
                                    return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "I lost track of the grammar level");
                                }
                                currentWriteItem = currentWriteItem.nextWriteItem();
                            }
                        } else {
                            if (selectedGrammarItem.isChoiceStart()) {
                                isChoice = true;
                            } else {
                                isOption = true;
                            }
                            isSkippingThisChoiceOrOptionPart = false;
                            if (currentWriteItem == null) {
                                if (this.myWordItem_.createWriteWord(!isStillSuccessful, grammarLevel, selectedGrammarItem) != 1) {
                                    return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to create a start write word");
                                }
                            } else {
                                if (currentWriteItem.startOfChoiceOrOptionGrammarItem().activeSentenceNr() != selectedGrammarItem.activeSentenceNr() || currentWriteItem.startOfChoiceOrOptionGrammarItem().itemNr() != selectedGrammarItem.itemNr()) {
                                    return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "I lost track of the selected grammar path at the start of a choice or option");
                                }
                                if (currentWriteItem.grammarLevel() != grammarLevel) {
                                    return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "I lost track of the grammar level at the start of a choice or option");
                                }
                            }
                        }
                    }
                    if (isStillSuccessful && !isSkippingThisChoiceOrOptionPart && !isSkippingNextChoiceOrOptionParts && !selectedGrammarItem.isSkipOptionForWriting()) {
                        if (grammarLevel + 1 >= 50) {
                            return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "There is probably an endless loop in the grammar definitions, because the grammar level reached: #" + (grammarLevel + 1));
                        }
                        if (this.writeSpecificationSentence(isAssignment, isArchivedAssignment, false, isPossessive, isQuestion, isSpecificationGeneralization, isWritingCurrentSpecificationWordOnly, answerParameter, (short)(grammarLevel + 1), selectedGrammarItem.definitionGrammarItem, writeSpecificationItem) != 1) {
                            return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to write a specification sentence at grammar level: " + (grammarLevel + 1));
                        }
                        if (!this.hasFoundWordToWrite_) {
                            isSkippingThisChoiceOrOptionPart = true;
                        }
                    }
                    if (selectedGrammarItem.isChoiceEnd || selectedGrammarItem.isOptionEnd) {
                        isSkippingThisChoiceOrOptionPart = false;
                        isSkippingNextChoiceOrOptionParts = false;
                        if (selectedGrammarItem.isChoiceEnd) {
                            isChoice = false;
                        } else {
                            isOption = false;
                            if (isStillSuccessful) {
                                this.hasFoundWordToWrite_ = true;
                            }
                        }
                    }
                    selectedGrammarItem = selectedGrammarItem.nextGrammarItem();
                    if (isChoice || isOption || this.hasFoundWordToWrite_) continue;
                    isStillSuccessful = false;
                } while (!selectedGrammarItem.isDefinitionStart());
                if (!this.hasFoundWordToWrite_ && !this.isSkippingClearWriteLevel_ && (writtenSentenceStringBuffer = GlobalVariables.writtenSentenceStringBuffer) != null && writtenSentenceStringBuffer.length() > startWordPosition && this.cleanupWriteInfo(isWritingCurrentSpecificationWordOnly, startWriteLevel, startWordPosition, writeSpecificationItem) != 1) {
                    return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to cleanup the write info");
                }
            }
            definitionGrammarItem = definitionGrammarItem.nextDefinitionGrammarItem;
        } while (!this.hasFoundWordToWrite_ && definitionGrammarItem != null);
        if (grammarLevel == 0) {
            this.myWordItem_.deleteTemporaryWriteList();
            if (this.clearWriteLevel(isWritingCurrentSpecificationWordOnly, (short)0, writeSpecificationItem) != 1) {
                return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to clear the write word levels in all words");
            }
            writtenSentenceStringBuffer = GlobalVariables.writtenSentenceStringBuffer;
            if (writtenSentenceStringBuffer != null && writtenSentenceStringBuffer.length() > 0) {
                if (isCheckingUserSentenceForIntegrity) {
                    GlobalVariables.writtenUserSentenceStringBuffer = GlobalVariables.writtenSentenceStringBuffer;
                }
                if (this.myWordItem_.shrinkMergedWordsInWriteSentenceOfCurrentLanguage() != 1) {
                    return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to shrink the merged words in the write sentence string");
                }
            }
        }
        return 1;
    }

    protected byte writeUpdatedSpecification(boolean isAdjustedSpecification, boolean isCorrectedAssumptionByKnowledge, boolean isCorrectedAssumptionByOppositeSuggestiveQuestion, boolean isReplacedBySpecificationWithRelation, boolean wasHiddenSpanishSpecification, SpecificationItem writeSpecificationItem) {
        if (writeSpecificationItem == null) {
            return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "The given write specification item is undefined");
        }
        boolean isExclusiveSpecification = writeSpecificationItem.isExclusiveSpecification();
        if (this.writeSelectedSpecification(true, false, true, isExclusiveSpecification, false, false, false, (short)0, writeSpecificationItem) != 1) {
            return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to write the given specification item");
        }
        StringBuffer writtenSentenceStringBuffer = GlobalVariables.writtenSentenceStringBuffer;
        if (writtenSentenceStringBuffer != null && writtenSentenceStringBuffer.length() > 0) {
            int interfaceParameter;
            int n = isCorrectedAssumptionByKnowledge ? 1345 : (isCorrectedAssumptionByOppositeSuggestiveQuestion ? 1346 : (isReplacedBySpecificationWithRelation ? (writeSpecificationItem.isSelfGeneratedAssumption() ? 1336 : 1337) : (isAdjustedSpecification ? (writeSpecificationItem.isQuestion() ? 1321 : (writeSpecificationItem.isSelfGeneratedConclusion() ? (writeSpecificationItem.isConcludedAssumption() ? 1316 : (wasHiddenSpanishSpecification ? 1318 : 1317)) : (wasHiddenSpanishSpecification ? 1319 : 1315))) : (interfaceParameter = writeSpecificationItem.isSelfGenerated() ? 1344 : 1343))));
            if (InputOutput.writeInterfaceText(true, (short)4, (short)interfaceParameter) != 1) {
                return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to write a header");
            }
            if (InputOutput.writeText((short)1, writtenSentenceStringBuffer, GlobalVariables.learnedFromUserStringBuffer) != 1) {
                return this.myWordItem_.addErrorInWord(1, this.moduleNameString_, "I failed to write a sentence");
            }
        } else if (isExclusiveSpecification) {
            return this.myWordItem_.startErrorInWord(1, this.moduleNameString_, "I couldn't write the given specification item");
        }
        return 1;
    }
}

